/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.DecisionTaskTimeoutType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecisionTaskTimedOutEventAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DecisionTaskTimedOutEventAttributes> {
    private static final SdkField<String> TIMEOUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeoutType").getter(DecisionTaskTimedOutEventAttributes.getter(DecisionTaskTimedOutEventAttributes::timeoutTypeAsString)).setter(DecisionTaskTimedOutEventAttributes.setter(Builder::timeoutType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutType").build()}).build();
    private static final SdkField<Long> SCHEDULED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("scheduledEventId").getter(DecisionTaskTimedOutEventAttributes.getter(DecisionTaskTimedOutEventAttributes::scheduledEventId)).setter(DecisionTaskTimedOutEventAttributes.setter(Builder::scheduledEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledEventId").build()}).build();
    private static final SdkField<Long> STARTED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startedEventId").getter(DecisionTaskTimedOutEventAttributes.getter(DecisionTaskTimedOutEventAttributes::startedEventId)).setter(DecisionTaskTimedOutEventAttributes.setter(Builder::startedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedEventId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_TYPE_FIELD, SCHEDULED_EVENT_ID_FIELD, STARTED_EVENT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String timeoutType;
    private final Long scheduledEventId;
    private final Long startedEventId;

    private DecisionTaskTimedOutEventAttributes(BuilderImpl builder) {
        this.timeoutType = builder.timeoutType;
        this.scheduledEventId = builder.scheduledEventId;
        this.startedEventId = builder.startedEventId;
    }

    public DecisionTaskTimeoutType timeoutType() {
        return DecisionTaskTimeoutType.fromValue(this.timeoutType);
    }

    public String timeoutTypeAsString() {
        return this.timeoutType;
    }

    public Long scheduledEventId() {
        return this.scheduledEventId;
    }

    public Long startedEventId() {
        return this.startedEventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedEventId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecisionTaskTimedOutEventAttributes)) {
            return false;
        }
        DecisionTaskTimedOutEventAttributes other = (DecisionTaskTimedOutEventAttributes)obj;
        return Objects.equals(this.timeoutTypeAsString(), other.timeoutTypeAsString()) && Objects.equals(this.scheduledEventId(), other.scheduledEventId()) && Objects.equals(this.startedEventId(), other.startedEventId());
    }

    public String toString() {
        return ToString.builder((String)"DecisionTaskTimedOutEventAttributes").add("TimeoutType", (Object)this.timeoutTypeAsString()).add("ScheduledEventId", (Object)this.scheduledEventId()).add("StartedEventId", (Object)this.startedEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeoutType": {
                return Optional.ofNullable(clazz.cast(this.timeoutTypeAsString()));
            }
            case "scheduledEventId": {
                return Optional.ofNullable(clazz.cast(this.scheduledEventId()));
            }
            case "startedEventId": {
                return Optional.ofNullable(clazz.cast(this.startedEventId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecisionTaskTimedOutEventAttributes, T> g) {
        return obj -> g.apply((DecisionTaskTimedOutEventAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String timeoutType;
        private Long scheduledEventId;
        private Long startedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(DecisionTaskTimedOutEventAttributes model) {
            this.timeoutType(model.timeoutType);
            this.scheduledEventId(model.scheduledEventId);
            this.startedEventId(model.startedEventId);
        }

        public final String getTimeoutType() {
            return this.timeoutType;
        }

        @Override
        public final Builder timeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
            return this;
        }

        @Override
        public final Builder timeoutType(DecisionTaskTimeoutType timeoutType) {
            this.timeoutType(timeoutType == null ? null : timeoutType.toString());
            return this;
        }

        public final void setTimeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
        }

        public final Long getScheduledEventId() {
            return this.scheduledEventId;
        }

        @Override
        public final Builder scheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
            return this;
        }

        public final void setScheduledEventId(Long scheduledEventId) {
            this.scheduledEventId = scheduledEventId;
        }

        public final Long getStartedEventId() {
            return this.startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public DecisionTaskTimedOutEventAttributes build() {
            return new DecisionTaskTimedOutEventAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DecisionTaskTimedOutEventAttributes> {
        public Builder timeoutType(String var1);

        public Builder timeoutType(DecisionTaskTimeoutType var1);

        public Builder scheduledEventId(Long var1);

        public Builder startedEventId(Long var1);
    }
}

