/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a workflow execution including timeout values, tasklist etc. These configuration
 * settings are determined from the defaults specified when registering the workflow type and those specified when
 * starting the workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowExecutionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowExecutionConfiguration.Builder, WorkflowExecutionConfiguration> {
    private static final SdkField<String> TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskStartToCloseTimeout").getter(getter(WorkflowExecutionConfiguration::taskStartToCloseTimeout))
            .setter(setter(Builder::taskStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartToCloseTimeout").build())
            .build();

    private static final SdkField<String> EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("executionStartToCloseTimeout")
            .getter(getter(WorkflowExecutionConfiguration::executionStartToCloseTimeout))
            .setter(setter(Builder::executionStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartToCloseTimeout")
                    .build()).build();

    private static final SdkField<TaskList> TASK_LIST_FIELD = SdkField.<TaskList> builder(MarshallingType.SDK_POJO)
            .memberName("taskList").getter(getter(WorkflowExecutionConfiguration::taskList)).setter(setter(Builder::taskList))
            .constructor(TaskList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskList").build()).build();

    private static final SdkField<String> TASK_PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskPriority").getter(getter(WorkflowExecutionConfiguration::taskPriority))
            .setter(setter(Builder::taskPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskPriority").build()).build();

    private static final SdkField<String> CHILD_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("childPolicy").getter(getter(WorkflowExecutionConfiguration::childPolicyAsString))
            .setter(setter(Builder::childPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childPolicy").build()).build();

    private static final SdkField<String> LAMBDA_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaRole").getter(getter(WorkflowExecutionConfiguration::lambdaRole))
            .setter(setter(Builder::lambdaRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TASK_START_TO_CLOSE_TIMEOUT_FIELD, EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, TASK_LIST_FIELD, TASK_PRIORITY_FIELD,
            CHILD_POLICY_FIELD, LAMBDA_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taskStartToCloseTimeout;

    private final String executionStartToCloseTimeout;

    private final TaskList taskList;

    private final String taskPriority;

    private final String childPolicy;

    private final String lambdaRole;

    private WorkflowExecutionConfiguration(BuilderImpl builder) {
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.childPolicy = builder.childPolicy;
        this.lambdaRole = builder.lambdaRole;
    }

    /**
     * <p>
     * The maximum duration allowed for decision tasks for this workflow execution.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The maximum duration allowed for decision tasks for this workflow execution.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public String taskStartToCloseTimeout() {
        return taskStartToCloseTimeout;
    }

    /**
     * <p>
     * The total duration for this workflow execution.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return The total duration for this workflow execution.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public String executionStartToCloseTimeout() {
        return executionStartToCloseTimeout;
    }

    /**
     * <p>
     * The task list used for the decision tasks generated for this workflow execution.
     * </p>
     * 
     * @return The task list used for the decision tasks generated for this workflow execution.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * The priority assigned to decision tasks for this workflow execution. Valid values are integers that range from
     * Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher
     * numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * 
     * @return The priority assigned to decision tasks for this workflow execution. Valid values are integers that range
     *         from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
     *         Higher numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     */
    public String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
     * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #childPolicy} will
     * return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #childPolicyAsString}.
     * </p>
     * 
     * @return The policy to use for the child workflow executions if this workflow execution is terminated, by calling
     *         the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public ChildPolicy childPolicy() {
        return ChildPolicy.fromValue(childPolicy);
    }

    /**
     * <p>
     * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
     * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #childPolicy} will
     * return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #childPolicyAsString}.
     * </p>
     * 
     * @return The policy to use for the child workflow executions if this workflow execution is terminated, by calling
     *         the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public String childPolicyAsString() {
        return childPolicy;
    }

    /**
     * <p>
     * The IAM role attached to the child workflow execution.
     * </p>
     * 
     * @return The IAM role attached to the child workflow execution.
     */
    public String lambdaRole() {
        return lambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(taskList());
        hashCode = 31 * hashCode + Objects.hashCode(taskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(childPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaRole());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionConfiguration)) {
            return false;
        }
        WorkflowExecutionConfiguration other = (WorkflowExecutionConfiguration) obj;
        return Objects.equals(taskStartToCloseTimeout(), other.taskStartToCloseTimeout())
                && Objects.equals(executionStartToCloseTimeout(), other.executionStartToCloseTimeout())
                && Objects.equals(taskList(), other.taskList()) && Objects.equals(taskPriority(), other.taskPriority())
                && Objects.equals(childPolicyAsString(), other.childPolicyAsString())
                && Objects.equals(lambdaRole(), other.lambdaRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WorkflowExecutionConfiguration").add("TaskStartToCloseTimeout", taskStartToCloseTimeout())
                .add("ExecutionStartToCloseTimeout", executionStartToCloseTimeout()).add("TaskList", taskList())
                .add("TaskPriority", taskPriority()).add("ChildPolicy", childPolicyAsString()).add("LambdaRole", lambdaRole())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(taskStartToCloseTimeout()));
        case "executionStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(executionStartToCloseTimeout()));
        case "taskList":
            return Optional.ofNullable(clazz.cast(taskList()));
        case "taskPriority":
            return Optional.ofNullable(clazz.cast(taskPriority()));
        case "childPolicy":
            return Optional.ofNullable(clazz.cast(childPolicyAsString()));
        case "lambdaRole":
            return Optional.ofNullable(clazz.cast(lambdaRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionConfiguration, T> g) {
        return obj -> g.apply((WorkflowExecutionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowExecutionConfiguration> {
        /**
         * <p>
         * The maximum duration allowed for decision tasks for this workflow execution.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param taskStartToCloseTimeout
         *        The maximum duration allowed for decision tasks for this workflow execution.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartToCloseTimeout(String taskStartToCloseTimeout);

        /**
         * <p>
         * The total duration for this workflow execution.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param executionStartToCloseTimeout
         *        The total duration for this workflow execution.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartToCloseTimeout(String executionStartToCloseTimeout);

        /**
         * <p>
         * The task list used for the decision tasks generated for this workflow execution.
         * </p>
         * 
         * @param taskList
         *        The task list used for the decision tasks generated for this workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * The task list used for the decision tasks generated for this workflow execution.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskList.Builder} avoiding the need to create
         * one manually via {@link TaskList#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskList.Builder#build()} is called immediately and its result is
         * passed to {@link #taskList(TaskList)}.
         * 
         * @param taskList
         *        a consumer that will call methods on {@link TaskList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskList(TaskList)
         */
        default Builder taskList(Consumer<TaskList.Builder> taskList) {
            return taskList(TaskList.builder().applyMutation(taskList).build());
        }

        /**
         * <p>
         * The priority assigned to decision tasks for this workflow execution. Valid values are integers that range
         * from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
         * Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * 
         * @param taskPriority
         *        The priority assigned to decision tasks for this workflow execution. Valid values are integers that
         *        range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code>
         *        (2147483647). Higher numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
         * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy to use for the child workflow executions if this workflow execution is terminated, by
         *        calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(String childPolicy);

        /**
         * <p>
         * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
         * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy to use for the child workflow executions if this workflow execution is terminated, by
         *        calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(ChildPolicy childPolicy);

        /**
         * <p>
         * The IAM role attached to the child workflow execution.
         * </p>
         * 
         * @param lambdaRole
         *        The IAM role attached to the child workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaRole(String lambdaRole);
    }

    static final class BuilderImpl implements Builder {
        private String taskStartToCloseTimeout;

        private String executionStartToCloseTimeout;

        private TaskList taskList;

        private String taskPriority;

        private String childPolicy;

        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionConfiguration model) {
            taskStartToCloseTimeout(model.taskStartToCloseTimeout);
            executionStartToCloseTimeout(model.executionStartToCloseTimeout);
            taskList(model.taskList);
            taskPriority(model.taskPriority);
            childPolicy(model.childPolicy);
            lambdaRole(model.lambdaRole);
        }

        public final String getTaskStartToCloseTimeout() {
            return taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        public final String getExecutionStartToCloseTimeout() {
            return executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        public final TaskList.Builder getTaskList() {
            return taskList != null ? taskList.toBuilder() : null;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList.BuilderImpl taskList) {
            this.taskList = taskList != null ? taskList.build() : null;
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getChildPolicy() {
            return childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy == null ? null : childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final String getLambdaRole() {
            return lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        @Override
        public WorkflowExecutionConfiguration build() {
            return new WorkflowExecutionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
