/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterWorkflowTypeRequest extends SwfRequest implements
        ToCopyableBuilder<RegisterWorkflowTypeRequest.Builder, RegisterWorkflowTypeRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(RegisterWorkflowTypeRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RegisterWorkflowTypeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(RegisterWorkflowTypeRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RegisterWorkflowTypeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskStartToCloseTimeout")
            .getter(getter(RegisterWorkflowTypeRequest::defaultTaskStartToCloseTimeout))
            .setter(setter(Builder::defaultTaskStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskStartToCloseTimeout")
                    .build()).build();

    private static final SdkField<String> DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultExecutionStartToCloseTimeout")
            .getter(getter(RegisterWorkflowTypeRequest::defaultExecutionStartToCloseTimeout))
            .setter(setter(Builder::defaultExecutionStartToCloseTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("defaultExecutionStartToCloseTimeout").build()).build();

    private static final SdkField<TaskList> DEFAULT_TASK_LIST_FIELD = SdkField.<TaskList> builder(MarshallingType.SDK_POJO)
            .memberName("defaultTaskList").getter(getter(RegisterWorkflowTypeRequest::defaultTaskList))
            .setter(setter(Builder::defaultTaskList)).constructor(TaskList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskList").build()).build();

    private static final SdkField<String> DEFAULT_TASK_PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultTaskPriority").getter(getter(RegisterWorkflowTypeRequest::defaultTaskPriority))
            .setter(setter(Builder::defaultTaskPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTaskPriority").build())
            .build();

    private static final SdkField<String> DEFAULT_CHILD_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultChildPolicy").getter(getter(RegisterWorkflowTypeRequest::defaultChildPolicyAsString))
            .setter(setter(Builder::defaultChildPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultChildPolicy").build())
            .build();

    private static final SdkField<String> DEFAULT_LAMBDA_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultLambdaRole").getter(getter(RegisterWorkflowTypeRequest::defaultLambdaRole))
            .setter(setter(Builder::defaultLambdaRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLambdaRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, NAME_FIELD,
            VERSION_FIELD, DESCRIPTION_FIELD, DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_FIELD,
            DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_FIELD, DEFAULT_TASK_LIST_FIELD, DEFAULT_TASK_PRIORITY_FIELD,
            DEFAULT_CHILD_POLICY_FIELD, DEFAULT_LAMBDA_ROLE_FIELD));

    private final String domain;

    private final String name;

    private final String version;

    private final String description;

    private final String defaultTaskStartToCloseTimeout;

    private final String defaultExecutionStartToCloseTimeout;

    private final TaskList defaultTaskList;

    private final String defaultTaskPriority;

    private final String defaultChildPolicy;

    private final String defaultLambdaRole;

    private RegisterWorkflowTypeRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.name = builder.name;
        this.version = builder.version;
        this.description = builder.description;
        this.defaultTaskStartToCloseTimeout = builder.defaultTaskStartToCloseTimeout;
        this.defaultExecutionStartToCloseTimeout = builder.defaultExecutionStartToCloseTimeout;
        this.defaultTaskList = builder.defaultTaskList;
        this.defaultTaskPriority = builder.defaultTaskPriority;
        this.defaultChildPolicy = builder.defaultChildPolicy;
        this.defaultLambdaRole = builder.defaultLambdaRole;
    }

    /**
     * <p>
     * The name of the domain in which to register the workflow type.
     * </p>
     * 
     * @return The name of the domain in which to register the workflow type.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The name of the workflow type.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> |
     * <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.
     * </p>
     * 
     * @return The name of the workflow type.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
     *         <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string
     *         <code>arn</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version of the workflow type.
     * </p>
     * <note>
     * <p>
     * The workflow type consists of the name and version, the combination of which must be unique within the domain. To
     * get a list of all currently registered workflow types, use the <a>ListWorkflowTypes</a> action.
     * </p>
     * </note>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code> |
     * <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.
     * </p>
     * 
     * @return The version of the workflow type.</p> <note>
     *         <p>
     *         The workflow type consists of the name and version, the combination of which must be unique within the
     *         domain. To get a list of all currently registered workflow types, use the <a>ListWorkflowTypes</a>
     *         action.
     *         </p>
     *         </note>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
     *         <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string
     *         <code>arn</code>.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * Textual description of the workflow type.
     * </p>
     * 
     * @return Textual description of the workflow type.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * If set, specifies the default maximum duration of decision tasks for this workflow type. This default can be
     * overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the
     * <code>StartChildWorkflowExecution</code> <a>Decision</a>.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     * <code>NONE</code> to specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the default maximum duration of decision tasks for this workflow type. This default can
     *         be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the
     *         <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
     *         <code>NONE</code> to specify unlimited duration.
     */
    public String defaultTaskStartToCloseTimeout() {
        return defaultTaskStartToCloseTimeout;
    }

    /**
     * <p>
     * If set, specifies the default maximum duration for executions of this workflow type. You can override this
     * default when starting an execution through the <a>StartWorkflowExecution</a> Action or
     * <code>StartChildWorkflowExecution</code> <a>Decision</a>.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other timeout
     * parameters in Amazon SWF, you cannot specify a value of "NONE" for
     * <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time that a workflow
     * execution can run. Exceeding this limit always causes the workflow execution to time out.
     * </p>
     * 
     * @return If set, specifies the default maximum duration for executions of this workflow type. You can override
     *         this default when starting an execution through the <a>StartWorkflowExecution</a> Action or
     *         <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other
     *         timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for
     *         <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time that a
     *         workflow execution can run. Exceeding this limit always causes the workflow execution to time out.
     */
    public String defaultExecutionStartToCloseTimeout() {
        return defaultExecutionStartToCloseTimeout;
    }

    /**
     * <p>
     * If set, specifies the default task list to use for scheduling decision tasks for executions of this workflow
     * type. This default is used only if a task list isn't provided when starting the execution through the
     * <a>StartWorkflowExecution</a> Action or <code>StartChildWorkflowExecution</code> <a>Decision</a>.
     * </p>
     * 
     * @return If set, specifies the default task list to use for scheduling decision tasks for executions of this
     *         workflow type. This default is used only if a task list isn't provided when starting the execution
     *         through the <a>StartWorkflowExecution</a> Action or <code>StartChildWorkflowExecution</code>
     *         <a>Decision</a>.
     */
    public TaskList defaultTaskList() {
        return defaultTaskList;
    }

    /**
     * <p>
     * The default task priority to assign to the workflow type. If not assigned, then <code>0</code> is used. Valid
     * values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * 
     * @return The default task priority to assign to the workflow type. If not assigned, then <code>0</code> is used.
     *         Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon SWF Developer Guide</i>.
     */
    public String defaultTaskPriority() {
        return defaultTaskPriority;
    }

    /**
     * <p>
     * If set, specifies the default policy to use for the child workflow executions when a workflow execution of this
     * type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
     * timeout. This default can be overridden when starting a workflow execution using the
     * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultChildPolicy} will return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultChildPolicyAsString}.
     * </p>
     * 
     * @return If set, specifies the default policy to use for the child workflow executions when a workflow execution
     *         of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to
     *         an expired timeout. This default can be overridden when starting a workflow execution using the
     *         <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public ChildPolicy defaultChildPolicy() {
        return ChildPolicy.fromValue(defaultChildPolicy);
    }

    /**
     * <p>
     * If set, specifies the default policy to use for the child workflow executions when a workflow execution of this
     * type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired
     * timeout. This default can be overridden when starting a workflow execution using the
     * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TERMINATE</code> – The child executions are terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ABANDON</code> – No action is taken. The child executions continue to run.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultChildPolicy} will return {@link ChildPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultChildPolicyAsString}.
     * </p>
     * 
     * @return If set, specifies the default policy to use for the child workflow executions when a workflow execution
     *         of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to
     *         an expired timeout. This default can be overridden when starting a workflow execution using the
     *         <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TERMINATE</code> – The child executions are terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ABANDON</code> – No action is taken. The child executions continue to run.
     *         </p>
     *         </li>
     * @see ChildPolicy
     */
    public String defaultChildPolicyAsString() {
        return defaultChildPolicy;
    }

    /**
     * <p>
     * The default IAM role attached to this workflow type.
     * </p>
     * <note>
     * <p>
     * Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role when
     * you start this workflow type, the default Lambda role is attached to the execution. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https://docs.aws.amazon.com/
     * amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * 
     * @return The default IAM role attached to this workflow type.</p> <note>
     *         <p>
     *         Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM
     *         role when you start this workflow type, the default Lambda role is attached to the execution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https
     *         ://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF
     *         Developer Guide</i>.
     *         </p>
     */
    public String defaultLambdaRole() {
        return defaultLambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(defaultExecutionStartToCloseTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskList());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTaskPriority());
        hashCode = 31 * hashCode + Objects.hashCode(defaultChildPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultLambdaRole());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterWorkflowTypeRequest)) {
            return false;
        }
        RegisterWorkflowTypeRequest other = (RegisterWorkflowTypeRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(name(), other.name())
                && Objects.equals(version(), other.version()) && Objects.equals(description(), other.description())
                && Objects.equals(defaultTaskStartToCloseTimeout(), other.defaultTaskStartToCloseTimeout())
                && Objects.equals(defaultExecutionStartToCloseTimeout(), other.defaultExecutionStartToCloseTimeout())
                && Objects.equals(defaultTaskList(), other.defaultTaskList())
                && Objects.equals(defaultTaskPriority(), other.defaultTaskPriority())
                && Objects.equals(defaultChildPolicyAsString(), other.defaultChildPolicyAsString())
                && Objects.equals(defaultLambdaRole(), other.defaultLambdaRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegisterWorkflowTypeRequest").add("Domain", domain()).add("Name", name())
                .add("Version", version()).add("Description", description())
                .add("DefaultTaskStartToCloseTimeout", defaultTaskStartToCloseTimeout())
                .add("DefaultExecutionStartToCloseTimeout", defaultExecutionStartToCloseTimeout())
                .add("DefaultTaskList", defaultTaskList()).add("DefaultTaskPriority", defaultTaskPriority())
                .add("DefaultChildPolicy", defaultChildPolicyAsString()).add("DefaultLambdaRole", defaultLambdaRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "defaultTaskStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(defaultTaskStartToCloseTimeout()));
        case "defaultExecutionStartToCloseTimeout":
            return Optional.ofNullable(clazz.cast(defaultExecutionStartToCloseTimeout()));
        case "defaultTaskList":
            return Optional.ofNullable(clazz.cast(defaultTaskList()));
        case "defaultTaskPriority":
            return Optional.ofNullable(clazz.cast(defaultTaskPriority()));
        case "defaultChildPolicy":
            return Optional.ofNullable(clazz.cast(defaultChildPolicyAsString()));
        case "defaultLambdaRole":
            return Optional.ofNullable(clazz.cast(defaultLambdaRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterWorkflowTypeRequest, T> g) {
        return obj -> g.apply((RegisterWorkflowTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterWorkflowTypeRequest> {
        /**
         * <p>
         * The name of the domain in which to register the workflow type.
         * </p>
         * 
         * @param domain
         *        The name of the domain in which to register the workflow type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The name of the workflow type.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code>
         * | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.
         * </p>
         * 
         * @param name
         *        The name of the workflow type.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
         *        <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal
         *        string <code>arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the workflow type.
         * </p>
         * <note>
         * <p>
         * The workflow type consists of the name and version, the combination of which must be unique within the
         * domain. To get a list of all currently registered workflow types, use the <a>ListWorkflowTypes</a> action.
         * </p>
         * </note>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (<code>\u0000-\u001f</code>
         * | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal string <code>arn</code>.
         * </p>
         * 
         * @param version
         *        The version of the workflow type.</p> <note>
         *        <p>
         *        The workflow type consists of the name and version, the combination of which must be unique within the
         *        domain. To get a list of all currently registered workflow types, use the <a>ListWorkflowTypes</a>
         *        action.
         *        </p>
         *        </note>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (
         *        <code>\u0000-\u001f</code> | <code>\u007f-\u009f</code>). Also, it must not <i>be</i> the literal
         *        string <code>arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Textual description of the workflow type.
         * </p>
         * 
         * @param description
         *        Textual description of the workflow type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If set, specifies the default maximum duration of decision tasks for this workflow type. This default can be
         * overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or the
         * <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         * <code>NONE</code> to specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskStartToCloseTimeout
         *        If set, specifies the default maximum duration of decision tasks for this workflow type. This default
         *        can be overridden when starting a workflow execution using the <a>StartWorkflowExecution</a> action or
         *        the <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>. You can use
         *        <code>NONE</code> to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout);

        /**
         * <p>
         * If set, specifies the default maximum duration for executions of this workflow type. You can override this
         * default when starting an execution through the <a>StartWorkflowExecution</a> Action or
         * <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other timeout
         * parameters in Amazon SWF, you cannot specify a value of "NONE" for
         * <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time that a workflow
         * execution can run. Exceeding this limit always causes the workflow execution to time out.
         * </p>
         * 
         * @param defaultExecutionStartToCloseTimeout
         *        If set, specifies the default maximum duration for executions of this workflow type. You can override
         *        this default when starting an execution through the <a>StartWorkflowExecution</a> Action or
         *        <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other
         *        timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for
         *        <code>defaultExecutionStartToCloseTimeout</code>; there is a one-year max limit on the time that a
         *        workflow execution can run. Exceeding this limit always causes the workflow execution to time out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout);

        /**
         * <p>
         * If set, specifies the default task list to use for scheduling decision tasks for executions of this workflow
         * type. This default is used only if a task list isn't provided when starting the execution through the
         * <a>StartWorkflowExecution</a> Action or <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * 
         * @param defaultTaskList
         *        If set, specifies the default task list to use for scheduling decision tasks for executions of this
         *        workflow type. This default is used only if a task list isn't provided when starting the execution
         *        through the <a>StartWorkflowExecution</a> Action or <code>StartChildWorkflowExecution</code>
         *        <a>Decision</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskList(TaskList defaultTaskList);

        /**
         * <p>
         * If set, specifies the default task list to use for scheduling decision tasks for executions of this workflow
         * type. This default is used only if a task list isn't provided when starting the execution through the
         * <a>StartWorkflowExecution</a> Action or <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskList.Builder} avoiding the need to create
         * one manually via {@link TaskList#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskList.Builder#build()} is called immediately and its result is
         * passed to {@link #defaultTaskList(TaskList)}.
         * 
         * @param defaultTaskList
         *        a consumer that will call methods on {@link TaskList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultTaskList(TaskList)
         */
        default Builder defaultTaskList(Consumer<TaskList.Builder> defaultTaskList) {
            return defaultTaskList(TaskList.builder().applyMutation(defaultTaskList).build());
        }

        /**
         * <p>
         * The default task priority to assign to the workflow type. If not assigned, then <code>0</code> is used. Valid
         * values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * 
         * @param defaultTaskPriority
         *        The default task priority to assign to the workflow type. If not assigned, then <code>0</code> is
         *        used. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon SWF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskPriority(String defaultTaskPriority);

        /**
         * <p>
         * If set, specifies the default policy to use for the child workflow executions when a workflow execution of
         * this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
         * expired timeout. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultChildPolicy
         *        If set, specifies the default policy to use for the child workflow executions when a workflow
         *        execution of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action
         *        explicitly or due to an expired timeout. This default can be overridden when starting a workflow
         *        execution using the <a>StartWorkflowExecution</a> action or the
         *        <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder defaultChildPolicy(String defaultChildPolicy);

        /**
         * <p>
         * If set, specifies the default policy to use for the child workflow executions when a workflow execution of
         * this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
         * expired timeout. This default can be overridden when starting a workflow execution using the
         * <a>StartWorkflowExecution</a> action or the <code>StartChildWorkflowExecution</code> <a>Decision</a>.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TERMINATE</code> – The child executions are terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ABANDON</code> – No action is taken. The child executions continue to run.
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultChildPolicy
         *        If set, specifies the default policy to use for the child workflow executions when a workflow
         *        execution of this type is terminated, by calling the <a>TerminateWorkflowExecution</a> action
         *        explicitly or due to an expired timeout. This default can be overridden when starting a workflow
         *        execution using the <a>StartWorkflowExecution</a> action or the
         *        <code>StartChildWorkflowExecution</code> <a>Decision</a>.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TERMINATE</code> – The child executions are terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REQUEST_CANCEL</code> – A request to cancel is attempted for each child execution by recording a
         *        <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ABANDON</code> – No action is taken. The child executions continue to run.
         *        </p>
         *        </li>
         * @see ChildPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder defaultChildPolicy(ChildPolicy defaultChildPolicy);

        /**
         * <p>
         * The default IAM role attached to this workflow type.
         * </p>
         * <note>
         * <p>
         * Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role
         * when you start this workflow type, the default Lambda role is attached to the execution. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html">https:
         * //docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF Developer
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param defaultLambdaRole
         *        The default IAM role attached to this workflow type.</p> <note>
         *        <p>
         *        Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an
         *        IAM role when you start this workflow type, the default Lambda role is attached to the execution. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html"
         *        >https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html</a> in the <i>Amazon SWF
         *        Developer Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultLambdaRole(String defaultLambdaRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private String name;

        private String version;

        private String description;

        private String defaultTaskStartToCloseTimeout;

        private String defaultExecutionStartToCloseTimeout;

        private TaskList defaultTaskList;

        private String defaultTaskPriority;

        private String defaultChildPolicy;

        private String defaultLambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterWorkflowTypeRequest model) {
            super(model);
            domain(model.domain);
            name(model.name);
            version(model.version);
            description(model.description);
            defaultTaskStartToCloseTimeout(model.defaultTaskStartToCloseTimeout);
            defaultExecutionStartToCloseTimeout(model.defaultExecutionStartToCloseTimeout);
            defaultTaskList(model.defaultTaskList);
            defaultTaskPriority(model.defaultTaskPriority);
            defaultChildPolicy(model.defaultChildPolicy);
            defaultLambdaRole(model.defaultLambdaRole);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultTaskStartToCloseTimeout() {
            return defaultTaskStartToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
            return this;
        }

        public final void setDefaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
        }

        public final String getDefaultExecutionStartToCloseTimeout() {
            return defaultExecutionStartToCloseTimeout;
        }

        @Override
        public final Builder defaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
            return this;
        }

        public final void setDefaultExecutionStartToCloseTimeout(String defaultExecutionStartToCloseTimeout) {
            this.defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout;
        }

        public final TaskList.Builder getDefaultTaskList() {
            return defaultTaskList != null ? defaultTaskList.toBuilder() : null;
        }

        @Override
        public final Builder defaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
            return this;
        }

        public final void setDefaultTaskList(TaskList.BuilderImpl defaultTaskList) {
            this.defaultTaskList = defaultTaskList != null ? defaultTaskList.build() : null;
        }

        public final String getDefaultTaskPriority() {
            return defaultTaskPriority;
        }

        @Override
        public final Builder defaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
            return this;
        }

        public final void setDefaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
        }

        public final String getDefaultChildPolicy() {
            return defaultChildPolicy;
        }

        @Override
        public final Builder defaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
            return this;
        }

        @Override
        public final Builder defaultChildPolicy(ChildPolicy defaultChildPolicy) {
            this.defaultChildPolicy(defaultChildPolicy == null ? null : defaultChildPolicy.toString());
            return this;
        }

        public final void setDefaultChildPolicy(String defaultChildPolicy) {
            this.defaultChildPolicy = defaultChildPolicy;
        }

        public final String getDefaultLambdaRole() {
            return defaultLambdaRole;
        }

        @Override
        public final Builder defaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
            return this;
        }

        public final void setDefaultLambdaRole(String defaultLambdaRole) {
            this.defaultLambdaRole = defaultLambdaRole;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterWorkflowTypeRequest build() {
            return new RegisterWorkflowTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
