/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClosedWorkflowExecutionsRequest extends SwfRequest implements
        ToCopyableBuilder<ListClosedWorkflowExecutionsRequest.Builder, ListClosedWorkflowExecutionsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(ListClosedWorkflowExecutionsRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<ExecutionTimeFilter> START_TIME_FILTER_FIELD = SdkField
            .<ExecutionTimeFilter> builder(MarshallingType.SDK_POJO).memberName("startTimeFilter")
            .getter(getter(ListClosedWorkflowExecutionsRequest::startTimeFilter)).setter(setter(Builder::startTimeFilter))
            .constructor(ExecutionTimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeFilter").build()).build();

    private static final SdkField<ExecutionTimeFilter> CLOSE_TIME_FILTER_FIELD = SdkField
            .<ExecutionTimeFilter> builder(MarshallingType.SDK_POJO).memberName("closeTimeFilter")
            .getter(getter(ListClosedWorkflowExecutionsRequest::closeTimeFilter)).setter(setter(Builder::closeTimeFilter))
            .constructor(ExecutionTimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closeTimeFilter").build()).build();

    private static final SdkField<WorkflowExecutionFilter> EXECUTION_FILTER_FIELD = SdkField
            .<WorkflowExecutionFilter> builder(MarshallingType.SDK_POJO).memberName("executionFilter")
            .getter(getter(ListClosedWorkflowExecutionsRequest::executionFilter)).setter(setter(Builder::executionFilter))
            .constructor(WorkflowExecutionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionFilter").build()).build();

    private static final SdkField<CloseStatusFilter> CLOSE_STATUS_FILTER_FIELD = SdkField
            .<CloseStatusFilter> builder(MarshallingType.SDK_POJO).memberName("closeStatusFilter")
            .getter(getter(ListClosedWorkflowExecutionsRequest::closeStatusFilter)).setter(setter(Builder::closeStatusFilter))
            .constructor(CloseStatusFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closeStatusFilter").build()).build();

    private static final SdkField<WorkflowTypeFilter> TYPE_FILTER_FIELD = SdkField
            .<WorkflowTypeFilter> builder(MarshallingType.SDK_POJO).memberName("typeFilter")
            .getter(getter(ListClosedWorkflowExecutionsRequest::typeFilter)).setter(setter(Builder::typeFilter))
            .constructor(WorkflowTypeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeFilter").build()).build();

    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
            .memberName("tagFilter").getter(getter(ListClosedWorkflowExecutionsRequest::tagFilter))
            .setter(setter(Builder::tagFilter)).constructor(TagFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(ListClosedWorkflowExecutionsRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final SdkField<Integer> MAXIMUM_PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumPageSize").getter(getter(ListClosedWorkflowExecutionsRequest::maximumPageSize))
            .setter(setter(Builder::maximumPageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPageSize").build()).build();

    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("reverseOrder").getter(getter(ListClosedWorkflowExecutionsRequest::reverseOrder))
            .setter(setter(Builder::reverseOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverseOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            START_TIME_FILTER_FIELD, CLOSE_TIME_FILTER_FIELD, EXECUTION_FILTER_FIELD, CLOSE_STATUS_FILTER_FIELD,
            TYPE_FILTER_FIELD, TAG_FILTER_FIELD, NEXT_PAGE_TOKEN_FIELD, MAXIMUM_PAGE_SIZE_FIELD, REVERSE_ORDER_FIELD));

    private final String domain;

    private final ExecutionTimeFilter startTimeFilter;

    private final ExecutionTimeFilter closeTimeFilter;

    private final WorkflowExecutionFilter executionFilter;

    private final CloseStatusFilter closeStatusFilter;

    private final WorkflowTypeFilter typeFilter;

    private final TagFilter tagFilter;

    private final String nextPageToken;

    private final Integer maximumPageSize;

    private final Boolean reverseOrder;

    private ListClosedWorkflowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.startTimeFilter = builder.startTimeFilter;
        this.closeTimeFilter = builder.closeTimeFilter;
        this.executionFilter = builder.executionFilter;
        this.closeStatusFilter = builder.closeStatusFilter;
        this.typeFilter = builder.typeFilter;
        this.tagFilter = builder.tagFilter;
        this.nextPageToken = builder.nextPageToken;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
    }

    /**
     * <p>
     * The name of the domain that contains the workflow executions to list.
     * </p>
     * 
     * @return The name of the domain that contains the workflow executions to list.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * If specified, the workflow executions are included in the returned results based on whether their start times are
     * within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered
     * by their start times.
     * </p>
     * <note>
     * <p>
     * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
     * these in a request but not both.
     * </p>
     * </note>
     * 
     * @return If specified, the workflow executions are included in the returned results based on whether their start
     *         times are within the range specified by this filter. Also, if this parameter is specified, the returned
     *         results are ordered by their start times.</p> <note>
     *         <p>
     *         <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify
     *         one of these in a request but not both.
     *         </p>
     */
    public ExecutionTimeFilter startTimeFilter() {
        return startTimeFilter;
    }

    /**
     * <p>
     * If specified, the workflow executions are included in the returned results based on whether their close times are
     * within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered
     * by their close times.
     * </p>
     * <note>
     * <p>
     * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
     * these in a request but not both.
     * </p>
     * </note>
     * 
     * @return If specified, the workflow executions are included in the returned results based on whether their close
     *         times are within the range specified by this filter. Also, if this parameter is specified, the returned
     *         results are ordered by their close times.</p> <note>
     *         <p>
     *         <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify
     *         one of these in a request but not both.
     *         </p>
     */
    public ExecutionTimeFilter closeTimeFilter() {
        return closeTimeFilter;
    }

    /**
     * <p>
     * If specified, only workflow executions matching the workflow ID specified in the filter are returned.
     * </p>
     * <note>
     * <p>
     * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code>
     * are mutually exclusive. You can specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only workflow executions matching the workflow ID specified in the filter are returned.</p>
     *         <note>
     *         <p>
     *         <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     *         <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     *         </p>
     */
    public WorkflowExecutionFilter executionFilter() {
        return executionFilter;
    }

    /**
     * <p>
     * If specified, only workflow executions that match this <i>close status</i> are listed. For example, if TERMINATED
     * is specified, then only TERMINATED workflow executions are listed.
     * </p>
     * <note>
     * <p>
     * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code>
     * are mutually exclusive. You can specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only workflow executions that match this <i>close status</i> are listed. For example, if
     *         TERMINATED is specified, then only TERMINATED workflow executions are listed.</p> <note>
     *         <p>
     *         <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     *         <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     *         </p>
     */
    public CloseStatusFilter closeStatusFilter() {
        return closeStatusFilter;
    }

    /**
     * <p>
     * If specified, only executions of the type specified in the filter are returned.
     * </p>
     * <note>
     * <p>
     * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code>
     * are mutually exclusive. You can specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only executions of the type specified in the filter are returned.</p> <note>
     *         <p>
     *         <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     *         <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     *         </p>
     */
    public WorkflowTypeFilter typeFilter() {
        return typeFilter;
    }

    /**
     * <p>
     * If specified, only executions that have the matching tag are listed.
     * </p>
     * <note>
     * <p>
     * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and <code>tagFilter</code>
     * are mutually exclusive. You can specify at most one of these in a request.
     * </p>
     * </note>
     * 
     * @return If specified, only executions that have the matching tag are listed.</p> <note>
     *         <p>
     *         <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
     *         <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
     *         </p>
     */
    public TagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * <p>
     * If <code>NextPageToken</code> is returned there are more results available. The value of
     * <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned
     * token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60
     * seconds. Using an expired pagination token will return a <code>400</code> error: "
     * <code>Specified token has exceeded its maximum lifetime</code>".
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If <code>NextPageToken</code> is returned there are more results available. The value of
     *         <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the
     *         returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
     *         expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "
     *         <code>Specified token has exceeded its maximum lifetime</code>". </p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further pages
     * of results.
     * </p>
     * 
     * @return The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain
     *         further pages of results.
     */
    public Integer maximumPageSize() {
        return maximumPageSize;
    }

    /**
     * <p>
     * When set to <code>true</code>, returns the results in reverse order. By default the results are returned in
     * descending order of the start or the close time of the executions.
     * </p>
     * 
     * @return When set to <code>true</code>, returns the results in reverse order. By default the results are returned
     *         in descending order of the start or the close time of the executions.
     */
    public Boolean reverseOrder() {
        return reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(closeTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(executionFilter());
        hashCode = 31 * hashCode + Objects.hashCode(closeStatusFilter());
        hashCode = 31 * hashCode + Objects.hashCode(typeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(reverseOrder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClosedWorkflowExecutionsRequest)) {
            return false;
        }
        ListClosedWorkflowExecutionsRequest other = (ListClosedWorkflowExecutionsRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(startTimeFilter(), other.startTimeFilter())
                && Objects.equals(closeTimeFilter(), other.closeTimeFilter())
                && Objects.equals(executionFilter(), other.executionFilter())
                && Objects.equals(closeStatusFilter(), other.closeStatusFilter())
                && Objects.equals(typeFilter(), other.typeFilter()) && Objects.equals(tagFilter(), other.tagFilter())
                && Objects.equals(nextPageToken(), other.nextPageToken())
                && Objects.equals(maximumPageSize(), other.maximumPageSize())
                && Objects.equals(reverseOrder(), other.reverseOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListClosedWorkflowExecutionsRequest").add("Domain", domain())
                .add("StartTimeFilter", startTimeFilter()).add("CloseTimeFilter", closeTimeFilter())
                .add("ExecutionFilter", executionFilter()).add("CloseStatusFilter", closeStatusFilter())
                .add("TypeFilter", typeFilter()).add("TagFilter", tagFilter()).add("NextPageToken", nextPageToken())
                .add("MaximumPageSize", maximumPageSize()).add("ReverseOrder", reverseOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "startTimeFilter":
            return Optional.ofNullable(clazz.cast(startTimeFilter()));
        case "closeTimeFilter":
            return Optional.ofNullable(clazz.cast(closeTimeFilter()));
        case "executionFilter":
            return Optional.ofNullable(clazz.cast(executionFilter()));
        case "closeStatusFilter":
            return Optional.ofNullable(clazz.cast(closeStatusFilter()));
        case "typeFilter":
            return Optional.ofNullable(clazz.cast(typeFilter()));
        case "tagFilter":
            return Optional.ofNullable(clazz.cast(tagFilter()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "maximumPageSize":
            return Optional.ofNullable(clazz.cast(maximumPageSize()));
        case "reverseOrder":
            return Optional.ofNullable(clazz.cast(reverseOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClosedWorkflowExecutionsRequest, T> g) {
        return obj -> g.apply((ListClosedWorkflowExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListClosedWorkflowExecutionsRequest> {
        /**
         * <p>
         * The name of the domain that contains the workflow executions to list.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the workflow executions to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * If specified, the workflow executions are included in the returned results based on whether their start times
         * are within the range specified by this filter. Also, if this parameter is specified, the returned results are
         * ordered by their start times.
         * </p>
         * <note>
         * <p>
         * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
         * these in a request but not both.
         * </p>
         * </note>
         * 
         * @param startTimeFilter
         *        If specified, the workflow executions are included in the returned results based on whether their
         *        start times are within the range specified by this filter. Also, if this parameter is specified, the
         *        returned results are ordered by their start times.</p> <note>
         *        <p>
         *        <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify
         *        one of these in a request but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeFilter(ExecutionTimeFilter startTimeFilter);

        /**
         * <p>
         * If specified, the workflow executions are included in the returned results based on whether their start times
         * are within the range specified by this filter. Also, if this parameter is specified, the returned results are
         * ordered by their start times.
         * </p>
         * <note>
         * <p>
         * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
         * these in a request but not both.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link ExecutionTimeFilter.Builder} avoiding
         * the need to create one manually via {@link ExecutionTimeFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionTimeFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #startTimeFilter(ExecutionTimeFilter)}.
         * 
         * @param startTimeFilter
         *        a consumer that will call methods on {@link ExecutionTimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimeFilter(ExecutionTimeFilter)
         */
        default Builder startTimeFilter(Consumer<ExecutionTimeFilter.Builder> startTimeFilter) {
            return startTimeFilter(ExecutionTimeFilter.builder().applyMutation(startTimeFilter).build());
        }

        /**
         * <p>
         * If specified, the workflow executions are included in the returned results based on whether their close times
         * are within the range specified by this filter. Also, if this parameter is specified, the returned results are
         * ordered by their close times.
         * </p>
         * <note>
         * <p>
         * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
         * these in a request but not both.
         * </p>
         * </note>
         * 
         * @param closeTimeFilter
         *        If specified, the workflow executions are included in the returned results based on whether their
         *        close times are within the range specified by this filter. Also, if this parameter is specified, the
         *        returned results are ordered by their close times.</p> <note>
         *        <p>
         *        <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify
         *        one of these in a request but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closeTimeFilter(ExecutionTimeFilter closeTimeFilter);

        /**
         * <p>
         * If specified, the workflow executions are included in the returned results based on whether their close times
         * are within the range specified by this filter. Also, if this parameter is specified, the returned results are
         * ordered by their close times.
         * </p>
         * <note>
         * <p>
         * <code>startTimeFilter</code> and <code>closeTimeFilter</code> are mutually exclusive. You must specify one of
         * these in a request but not both.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link ExecutionTimeFilter.Builder} avoiding
         * the need to create one manually via {@link ExecutionTimeFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionTimeFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #closeTimeFilter(ExecutionTimeFilter)}.
         * 
         * @param closeTimeFilter
         *        a consumer that will call methods on {@link ExecutionTimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #closeTimeFilter(ExecutionTimeFilter)
         */
        default Builder closeTimeFilter(Consumer<ExecutionTimeFilter.Builder> closeTimeFilter) {
            return closeTimeFilter(ExecutionTimeFilter.builder().applyMutation(closeTimeFilter).build());
        }

        /**
         * <p>
         * If specified, only workflow executions matching the workflow ID specified in the filter are returned.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param executionFilter
         *        If specified, only workflow executions matching the workflow ID specified in the filter are
         *        returned.</p> <note>
         *        <p>
         *        <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         *        <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionFilter(WorkflowExecutionFilter executionFilter);

        /**
         * <p>
         * If specified, only workflow executions matching the workflow ID specified in the filter are returned.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link WorkflowExecutionFilter.Builder}
         * avoiding the need to create one manually via {@link WorkflowExecutionFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowExecutionFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #executionFilter(WorkflowExecutionFilter)}.
         * 
         * @param executionFilter
         *        a consumer that will call methods on {@link WorkflowExecutionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionFilter(WorkflowExecutionFilter)
         */
        default Builder executionFilter(Consumer<WorkflowExecutionFilter.Builder> executionFilter) {
            return executionFilter(WorkflowExecutionFilter.builder().applyMutation(executionFilter).build());
        }

        /**
         * <p>
         * If specified, only workflow executions that match this <i>close status</i> are listed. For example, if
         * TERMINATED is specified, then only TERMINATED workflow executions are listed.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param closeStatusFilter
         *        If specified, only workflow executions that match this <i>close status</i> are listed. For example, if
         *        TERMINATED is specified, then only TERMINATED workflow executions are listed.</p> <note>
         *        <p>
         *        <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         *        <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closeStatusFilter(CloseStatusFilter closeStatusFilter);

        /**
         * <p>
         * If specified, only workflow executions that match this <i>close status</i> are listed. For example, if
         * TERMINATED is specified, then only TERMINATED workflow executions are listed.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link CloseStatusFilter.Builder} avoiding the
         * need to create one manually via {@link CloseStatusFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloseStatusFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #closeStatusFilter(CloseStatusFilter)}.
         * 
         * @param closeStatusFilter
         *        a consumer that will call methods on {@link CloseStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #closeStatusFilter(CloseStatusFilter)
         */
        default Builder closeStatusFilter(Consumer<CloseStatusFilter.Builder> closeStatusFilter) {
            return closeStatusFilter(CloseStatusFilter.builder().applyMutation(closeStatusFilter).build());
        }

        /**
         * <p>
         * If specified, only executions of the type specified in the filter are returned.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param typeFilter
         *        If specified, only executions of the type specified in the filter are returned.</p> <note>
         *        <p>
         *        <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         *        <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeFilter(WorkflowTypeFilter typeFilter);

        /**
         * <p>
         * If specified, only executions of the type specified in the filter are returned.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link WorkflowTypeFilter.Builder} avoiding the
         * need to create one manually via {@link WorkflowTypeFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowTypeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #typeFilter(WorkflowTypeFilter)}.
         * 
         * @param typeFilter
         *        a consumer that will call methods on {@link WorkflowTypeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeFilter(WorkflowTypeFilter)
         */
        default Builder typeFilter(Consumer<WorkflowTypeFilter.Builder> typeFilter) {
            return typeFilter(WorkflowTypeFilter.builder().applyMutation(typeFilter).build());
        }

        /**
         * <p>
         * If specified, only executions that have the matching tag are listed.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note>
         * 
         * @param tagFilter
         *        If specified, only executions that have the matching tag are listed.</p> <note>
         *        <p>
         *        <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         *        <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(TagFilter tagFilter);

        /**
         * <p>
         * If specified, only executions that have the matching tag are listed.
         * </p>
         * <note>
         * <p>
         * <code>closeStatusFilter</code>, <code>executionFilter</code>, <code>typeFilter</code> and
         * <code>tagFilter</code> are mutually exclusive. You can specify at most one of these in a request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link TagFilter.Builder} avoiding the need to
         * create one manually via {@link TagFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link TagFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #tagFilter(TagFilter)}.
         * 
         * @param tagFilter
         *        a consumer that will call methods on {@link TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilter(TagFilter)
         */
        default Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return tagFilter(TagFilter.builder().applyMutation(tagFilter).build());
        }

        /**
         * <p>
         * If <code>NextPageToken</code> is returned there are more results available. The value of
         * <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60
         * seconds. Using an expired pagination token will return a <code>400</code> error: "
         * <code>Specified token has exceeded its maximum lifetime</code>".
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If <code>NextPageToken</code> is returned there are more results available. The value of
         *        <code>NextPageToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 60 seconds. Using an expired pagination token will return a <code>400</code> error: "
         *        <code>Specified token has exceeded its maximum lifetime</code>". </p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain further
         * pages of results.
         * </p>
         * 
         * @param maximumPageSize
         *        The maximum number of results that are returned per call. Use <code>nextPageToken</code> to obtain
         *        further pages of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPageSize(Integer maximumPageSize);

        /**
         * <p>
         * When set to <code>true</code>, returns the results in reverse order. By default the results are returned in
         * descending order of the start or the close time of the executions.
         * </p>
         * 
         * @param reverseOrder
         *        When set to <code>true</code>, returns the results in reverse order. By default the results are
         *        returned in descending order of the start or the close time of the executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SwfRequest.BuilderImpl implements Builder {
        private String domain;

        private ExecutionTimeFilter startTimeFilter;

        private ExecutionTimeFilter closeTimeFilter;

        private WorkflowExecutionFilter executionFilter;

        private CloseStatusFilter closeStatusFilter;

        private WorkflowTypeFilter typeFilter;

        private TagFilter tagFilter;

        private String nextPageToken;

        private Integer maximumPageSize;

        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClosedWorkflowExecutionsRequest model) {
            super(model);
            domain(model.domain);
            startTimeFilter(model.startTimeFilter);
            closeTimeFilter(model.closeTimeFilter);
            executionFilter(model.executionFilter);
            closeStatusFilter(model.closeStatusFilter);
            typeFilter(model.typeFilter);
            tagFilter(model.tagFilter);
            nextPageToken(model.nextPageToken);
            maximumPageSize(model.maximumPageSize);
            reverseOrder(model.reverseOrder);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final ExecutionTimeFilter.Builder getStartTimeFilter() {
            return startTimeFilter != null ? startTimeFilter.toBuilder() : null;
        }

        @Override
        public final Builder startTimeFilter(ExecutionTimeFilter startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final void setStartTimeFilter(ExecutionTimeFilter.BuilderImpl startTimeFilter) {
            this.startTimeFilter = startTimeFilter != null ? startTimeFilter.build() : null;
        }

        public final ExecutionTimeFilter.Builder getCloseTimeFilter() {
            return closeTimeFilter != null ? closeTimeFilter.toBuilder() : null;
        }

        @Override
        public final Builder closeTimeFilter(ExecutionTimeFilter closeTimeFilter) {
            this.closeTimeFilter = closeTimeFilter;
            return this;
        }

        public final void setCloseTimeFilter(ExecutionTimeFilter.BuilderImpl closeTimeFilter) {
            this.closeTimeFilter = closeTimeFilter != null ? closeTimeFilter.build() : null;
        }

        public final WorkflowExecutionFilter.Builder getExecutionFilter() {
            return executionFilter != null ? executionFilter.toBuilder() : null;
        }

        @Override
        public final Builder executionFilter(WorkflowExecutionFilter executionFilter) {
            this.executionFilter = executionFilter;
            return this;
        }

        public final void setExecutionFilter(WorkflowExecutionFilter.BuilderImpl executionFilter) {
            this.executionFilter = executionFilter != null ? executionFilter.build() : null;
        }

        public final CloseStatusFilter.Builder getCloseStatusFilter() {
            return closeStatusFilter != null ? closeStatusFilter.toBuilder() : null;
        }

        @Override
        public final Builder closeStatusFilter(CloseStatusFilter closeStatusFilter) {
            this.closeStatusFilter = closeStatusFilter;
            return this;
        }

        public final void setCloseStatusFilter(CloseStatusFilter.BuilderImpl closeStatusFilter) {
            this.closeStatusFilter = closeStatusFilter != null ? closeStatusFilter.build() : null;
        }

        public final WorkflowTypeFilter.Builder getTypeFilter() {
            return typeFilter != null ? typeFilter.toBuilder() : null;
        }

        @Override
        public final Builder typeFilter(WorkflowTypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public final void setTypeFilter(WorkflowTypeFilter.BuilderImpl typeFilter) {
            this.typeFilter = typeFilter != null ? typeFilter.build() : null;
        }

        public final TagFilter.Builder getTagFilter() {
            return tagFilter != null ? tagFilter.toBuilder() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Integer getMaximumPageSize() {
            return maximumPageSize;
        }

        @Override
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClosedWorkflowExecutionsRequest build() {
            return new ListClosedWorkflowExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
