/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedCause;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignalExternalWorkflowExecutionFailedEventAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SignalExternalWorkflowExecutionFailedEventAttributes> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SignalExternalWorkflowExecutionFailedEventAttributes.getter(SignalExternalWorkflowExecutionFailedEventAttributes::workflowId)).setter(SignalExternalWorkflowExecutionFailedEventAttributes.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SignalExternalWorkflowExecutionFailedEventAttributes.getter(SignalExternalWorkflowExecutionFailedEventAttributes::runId)).setter(SignalExternalWorkflowExecutionFailedEventAttributes.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()}).build();
    private static final SdkField<String> CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SignalExternalWorkflowExecutionFailedEventAttributes.getter(SignalExternalWorkflowExecutionFailedEventAttributes::causeAsString)).setter(SignalExternalWorkflowExecutionFailedEventAttributes.setter(Builder::cause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()}).build();
    private static final SdkField<Long> INITIATED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(SignalExternalWorkflowExecutionFailedEventAttributes.getter(SignalExternalWorkflowExecutionFailedEventAttributes::initiatedEventId)).setter(SignalExternalWorkflowExecutionFailedEventAttributes.setter(Builder::initiatedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiatedEventId").build()}).build();
    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(SignalExternalWorkflowExecutionFailedEventAttributes.getter(SignalExternalWorkflowExecutionFailedEventAttributes::decisionTaskCompletedEventId)).setter(SignalExternalWorkflowExecutionFailedEventAttributes.setter(Builder::decisionTaskCompletedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId").build()}).build();
    private static final SdkField<String> CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SignalExternalWorkflowExecutionFailedEventAttributes.getter(SignalExternalWorkflowExecutionFailedEventAttributes::control)).setter(SignalExternalWorkflowExecutionFailedEventAttributes.setter(Builder::control)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD, RUN_ID_FIELD, CAUSE_FIELD, INITIATED_EVENT_ID_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD, CONTROL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String workflowId;
    private final String runId;
    private final String causeValue;
    private final Long initiatedEventId;
    private final Long decisionTaskCompletedEventId;
    private final String control;

    private SignalExternalWorkflowExecutionFailedEventAttributes(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
        this.causeValue = builder.causeValue;
        this.initiatedEventId = builder.initiatedEventId;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
        this.control = builder.control;
    }

    public String workflowId() {
        return this.workflowId;
    }

    public String runId() {
        return this.runId;
    }

    public SignalExternalWorkflowExecutionFailedCause cause() {
        return SignalExternalWorkflowExecutionFailedCause.fromValue(this.causeValue);
    }

    public String causeAsString() {
        return this.causeValue;
    }

    public Long initiatedEventId() {
        return this.initiatedEventId;
    }

    public Long decisionTaskCompletedEventId() {
        return this.decisionTaskCompletedEventId;
    }

    public String control() {
        return this.control;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.causeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.decisionTaskCompletedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.control());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalExternalWorkflowExecutionFailedEventAttributes)) {
            return false;
        }
        SignalExternalWorkflowExecutionFailedEventAttributes other = (SignalExternalWorkflowExecutionFailedEventAttributes)obj;
        return Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.causeAsString(), other.causeAsString()) && Objects.equals(this.initiatedEventId(), other.initiatedEventId()) && Objects.equals(this.decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId()) && Objects.equals(this.control(), other.control());
    }

    public String toString() {
        return ToString.builder((String)"SignalExternalWorkflowExecutionFailedEventAttributes").add("WorkflowId", (Object)this.workflowId()).add("RunId", (Object)this.runId()).add("Cause", (Object)this.causeAsString()).add("InitiatedEventId", (Object)this.initiatedEventId()).add("DecisionTaskCompletedEventId", (Object)this.decisionTaskCompletedEventId()).add("Control", (Object)this.control()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "runId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "cause": {
                return Optional.ofNullable(clazz.cast(this.causeAsString()));
            }
            case "initiatedEventId": {
                return Optional.ofNullable(clazz.cast(this.initiatedEventId()));
            }
            case "decisionTaskCompletedEventId": {
                return Optional.ofNullable(clazz.cast(this.decisionTaskCompletedEventId()));
            }
            case "control": {
                return Optional.ofNullable(clazz.cast(this.control()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignalExternalWorkflowExecutionFailedEventAttributes, T> g) {
        return obj -> g.apply((SignalExternalWorkflowExecutionFailedEventAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workflowId;
        private String runId;
        private String causeValue;
        private Long initiatedEventId;
        private Long decisionTaskCompletedEventId;
        private String control;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalExternalWorkflowExecutionFailedEventAttributes model) {
            this.workflowId(model.workflowId);
            this.runId(model.runId);
            this.cause(model.causeValue);
            this.initiatedEventId(model.initiatedEventId);
            this.decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
            this.control(model.control);
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getRunId() {
            return this.runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final String getCause() {
            return this.causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public final Builder cause(SignalExternalWorkflowExecutionFailedCause causeValue) {
            this.cause(causeValue == null ? null : causeValue.toString());
            return this;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        public final Long getInitiatedEventId() {
            return this.initiatedEventId;
        }

        @Override
        public final Builder initiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
            return this;
        }

        public final void setInitiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return this.decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        public final String getControl() {
            return this.control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public SignalExternalWorkflowExecutionFailedEventAttributes build() {
            return new SignalExternalWorkflowExecutionFailedEventAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SignalExternalWorkflowExecutionFailedEventAttributes> {
        public Builder workflowId(String var1);

        public Builder runId(String var1);

        public Builder cause(String var1);

        public Builder cause(SignalExternalWorkflowExecutionFailedCause var1);

        public Builder initiatedEventId(Long var1);

        public Builder decisionTaskCompletedEventId(Long var1);

        public Builder control(String var1);
    }
}

