/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.swf.model.CloseStatus;
import software.amazon.awssdk.services.swf.model.ExecutionStatus;
import software.amazon.awssdk.services.swf.model.TagListCopier;
import software.amazon.awssdk.services.swf.model.WorkflowExecution;
import software.amazon.awssdk.services.swf.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowExecutionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowExecutionInfo> {
    private static final SdkField<WorkflowExecution> EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WorkflowExecutionInfo.getter(WorkflowExecutionInfo::execution)).setter(WorkflowExecutionInfo.setter(Builder::execution)).constructor(WorkflowExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("execution").build()}).build();
    private static final SdkField<WorkflowType> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WorkflowExecutionInfo.getter(WorkflowExecutionInfo::workflowType)).setter(WorkflowExecutionInfo.setter(Builder::workflowType)).constructor(WorkflowType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(WorkflowExecutionInfo.getter(WorkflowExecutionInfo::startTimestamp)).setter(WorkflowExecutionInfo.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimestamp").build()}).build();
    private static final SdkField<Instant> CLOSE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(WorkflowExecutionInfo.getter(WorkflowExecutionInfo::closeTimestamp)).setter(WorkflowExecutionInfo.setter(Builder::closeTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closeTimestamp").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkflowExecutionInfo.getter(WorkflowExecutionInfo::executionStatusAsString)).setter(WorkflowExecutionInfo.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()}).build();
    private static final SdkField<String> CLOSE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkflowExecutionInfo.getter(WorkflowExecutionInfo::closeStatusAsString)).setter(WorkflowExecutionInfo.setter(Builder::closeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closeStatus").build()}).build();
    private static final SdkField<WorkflowExecution> PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WorkflowExecutionInfo.getter(WorkflowExecutionInfo::parent)).setter(WorkflowExecutionInfo.setter(Builder::parent)).constructor(WorkflowExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parent").build()}).build();
    private static final SdkField<List<String>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(WorkflowExecutionInfo.getter(WorkflowExecutionInfo::tagList)).setter(WorkflowExecutionInfo.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CANCEL_REQUESTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(WorkflowExecutionInfo.getter(WorkflowExecutionInfo::cancelRequested)).setter(WorkflowExecutionInfo.setter(Builder::cancelRequested)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancelRequested").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_FIELD, WORKFLOW_TYPE_FIELD, START_TIMESTAMP_FIELD, CLOSE_TIMESTAMP_FIELD, EXECUTION_STATUS_FIELD, CLOSE_STATUS_FIELD, PARENT_FIELD, TAG_LIST_FIELD, CANCEL_REQUESTED_FIELD));
    private static final long serialVersionUID = 1L;
    private final WorkflowExecution execution;
    private final WorkflowType workflowType;
    private final Instant startTimestamp;
    private final Instant closeTimestamp;
    private final String executionStatus;
    private final String closeStatus;
    private final WorkflowExecution parent;
    private final List<String> tagList;
    private final Boolean cancelRequested;

    private WorkflowExecutionInfo(BuilderImpl builder) {
        this.execution = builder.execution;
        this.workflowType = builder.workflowType;
        this.startTimestamp = builder.startTimestamp;
        this.closeTimestamp = builder.closeTimestamp;
        this.executionStatus = builder.executionStatus;
        this.closeStatus = builder.closeStatus;
        this.parent = builder.parent;
        this.tagList = builder.tagList;
        this.cancelRequested = builder.cancelRequested;
    }

    public WorkflowExecution execution() {
        return this.execution;
    }

    public WorkflowType workflowType() {
        return this.workflowType;
    }

    public Instant startTimestamp() {
        return this.startTimestamp;
    }

    public Instant closeTimestamp() {
        return this.closeTimestamp;
    }

    public ExecutionStatus executionStatus() {
        return ExecutionStatus.fromValue(this.executionStatus);
    }

    public String executionStatusAsString() {
        return this.executionStatus;
    }

    public CloseStatus closeStatus() {
        return CloseStatus.fromValue(this.closeStatus);
    }

    public String closeStatusAsString() {
        return this.closeStatus;
    }

    public WorkflowExecution parent() {
        return this.parent;
    }

    public List<String> tagList() {
        return this.tagList;
    }

    public Boolean cancelRequested() {
        return this.cancelRequested;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.execution());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowType());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.closeTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.closeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parent());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagList());
        hashCode = 31 * hashCode + Objects.hashCode(this.cancelRequested());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionInfo)) {
            return false;
        }
        WorkflowExecutionInfo other = (WorkflowExecutionInfo)obj;
        return Objects.equals(this.execution(), other.execution()) && Objects.equals(this.workflowType(), other.workflowType()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.closeTimestamp(), other.closeTimestamp()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString()) && Objects.equals(this.closeStatusAsString(), other.closeStatusAsString()) && Objects.equals(this.parent(), other.parent()) && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.cancelRequested(), other.cancelRequested());
    }

    public String toString() {
        return ToString.builder((String)"WorkflowExecutionInfo").add("Execution", (Object)this.execution()).add("WorkflowType", (Object)this.workflowType()).add("StartTimestamp", (Object)this.startTimestamp()).add("CloseTimestamp", (Object)this.closeTimestamp()).add("ExecutionStatus", (Object)this.executionStatusAsString()).add("CloseStatus", (Object)this.closeStatusAsString()).add("Parent", (Object)this.parent()).add("TagList", this.tagList()).add("CancelRequested", (Object)this.cancelRequested()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "execution": {
                return Optional.ofNullable(clazz.cast(this.execution()));
            }
            case "workflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowType()));
            }
            case "startTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "closeTimestamp": {
                return Optional.ofNullable(clazz.cast(this.closeTimestamp()));
            }
            case "executionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
            case "closeStatus": {
                return Optional.ofNullable(clazz.cast(this.closeStatusAsString()));
            }
            case "parent": {
                return Optional.ofNullable(clazz.cast(this.parent()));
            }
            case "tagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "cancelRequested": {
                return Optional.ofNullable(clazz.cast(this.cancelRequested()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionInfo, T> g) {
        return obj -> g.apply((WorkflowExecutionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WorkflowExecution execution;
        private WorkflowType workflowType;
        private Instant startTimestamp;
        private Instant closeTimestamp;
        private String executionStatus;
        private String closeStatus;
        private WorkflowExecution parent;
        private List<String> tagList = DefaultSdkAutoConstructList.getInstance();
        private Boolean cancelRequested;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionInfo model) {
            this.execution(model.execution);
            this.workflowType(model.workflowType);
            this.startTimestamp(model.startTimestamp);
            this.closeTimestamp(model.closeTimestamp);
            this.executionStatus(model.executionStatus);
            this.closeStatus(model.closeStatus);
            this.parent(model.parent);
            this.tagList(model.tagList);
            this.cancelRequested(model.cancelRequested);
        }

        public final WorkflowExecution.Builder getExecution() {
            return this.execution != null ? this.execution.toBuilder() : null;
        }

        @Override
        public final Builder execution(WorkflowExecution execution) {
            this.execution = execution;
            return this;
        }

        public final void setExecution(WorkflowExecution.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        public final WorkflowType.Builder getWorkflowType() {
            return this.workflowType != null ? this.workflowType.toBuilder() : null;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType.BuilderImpl workflowType) {
            this.workflowType = workflowType != null ? workflowType.build() : null;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        public final Instant getCloseTimestamp() {
            return this.closeTimestamp;
        }

        @Override
        public final Builder closeTimestamp(Instant closeTimestamp) {
            this.closeTimestamp = closeTimestamp;
            return this;
        }

        public final void setCloseTimestamp(Instant closeTimestamp) {
            this.closeTimestamp = closeTimestamp;
        }

        public final String getExecutionStatusAsString() {
            return this.executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        public final String getCloseStatusAsString() {
            return this.closeStatus;
        }

        @Override
        public final Builder closeStatus(String closeStatus) {
            this.closeStatus = closeStatus;
            return this;
        }

        @Override
        public final Builder closeStatus(CloseStatus closeStatus) {
            this.closeStatus(closeStatus == null ? null : closeStatus.toString());
            return this;
        }

        public final void setCloseStatus(String closeStatus) {
            this.closeStatus = closeStatus;
        }

        public final WorkflowExecution.Builder getParent() {
            return this.parent != null ? this.parent.toBuilder() : null;
        }

        @Override
        public final Builder parent(WorkflowExecution parent) {
            this.parent = parent;
            return this;
        }

        public final void setParent(WorkflowExecution.BuilderImpl parent) {
            this.parent = parent != null ? parent.build() : null;
        }

        public final Collection<String> getTagList() {
            return this.tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        public final Boolean getCancelRequested() {
            return this.cancelRequested;
        }

        @Override
        public final Builder cancelRequested(Boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
            return this;
        }

        public final void setCancelRequested(Boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
        }

        public WorkflowExecutionInfo build() {
            return new WorkflowExecutionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowExecutionInfo> {
        public Builder execution(WorkflowExecution var1);

        default public Builder execution(Consumer<WorkflowExecution.Builder> execution) {
            return this.execution((WorkflowExecution)((WorkflowExecution.Builder)WorkflowExecution.builder().applyMutation(execution)).build());
        }

        public Builder workflowType(WorkflowType var1);

        default public Builder workflowType(Consumer<WorkflowType.Builder> workflowType) {
            return this.workflowType((WorkflowType)((WorkflowType.Builder)WorkflowType.builder().applyMutation(workflowType)).build());
        }

        public Builder startTimestamp(Instant var1);

        public Builder closeTimestamp(Instant var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(ExecutionStatus var1);

        public Builder closeStatus(String var1);

        public Builder closeStatus(CloseStatus var1);

        public Builder parent(WorkflowExecution var1);

        default public Builder parent(Consumer<WorkflowExecution.Builder> parent) {
            return this.parent((WorkflowExecution)((WorkflowExecution.Builder)WorkflowExecution.builder().applyMutation(parent)).build());
        }

        public Builder tagList(Collection<String> var1);

        public Builder tagList(String ... var1);

        public Builder cancelRequested(Boolean var1);
    }
}

