/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ActivityType;
import software.amazon.awssdk.services.swf.model.ScheduleActivityTaskFailedCause;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleActivityTaskFailedEventAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduleActivityTaskFailedEventAttributes> {
    private static final SdkField<ActivityType> ACTIVITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ScheduleActivityTaskFailedEventAttributes.getter(ScheduleActivityTaskFailedEventAttributes::activityType)).setter(ScheduleActivityTaskFailedEventAttributes.setter(Builder::activityType)).constructor(ActivityType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityType").build()}).build();
    private static final SdkField<String> ACTIVITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduleActivityTaskFailedEventAttributes.getter(ScheduleActivityTaskFailedEventAttributes::activityId)).setter(ScheduleActivityTaskFailedEventAttributes.setter(Builder::activityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityId").build()}).build();
    private static final SdkField<String> CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduleActivityTaskFailedEventAttributes.getter(ScheduleActivityTaskFailedEventAttributes::causeAsString)).setter(ScheduleActivityTaskFailedEventAttributes.setter(Builder::cause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()}).build();
    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ScheduleActivityTaskFailedEventAttributes.getter(ScheduleActivityTaskFailedEventAttributes::decisionTaskCompletedEventId)).setter(ScheduleActivityTaskFailedEventAttributes.setter(Builder::decisionTaskCompletedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_TYPE_FIELD, ACTIVITY_ID_FIELD, CAUSE_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final ActivityType activityType;
    private final String activityId;
    private final String causeValue;
    private final Long decisionTaskCompletedEventId;

    private ScheduleActivityTaskFailedEventAttributes(BuilderImpl builder) {
        this.activityType = builder.activityType;
        this.activityId = builder.activityId;
        this.causeValue = builder.causeValue;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    public ActivityType activityType() {
        return this.activityType;
    }

    public String activityId() {
        return this.activityId;
    }

    public ScheduleActivityTaskFailedCause cause() {
        return ScheduleActivityTaskFailedCause.fromValue(this.causeValue);
    }

    public String causeAsString() {
        return this.causeValue;
    }

    public Long decisionTaskCompletedEventId() {
        return this.decisionTaskCompletedEventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.causeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.decisionTaskCompletedEventId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleActivityTaskFailedEventAttributes)) {
            return false;
        }
        ScheduleActivityTaskFailedEventAttributes other = (ScheduleActivityTaskFailedEventAttributes)obj;
        return Objects.equals(this.activityType(), other.activityType()) && Objects.equals(this.activityId(), other.activityId()) && Objects.equals(this.causeAsString(), other.causeAsString()) && Objects.equals(this.decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId());
    }

    public String toString() {
        return ToString.builder((String)"ScheduleActivityTaskFailedEventAttributes").add("ActivityType", (Object)this.activityType()).add("ActivityId", (Object)this.activityId()).add("Cause", (Object)this.causeAsString()).add("DecisionTaskCompletedEventId", (Object)this.decisionTaskCompletedEventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activityType": {
                return Optional.ofNullable(clazz.cast(this.activityType()));
            }
            case "activityId": {
                return Optional.ofNullable(clazz.cast(this.activityId()));
            }
            case "cause": {
                return Optional.ofNullable(clazz.cast(this.causeAsString()));
            }
            case "decisionTaskCompletedEventId": {
                return Optional.ofNullable(clazz.cast(this.decisionTaskCompletedEventId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleActivityTaskFailedEventAttributes, T> g) {
        return obj -> g.apply((ScheduleActivityTaskFailedEventAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActivityType activityType;
        private String activityId;
        private String causeValue;
        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleActivityTaskFailedEventAttributes model) {
            this.activityType(model.activityType);
            this.activityId(model.activityId);
            this.cause(model.causeValue);
            this.decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final ActivityType.Builder getActivityType() {
            return this.activityType != null ? this.activityType.toBuilder() : null;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType.BuilderImpl activityType) {
            this.activityType = activityType != null ? activityType.build() : null;
        }

        public final String getActivityId() {
            return this.activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public final String getCauseAsString() {
            return this.causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public final Builder cause(ScheduleActivityTaskFailedCause causeValue) {
            this.cause(causeValue == null ? null : causeValue.toString());
            return this;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return this.decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        public ScheduleActivityTaskFailedEventAttributes build() {
            return new ScheduleActivityTaskFailedEventAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduleActivityTaskFailedEventAttributes> {
        public Builder activityType(ActivityType var1);

        default public Builder activityType(Consumer<ActivityType.Builder> activityType) {
            return this.activityType((ActivityType)((ActivityType.Builder)ActivityType.builder().applyMutation(activityType)).build());
        }

        public Builder activityId(String var1);

        public Builder cause(String var1);

        public Builder cause(ScheduleActivityTaskFailedCause var1);

        public Builder decisionTaskCompletedEventId(Long var1);
    }
}

