/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionTimeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionTimeFilter> {
    private static final SdkField<Instant> OLDEST_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ExecutionTimeFilter.getter(ExecutionTimeFilter::oldestDate)).setter(ExecutionTimeFilter.setter(Builder::oldestDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oldestDate").build()}).build();
    private static final SdkField<Instant> LATEST_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ExecutionTimeFilter.getter(ExecutionTimeFilter::latestDate)).setter(ExecutionTimeFilter.setter(Builder::latestDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OLDEST_DATE_FIELD, LATEST_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant oldestDate;
    private final Instant latestDate;

    private ExecutionTimeFilter(BuilderImpl builder) {
        this.oldestDate = builder.oldestDate;
        this.latestDate = builder.latestDate;
    }

    public Instant oldestDate() {
        return this.oldestDate;
    }

    public Instant latestDate() {
        return this.latestDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.oldestDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionTimeFilter)) {
            return false;
        }
        ExecutionTimeFilter other = (ExecutionTimeFilter)obj;
        return Objects.equals(this.oldestDate(), other.oldestDate()) && Objects.equals(this.latestDate(), other.latestDate());
    }

    public String toString() {
        return ToString.builder((String)"ExecutionTimeFilter").add("OldestDate", (Object)this.oldestDate()).add("LatestDate", (Object)this.latestDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "oldestDate": {
                return Optional.ofNullable(clazz.cast(this.oldestDate()));
            }
            case "latestDate": {
                return Optional.ofNullable(clazz.cast(this.latestDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionTimeFilter, T> g) {
        return obj -> g.apply((ExecutionTimeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant oldestDate;
        private Instant latestDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionTimeFilter model) {
            this.oldestDate(model.oldestDate);
            this.latestDate(model.latestDate);
        }

        public final Instant getOldestDate() {
            return this.oldestDate;
        }

        @Override
        public final Builder oldestDate(Instant oldestDate) {
            this.oldestDate = oldestDate;
            return this;
        }

        public final void setOldestDate(Instant oldestDate) {
            this.oldestDate = oldestDate;
        }

        public final Instant getLatestDate() {
            return this.latestDate;
        }

        @Override
        public final Builder latestDate(Instant latestDate) {
            this.latestDate = latestDate;
            return this;
        }

        public final void setLatestDate(Instant latestDate) {
            this.latestDate = latestDate;
        }

        public ExecutionTimeFilter build() {
            return new ExecutionTimeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionTimeFilter> {
        public Builder oldestDate(Instant var1);

        public Builder latestDate(Instant var1);
    }
}

