/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCategorySpecificSummary;
import software.amazon.awssdk.services.support.model.TrustedAdvisorResourceDetail;
import software.amazon.awssdk.services.support.model.TrustedAdvisorResourceDetailListCopier;
import software.amazon.awssdk.services.support.model.TrustedAdvisorResourcesSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrustedAdvisorCheckResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrustedAdvisorCheckResult> {
    private static final SdkField<String> CHECK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkId").getter(TrustedAdvisorCheckResult.getter(TrustedAdvisorCheckResult::checkId)).setter(TrustedAdvisorCheckResult.setter(Builder::checkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkId").build()}).build();
    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timestamp").getter(TrustedAdvisorCheckResult.getter(TrustedAdvisorCheckResult::timestamp)).setter(TrustedAdvisorCheckResult.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TrustedAdvisorCheckResult.getter(TrustedAdvisorCheckResult::status)).setter(TrustedAdvisorCheckResult.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<TrustedAdvisorResourcesSummary> RESOURCES_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourcesSummary").getter(TrustedAdvisorCheckResult.getter(TrustedAdvisorCheckResult::resourcesSummary)).setter(TrustedAdvisorCheckResult.setter(Builder::resourcesSummary)).constructor(TrustedAdvisorResourcesSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesSummary").build()}).build();
    private static final SdkField<TrustedAdvisorCategorySpecificSummary> CATEGORY_SPECIFIC_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("categorySpecificSummary").getter(TrustedAdvisorCheckResult.getter(TrustedAdvisorCheckResult::categorySpecificSummary)).setter(TrustedAdvisorCheckResult.setter(Builder::categorySpecificSummary)).constructor(TrustedAdvisorCategorySpecificSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categorySpecificSummary").build()}).build();
    private static final SdkField<List<TrustedAdvisorResourceDetail>> FLAGGED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("flaggedResources").getter(TrustedAdvisorCheckResult.getter(TrustedAdvisorCheckResult::flaggedResources)).setter(TrustedAdvisorCheckResult.setter(Builder::flaggedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flaggedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustedAdvisorResourceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_ID_FIELD, TIMESTAMP_FIELD, STATUS_FIELD, RESOURCES_SUMMARY_FIELD, CATEGORY_SPECIFIC_SUMMARY_FIELD, FLAGGED_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrustedAdvisorCheckResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String checkId;
    private final String timestamp;
    private final String status;
    private final TrustedAdvisorResourcesSummary resourcesSummary;
    private final TrustedAdvisorCategorySpecificSummary categorySpecificSummary;
    private final List<TrustedAdvisorResourceDetail> flaggedResources;

    private TrustedAdvisorCheckResult(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
        this.resourcesSummary = builder.resourcesSummary;
        this.categorySpecificSummary = builder.categorySpecificSummary;
        this.flaggedResources = builder.flaggedResources;
    }

    public final String checkId() {
        return this.checkId;
    }

    public final String timestamp() {
        return this.timestamp;
    }

    public final String status() {
        return this.status;
    }

    public final TrustedAdvisorResourcesSummary resourcesSummary() {
        return this.resourcesSummary;
    }

    public final TrustedAdvisorCategorySpecificSummary categorySpecificSummary() {
        return this.categorySpecificSummary;
    }

    public final boolean hasFlaggedResources() {
        return this.flaggedResources != null && !(this.flaggedResources instanceof SdkAutoConstructList);
    }

    public final List<TrustedAdvisorResourceDetail> flaggedResources() {
        return this.flaggedResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.categorySpecificSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlaggedResources() ? this.flaggedResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckResult)) {
            return false;
        }
        TrustedAdvisorCheckResult other = (TrustedAdvisorCheckResult)obj;
        return Objects.equals(this.checkId(), other.checkId()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.resourcesSummary(), other.resourcesSummary()) && Objects.equals(this.categorySpecificSummary(), other.categorySpecificSummary()) && this.hasFlaggedResources() == other.hasFlaggedResources() && Objects.equals(this.flaggedResources(), other.flaggedResources());
    }

    public final String toString() {
        return ToString.builder((String)"TrustedAdvisorCheckResult").add("CheckId", (Object)this.checkId()).add("Timestamp", (Object)this.timestamp()).add("Status", (Object)this.status()).add("ResourcesSummary", (Object)this.resourcesSummary()).add("CategorySpecificSummary", (Object)this.categorySpecificSummary()).add("FlaggedResources", this.hasFlaggedResources() ? this.flaggedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checkId": {
                return Optional.ofNullable(clazz.cast(this.checkId()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "resourcesSummary": {
                return Optional.ofNullable(clazz.cast(this.resourcesSummary()));
            }
            case "categorySpecificSummary": {
                return Optional.ofNullable(clazz.cast(this.categorySpecificSummary()));
            }
            case "flaggedResources": {
                return Optional.ofNullable(clazz.cast(this.flaggedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("checkId", CHECK_ID_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("resourcesSummary", RESOURCES_SUMMARY_FIELD);
        map.put("categorySpecificSummary", CATEGORY_SPECIFIC_SUMMARY_FIELD);
        map.put("flaggedResources", FLAGGED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustedAdvisorCheckResult, T> g) {
        return obj -> g.apply((TrustedAdvisorCheckResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String checkId;
        private String timestamp;
        private String status;
        private TrustedAdvisorResourcesSummary resourcesSummary;
        private TrustedAdvisorCategorySpecificSummary categorySpecificSummary;
        private List<TrustedAdvisorResourceDetail> flaggedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckResult model) {
            this.checkId(model.checkId);
            this.timestamp(model.timestamp);
            this.status(model.status);
            this.resourcesSummary(model.resourcesSummary);
            this.categorySpecificSummary(model.categorySpecificSummary);
            this.flaggedResources(model.flaggedResources);
        }

        public final String getCheckId() {
            return this.checkId;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final String getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final TrustedAdvisorResourcesSummary.Builder getResourcesSummary() {
            return this.resourcesSummary != null ? this.resourcesSummary.toBuilder() : null;
        }

        public final void setResourcesSummary(TrustedAdvisorResourcesSummary.BuilderImpl resourcesSummary) {
            this.resourcesSummary = resourcesSummary != null ? resourcesSummary.build() : null;
        }

        @Override
        public final Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary) {
            this.resourcesSummary = resourcesSummary;
            return this;
        }

        public final TrustedAdvisorCategorySpecificSummary.Builder getCategorySpecificSummary() {
            return this.categorySpecificSummary != null ? this.categorySpecificSummary.toBuilder() : null;
        }

        public final void setCategorySpecificSummary(TrustedAdvisorCategorySpecificSummary.BuilderImpl categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary != null ? categorySpecificSummary.build() : null;
        }

        @Override
        public final Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary;
            return this;
        }

        public final List<TrustedAdvisorResourceDetail.Builder> getFlaggedResources() {
            List<TrustedAdvisorResourceDetail.Builder> result = TrustedAdvisorResourceDetailListCopier.copyToBuilder(this.flaggedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlaggedResources(Collection<TrustedAdvisorResourceDetail.BuilderImpl> flaggedResources) {
            this.flaggedResources = TrustedAdvisorResourceDetailListCopier.copyFromBuilder(flaggedResources);
        }

        @Override
        public final Builder flaggedResources(Collection<TrustedAdvisorResourceDetail> flaggedResources) {
            this.flaggedResources = TrustedAdvisorResourceDetailListCopier.copy(flaggedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flaggedResources(TrustedAdvisorResourceDetail ... flaggedResources) {
            this.flaggedResources(Arrays.asList(flaggedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flaggedResources(Consumer<TrustedAdvisorResourceDetail.Builder> ... flaggedResources) {
            this.flaggedResources(Stream.of(flaggedResources).map(c -> (TrustedAdvisorResourceDetail)((TrustedAdvisorResourceDetail.Builder)TrustedAdvisorResourceDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TrustedAdvisorCheckResult build() {
            return new TrustedAdvisorCheckResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrustedAdvisorCheckResult> {
        public Builder checkId(String var1);

        public Builder timestamp(String var1);

        public Builder status(String var1);

        public Builder resourcesSummary(TrustedAdvisorResourcesSummary var1);

        default public Builder resourcesSummary(Consumer<TrustedAdvisorResourcesSummary.Builder> resourcesSummary) {
            return this.resourcesSummary((TrustedAdvisorResourcesSummary)((TrustedAdvisorResourcesSummary.Builder)TrustedAdvisorResourcesSummary.builder().applyMutation(resourcesSummary)).build());
        }

        public Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary var1);

        default public Builder categorySpecificSummary(Consumer<TrustedAdvisorCategorySpecificSummary.Builder> categorySpecificSummary) {
            return this.categorySpecificSummary((TrustedAdvisorCategorySpecificSummary)((TrustedAdvisorCategorySpecificSummary.Builder)TrustedAdvisorCategorySpecificSummary.builder().applyMutation(categorySpecificSummary)).build());
        }

        public Builder flaggedResources(Collection<TrustedAdvisorResourceDetail> var1);

        public Builder flaggedResources(TrustedAdvisorResourceDetail ... var1);

        public Builder flaggedResources(Consumer<TrustedAdvisorResourceDetail.Builder> ... var1);
    }
}

