/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.support.model.StringListCopier;
import software.amazon.awssdk.services.support.model.SupportRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTrustedAdvisorCheckSummariesRequest
extends SupportRequest
implements ToCopyableBuilder<Builder, DescribeTrustedAdvisorCheckSummariesRequest> {
    private final List<String> checkIds;

    private DescribeTrustedAdvisorCheckSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.checkIds = builder.checkIds;
    }

    public List<String> checkIds() {
        return this.checkIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checkIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckSummariesRequest)) {
            return false;
        }
        DescribeTrustedAdvisorCheckSummariesRequest other = (DescribeTrustedAdvisorCheckSummariesRequest)((Object)obj);
        return Objects.equals(this.checkIds(), other.checkIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTrustedAdvisorCheckSummariesRequest").add("CheckIds", this.checkIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checkIds": {
                return Optional.of(clazz.cast(this.checkIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SupportRequest.BuilderImpl
    implements Builder {
        private List<String> checkIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckSummariesRequest model) {
            this.checkIds(model.checkIds);
        }

        public final Collection<String> getCheckIds() {
            return this.checkIds;
        }

        @Override
        public final Builder checkIds(Collection<String> checkIds) {
            this.checkIds = StringListCopier.copy(checkIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIds(String ... checkIds) {
            this.checkIds(Arrays.asList(checkIds));
            return this;
        }

        public final void setCheckIds(Collection<String> checkIds) {
            this.checkIds = StringListCopier.copy(checkIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeTrustedAdvisorCheckSummariesRequest build() {
            return new DescribeTrustedAdvisorCheckSummariesRequest(this);
        }
    }

    public static interface Builder
    extends SupportRequest.Builder,
    CopyableBuilder<Builder, DescribeTrustedAdvisorCheckSummariesRequest> {
        public Builder checkIds(Collection<String> var1);

        public Builder checkIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

