/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.support.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * TrustedAdvisorResourcesSummaryMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class TrustedAdvisorResourcesSummaryMarshaller {

    private static final MarshallingInfo<Long> RESOURCESPROCESSED_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourcesProcessed").build();
    private static final MarshallingInfo<Long> RESOURCESFLAGGED_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourcesFlagged").build();
    private static final MarshallingInfo<Long> RESOURCESIGNORED_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourcesIgnored").build();
    private static final MarshallingInfo<Long> RESOURCESSUPPRESSED_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourcesSuppressed").build();

    private static final TrustedAdvisorResourcesSummaryMarshaller INSTANCE = new TrustedAdvisorResourcesSummaryMarshaller();

    public static TrustedAdvisorResourcesSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(TrustedAdvisorResourcesSummary trustedAdvisorResourcesSummary, ProtocolMarshaller protocolMarshaller) {

        if (trustedAdvisorResourcesSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(trustedAdvisorResourcesSummary.resourcesProcessed(), RESOURCESPROCESSED_BINDING);

            protocolMarshaller.marshall(trustedAdvisorResourcesSummary.resourcesFlagged(), RESOURCESFLAGGED_BINDING);

            protocolMarshaller.marshall(trustedAdvisorResourcesSummary.resourcesIgnored(), RESOURCESIGNORED_BINDING);

            protocolMarshaller.marshall(trustedAdvisorResourcesSummary.resourcesSuppressed(), RESOURCESSUPPRESSED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
