/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCheckSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a Trusted Advisor check result, including the alert status, last refresh, and number of resources
 * examined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrustedAdvisorCheckSummary implements StructuredPojo,
        ToCopyableBuilder<TrustedAdvisorCheckSummary.Builder, TrustedAdvisorCheckSummary> {
    private final String checkId;

    private final String timestamp;

    private final String status;

    private final Boolean hasFlaggedResources;

    private final TrustedAdvisorResourcesSummary resourcesSummary;

    private final TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

    private TrustedAdvisorCheckSummary(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
        this.hasFlaggedResources = builder.hasFlaggedResources;
        this.resourcesSummary = builder.resourcesSummary;
        this.categorySpecificSummary = builder.categorySpecificSummary;
    }

    /**
     * <p>
     * The unique identifier for the Trusted Advisor check.
     * </p>
     * 
     * @return The unique identifier for the Trusted Advisor check.
     */
    public String checkId() {
        return checkId;
    }

    /**
     * <p>
     * The time of the last refresh of the check.
     * </p>
     * 
     * @return The time of the last refresh of the check.
     */
    public String timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     * </p>
     * 
     * @return The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * Specifies whether the Trusted Advisor check has flagged resources.
     * </p>
     * 
     * @return Specifies whether the Trusted Advisor check has flagged resources.
     */
    public Boolean hasFlaggedResources() {
        return hasFlaggedResources;
    }

    /**
     * Returns the value of the ResourcesSummary property for this object.
     * 
     * @return The value of the ResourcesSummary property for this object.
     */
    public TrustedAdvisorResourcesSummary resourcesSummary() {
        return resourcesSummary;
    }

    /**
     * <p>
     * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
     * currently supported.
     * </p>
     * 
     * @return Summary information that relates to the category of the check. Cost Optimizing is the only category that
     *         is currently supported.
     */
    public TrustedAdvisorCategorySpecificSummary categorySpecificSummary() {
        return categorySpecificSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkId());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasFlaggedResources());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesSummary());
        hashCode = 31 * hashCode + Objects.hashCode(categorySpecificSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckSummary)) {
            return false;
        }
        TrustedAdvisorCheckSummary other = (TrustedAdvisorCheckSummary) obj;
        return Objects.equals(checkId(), other.checkId()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(status(), other.status()) && Objects.equals(hasFlaggedResources(), other.hasFlaggedResources())
                && Objects.equals(resourcesSummary(), other.resourcesSummary())
                && Objects.equals(categorySpecificSummary(), other.categorySpecificSummary());
    }

    @Override
    public String toString() {
        return ToString.builder("TrustedAdvisorCheckSummary").add("CheckId", checkId()).add("Timestamp", timestamp())
                .add("Status", status()).add("HasFlaggedResources", hasFlaggedResources())
                .add("ResourcesSummary", resourcesSummary()).add("CategorySpecificSummary", categorySpecificSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkId":
            return Optional.of(clazz.cast(checkId()));
        case "timestamp":
            return Optional.of(clazz.cast(timestamp()));
        case "status":
            return Optional.of(clazz.cast(status()));
        case "hasFlaggedResources":
            return Optional.of(clazz.cast(hasFlaggedResources()));
        case "resourcesSummary":
            return Optional.of(clazz.cast(resourcesSummary()));
        case "categorySpecificSummary":
            return Optional.of(clazz.cast(categorySpecificSummary()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCheckSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TrustedAdvisorCheckSummary> {
        /**
         * <p>
         * The unique identifier for the Trusted Advisor check.
         * </p>
         * 
         * @param checkId
         *        The unique identifier for the Trusted Advisor check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        /**
         * <p>
         * The time of the last refresh of the check.
         * </p>
         * 
         * @param timestamp
         *        The time of the last refresh of the check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);

        /**
         * <p>
         * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         * </p>
         * 
         * @param status
         *        The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies whether the Trusted Advisor check has flagged resources.
         * </p>
         * 
         * @param hasFlaggedResources
         *        Specifies whether the Trusted Advisor check has flagged resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasFlaggedResources(Boolean hasFlaggedResources);

        /**
         * Sets the value of the ResourcesSummary property for this object.
         *
         * @param resourcesSummary
         *        The new value for the ResourcesSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary);

        /**
         * Sets the value of the ResourcesSummary property for this object.
         *
         * This is a convenience that creates an instance of the {@link TrustedAdvisorResourcesSummary.Builder} avoiding
         * the need to create one manually via {@link TrustedAdvisorResourcesSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedAdvisorResourcesSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #resourcesSummary(TrustedAdvisorResourcesSummary)}.
         * 
         * @param resourcesSummary
         *        a consumer that will call methods on {@link TrustedAdvisorResourcesSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesSummary(TrustedAdvisorResourcesSummary)
         */
        default Builder resourcesSummary(Consumer<TrustedAdvisorResourcesSummary.Builder> resourcesSummary) {
            return resourcesSummary(TrustedAdvisorResourcesSummary.builder().apply(resourcesSummary).build());
        }

        /**
         * <p>
         * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
         * currently supported.
         * </p>
         * 
         * @param categorySpecificSummary
         *        Summary information that relates to the category of the check. Cost Optimizing is the only category
         *        that is currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary);

        /**
         * <p>
         * Summary information that relates to the category of the check. Cost Optimizing is the only category that is
         * currently supported.
         * </p>
         * This is a convenience that creates an instance of the {@link TrustedAdvisorCategorySpecificSummary.Builder}
         * avoiding the need to create one manually via {@link TrustedAdvisorCategorySpecificSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedAdvisorCategorySpecificSummary.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #categorySpecificSummary(TrustedAdvisorCategorySpecificSummary)}.
         * 
         * @param categorySpecificSummary
         *        a consumer that will call methods on {@link TrustedAdvisorCategorySpecificSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categorySpecificSummary(TrustedAdvisorCategorySpecificSummary)
         */
        default Builder categorySpecificSummary(Consumer<TrustedAdvisorCategorySpecificSummary.Builder> categorySpecificSummary) {
            return categorySpecificSummary(TrustedAdvisorCategorySpecificSummary.builder().apply(categorySpecificSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String checkId;

        private String timestamp;

        private String status;

        private Boolean hasFlaggedResources;

        private TrustedAdvisorResourcesSummary resourcesSummary;

        private TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckSummary model) {
            checkId(model.checkId);
            timestamp(model.timestamp);
            status(model.status);
            hasFlaggedResources(model.hasFlaggedResources);
            resourcesSummary(model.resourcesSummary);
            categorySpecificSummary(model.categorySpecificSummary);
        }

        public final String getCheckId() {
            return checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getHasFlaggedResources() {
            return hasFlaggedResources;
        }

        @Override
        public final Builder hasFlaggedResources(Boolean hasFlaggedResources) {
            this.hasFlaggedResources = hasFlaggedResources;
            return this;
        }

        public final void setHasFlaggedResources(Boolean hasFlaggedResources) {
            this.hasFlaggedResources = hasFlaggedResources;
        }

        public final TrustedAdvisorResourcesSummary.Builder getResourcesSummary() {
            return resourcesSummary != null ? resourcesSummary.toBuilder() : null;
        }

        @Override
        public final Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary) {
            this.resourcesSummary = resourcesSummary;
            return this;
        }

        public final void setResourcesSummary(TrustedAdvisorResourcesSummary.BuilderImpl resourcesSummary) {
            this.resourcesSummary = resourcesSummary != null ? resourcesSummary.build() : null;
        }

        public final TrustedAdvisorCategorySpecificSummary.Builder getCategorySpecificSummary() {
            return categorySpecificSummary != null ? categorySpecificSummary.toBuilder() : null;
        }

        @Override
        public final Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary;
            return this;
        }

        public final void setCategorySpecificSummary(TrustedAdvisorCategorySpecificSummary.BuilderImpl categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary != null ? categorySpecificSummary.build() : null;
        }

        @Override
        public TrustedAdvisorCheckSummary build() {
            return new TrustedAdvisorCheckSummary(this);
        }
    }
}
