/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCategorySpecificSummary;
import software.amazon.awssdk.services.support.model.TrustedAdvisorResourcesSummary;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCheckSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TrustedAdvisorCheckSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, TrustedAdvisorCheckSummary> {
    private final String checkId;
    private final String timestamp;
    private final String status;
    private final Boolean hasFlaggedResources;
    private final TrustedAdvisorResourcesSummary resourcesSummary;
    private final TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

    private TrustedAdvisorCheckSummary(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
        this.hasFlaggedResources = builder.hasFlaggedResources;
        this.resourcesSummary = builder.resourcesSummary;
        this.categorySpecificSummary = builder.categorySpecificSummary;
    }

    public String checkId() {
        return this.checkId;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public String status() {
        return this.status;
    }

    public Boolean hasFlaggedResources() {
        return this.hasFlaggedResources;
    }

    public TrustedAdvisorResourcesSummary resourcesSummary() {
        return this.resourcesSummary;
    }

    public TrustedAdvisorCategorySpecificSummary categorySpecificSummary() {
        return this.categorySpecificSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlaggedResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.categorySpecificSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckSummary)) {
            return false;
        }
        TrustedAdvisorCheckSummary other = (TrustedAdvisorCheckSummary)obj;
        return Objects.equals(this.checkId(), other.checkId()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.hasFlaggedResources(), other.hasFlaggedResources()) && Objects.equals(this.resourcesSummary(), other.resourcesSummary()) && Objects.equals(this.categorySpecificSummary(), other.categorySpecificSummary());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.checkId() != null) {
            sb.append("CheckId: ").append(this.checkId()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.hasFlaggedResources() != null) {
            sb.append("HasFlaggedResources: ").append(this.hasFlaggedResources()).append(",");
        }
        if (this.resourcesSummary() != null) {
            sb.append("ResourcesSummary: ").append(this.resourcesSummary()).append(",");
        }
        if (this.categorySpecificSummary() != null) {
            sb.append("CategorySpecificSummary: ").append(this.categorySpecificSummary()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checkId": {
                return Optional.of(clazz.cast(this.checkId()));
            }
            case "timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "hasFlaggedResources": {
                return Optional.of(clazz.cast(this.hasFlaggedResources()));
            }
            case "resourcesSummary": {
                return Optional.of(clazz.cast(this.resourcesSummary()));
            }
            case "categorySpecificSummary": {
                return Optional.of(clazz.cast(this.categorySpecificSummary()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCheckSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String checkId;
        private String timestamp;
        private String status;
        private Boolean hasFlaggedResources;
        private TrustedAdvisorResourcesSummary resourcesSummary;
        private TrustedAdvisorCategorySpecificSummary categorySpecificSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckSummary model) {
            this.checkId(model.checkId);
            this.timestamp(model.timestamp);
            this.status(model.status);
            this.hasFlaggedResources(model.hasFlaggedResources);
            this.resourcesSummary(model.resourcesSummary);
            this.categorySpecificSummary(model.categorySpecificSummary);
        }

        public final String getCheckId() {
            return this.checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public final String getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getHasFlaggedResources() {
            return this.hasFlaggedResources;
        }

        @Override
        public final Builder hasFlaggedResources(Boolean hasFlaggedResources) {
            this.hasFlaggedResources = hasFlaggedResources;
            return this;
        }

        public final void setHasFlaggedResources(Boolean hasFlaggedResources) {
            this.hasFlaggedResources = hasFlaggedResources;
        }

        public final TrustedAdvisorResourcesSummary.Builder getResourcesSummary() {
            return this.resourcesSummary != null ? this.resourcesSummary.toBuilder() : null;
        }

        @Override
        public final Builder resourcesSummary(TrustedAdvisorResourcesSummary resourcesSummary) {
            this.resourcesSummary = resourcesSummary;
            return this;
        }

        public final void setResourcesSummary(TrustedAdvisorResourcesSummary.BuilderImpl resourcesSummary) {
            this.resourcesSummary = resourcesSummary != null ? resourcesSummary.build() : null;
        }

        public final TrustedAdvisorCategorySpecificSummary.Builder getCategorySpecificSummary() {
            return this.categorySpecificSummary != null ? this.categorySpecificSummary.toBuilder() : null;
        }

        @Override
        public final Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary;
            return this;
        }

        public final void setCategorySpecificSummary(TrustedAdvisorCategorySpecificSummary.BuilderImpl categorySpecificSummary) {
            this.categorySpecificSummary = categorySpecificSummary != null ? categorySpecificSummary.build() : null;
        }

        public TrustedAdvisorCheckSummary build() {
            return new TrustedAdvisorCheckSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrustedAdvisorCheckSummary> {
        public Builder checkId(String var1);

        public Builder timestamp(String var1);

        public Builder status(String var1);

        public Builder hasFlaggedResources(Boolean var1);

        public Builder resourcesSummary(TrustedAdvisorResourcesSummary var1);

        default public Builder resourcesSummary(Consumer<TrustedAdvisorResourcesSummary.Builder> resourcesSummary) {
            return this.resourcesSummary((TrustedAdvisorResourcesSummary)((TrustedAdvisorResourcesSummary.Builder)TrustedAdvisorResourcesSummary.builder().apply(resourcesSummary)).build());
        }

        public Builder categorySpecificSummary(TrustedAdvisorCategorySpecificSummary var1);

        default public Builder categorySpecificSummary(Consumer<TrustedAdvisorCategorySpecificSummary.Builder> categorySpecificSummary) {
            return this.categorySpecificSummary((TrustedAdvisorCategorySpecificSummary)((TrustedAdvisorCategorySpecificSummary.Builder)TrustedAdvisorCategorySpecificSummary.builder().apply(categorySpecificSummary)).build());
        }
    }
}

