/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.StringListCopier;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCheckDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TrustedAdvisorCheckDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, TrustedAdvisorCheckDescription> {
    private final String id;
    private final String name;
    private final String description;
    private final String category;
    private final List<String> metadata;

    private TrustedAdvisorCheckDescription(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.category = builder.category;
        this.metadata = builder.metadata;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String category() {
        return this.category;
    }

    public List<String> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckDescription)) {
            return false;
        }
        TrustedAdvisorCheckDescription other = (TrustedAdvisorCheckDescription)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.metadata(), other.metadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.category() != null) {
            sb.append("Category: ").append(this.category()).append(",");
        }
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "category": {
                return Optional.of(clazz.cast(this.category()));
            }
            case "metadata": {
                return Optional.of(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCheckDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String category;
        private List<String> metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckDescription model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.category(model.category);
            this.metadata(model.metadata);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final Collection<String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(String ... metadata) {
            this.metadata(Arrays.asList(metadata));
            return this;
        }

        public final void setMetadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
        }

        public TrustedAdvisorCheckDescription build() {
            return new TrustedAdvisorCheckDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrustedAdvisorCheckDescription> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder category(String var1);

        public Builder metadata(Collection<String> var1);

        public Builder metadata(String ... var1);
    }
}

