/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.CcEmailAddressListCopier;
import software.amazon.awssdk.services.support.model.RecentCaseCommunications;
import software.amazon.awssdk.services.support.transform.CaseDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CaseDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, CaseDetails> {
    private final String caseId;
    private final String displayId;
    private final String subject;
    private final String status;
    private final String serviceCode;
    private final String categoryCode;
    private final String severityCode;
    private final String submittedBy;
    private final String timeCreated;
    private final RecentCaseCommunications recentCommunications;
    private final List<String> ccEmailAddresses;
    private final String language;

    private CaseDetails(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.displayId = builder.displayId;
        this.subject = builder.subject;
        this.status = builder.status;
        this.serviceCode = builder.serviceCode;
        this.categoryCode = builder.categoryCode;
        this.severityCode = builder.severityCode;
        this.submittedBy = builder.submittedBy;
        this.timeCreated = builder.timeCreated;
        this.recentCommunications = builder.recentCommunications;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.language = builder.language;
    }

    public String caseId() {
        return this.caseId;
    }

    public String displayId() {
        return this.displayId;
    }

    public String subject() {
        return this.subject;
    }

    public String status() {
        return this.status;
    }

    public String serviceCode() {
        return this.serviceCode;
    }

    public String categoryCode() {
        return this.categoryCode;
    }

    public String severityCode() {
        return this.severityCode;
    }

    public String submittedBy() {
        return this.submittedBy;
    }

    public String timeCreated() {
        return this.timeCreated;
    }

    public RecentCaseCommunications recentCommunications() {
        return this.recentCommunications;
    }

    public List<String> ccEmailAddresses() {
        return this.ccEmailAddresses;
    }

    public String language() {
        return this.language;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.recentCommunications());
        hashCode = 31 * hashCode + Objects.hashCode(this.ccEmailAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseDetails)) {
            return false;
        }
        CaseDetails other = (CaseDetails)obj;
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.displayId(), other.displayId()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.categoryCode(), other.categoryCode()) && Objects.equals(this.severityCode(), other.severityCode()) && Objects.equals(this.submittedBy(), other.submittedBy()) && Objects.equals(this.timeCreated(), other.timeCreated()) && Objects.equals(this.recentCommunications(), other.recentCommunications()) && Objects.equals(this.ccEmailAddresses(), other.ccEmailAddresses()) && Objects.equals(this.language(), other.language());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.caseId() != null) {
            sb.append("CaseId: ").append(this.caseId()).append(",");
        }
        if (this.displayId() != null) {
            sb.append("DisplayId: ").append(this.displayId()).append(",");
        }
        if (this.subject() != null) {
            sb.append("Subject: ").append(this.subject()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.serviceCode() != null) {
            sb.append("ServiceCode: ").append(this.serviceCode()).append(",");
        }
        if (this.categoryCode() != null) {
            sb.append("CategoryCode: ").append(this.categoryCode()).append(",");
        }
        if (this.severityCode() != null) {
            sb.append("SeverityCode: ").append(this.severityCode()).append(",");
        }
        if (this.submittedBy() != null) {
            sb.append("SubmittedBy: ").append(this.submittedBy()).append(",");
        }
        if (this.timeCreated() != null) {
            sb.append("TimeCreated: ").append(this.timeCreated()).append(",");
        }
        if (this.recentCommunications() != null) {
            sb.append("RecentCommunications: ").append(this.recentCommunications()).append(",");
        }
        if (this.ccEmailAddresses() != null) {
            sb.append("CcEmailAddresses: ").append(this.ccEmailAddresses()).append(",");
        }
        if (this.language() != null) {
            sb.append("Language: ").append(this.language()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.of(clazz.cast(this.caseId()));
            }
            case "displayId": {
                return Optional.of(clazz.cast(this.displayId()));
            }
            case "subject": {
                return Optional.of(clazz.cast(this.subject()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "serviceCode": {
                return Optional.of(clazz.cast(this.serviceCode()));
            }
            case "categoryCode": {
                return Optional.of(clazz.cast(this.categoryCode()));
            }
            case "severityCode": {
                return Optional.of(clazz.cast(this.severityCode()));
            }
            case "submittedBy": {
                return Optional.of(clazz.cast(this.submittedBy()));
            }
            case "timeCreated": {
                return Optional.of(clazz.cast(this.timeCreated()));
            }
            case "recentCommunications": {
                return Optional.of(clazz.cast(this.recentCommunications()));
            }
            case "ccEmailAddresses": {
                return Optional.of(clazz.cast(this.ccEmailAddresses()));
            }
            case "language": {
                return Optional.of(clazz.cast(this.language()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CaseDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String caseId;
        private String displayId;
        private String subject;
        private String status;
        private String serviceCode;
        private String categoryCode;
        private String severityCode;
        private String submittedBy;
        private String timeCreated;
        private RecentCaseCommunications recentCommunications;
        private List<String> ccEmailAddresses;
        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseDetails model) {
            this.caseId(model.caseId);
            this.displayId(model.displayId);
            this.subject(model.subject);
            this.status(model.status);
            this.serviceCode(model.serviceCode);
            this.categoryCode(model.categoryCode);
            this.severityCode(model.severityCode);
            this.submittedBy(model.submittedBy);
            this.timeCreated(model.timeCreated);
            this.recentCommunications(model.recentCommunications);
            this.ccEmailAddresses(model.ccEmailAddresses);
            this.language(model.language);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getDisplayId() {
            return this.displayId;
        }

        @Override
        public final Builder displayId(String displayId) {
            this.displayId = displayId;
            return this;
        }

        public final void setDisplayId(String displayId) {
            this.displayId = displayId;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getCategoryCode() {
            return this.categoryCode;
        }

        @Override
        public final Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        public final void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        public final String getSeverityCode() {
            return this.severityCode;
        }

        @Override
        public final Builder severityCode(String severityCode) {
            this.severityCode = severityCode;
            return this;
        }

        public final void setSeverityCode(String severityCode) {
            this.severityCode = severityCode;
        }

        public final String getSubmittedBy() {
            return this.submittedBy;
        }

        @Override
        public final Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public final void setSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
        }

        public final String getTimeCreated() {
            return this.timeCreated;
        }

        @Override
        public final Builder timeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
        }

        public final RecentCaseCommunications.Builder getRecentCommunications() {
            return this.recentCommunications != null ? this.recentCommunications.toBuilder() : null;
        }

        @Override
        public final Builder recentCommunications(RecentCaseCommunications recentCommunications) {
            this.recentCommunications = recentCommunications;
            return this;
        }

        public final void setRecentCommunications(RecentCaseCommunications.BuilderImpl recentCommunications) {
            this.recentCommunications = recentCommunications != null ? recentCommunications.build() : null;
        }

        public final Collection<String> getCcEmailAddresses() {
            return this.ccEmailAddresses;
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String ... ccEmailAddresses) {
            this.ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public CaseDetails build() {
            return new CaseDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CaseDetails> {
        public Builder caseId(String var1);

        public Builder displayId(String var1);

        public Builder subject(String var1);

        public Builder status(String var1);

        public Builder serviceCode(String var1);

        public Builder categoryCode(String var1);

        public Builder severityCode(String var1);

        public Builder submittedBy(String var1);

        public Builder timeCreated(String var1);

        public Builder recentCommunications(RecentCaseCommunications var1);

        default public Builder recentCommunications(Consumer<RecentCaseCommunications.Builder> recentCommunications) {
            return this.recentCommunications((RecentCaseCommunications)((RecentCaseCommunications.Builder)RecentCaseCommunications.builder().apply(recentCommunications)).build());
        }

        public Builder ccEmailAddresses(Collection<String> var1);

        public Builder ccEmailAddresses(String ... var1);

        public Builder language(String var1);
    }
}

