/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.support.transform.AttachmentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Attachment
implements StructuredPojo,
ToCopyableBuilder<Builder, Attachment> {
    private final String fileName;
    private final ByteBuffer data;

    private Attachment(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.data = builder.data;
    }

    public String fileName() {
        return this.fileName;
    }

    public ByteBuffer data() {
        return this.data == null ? null : this.data.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.data(), other.data());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fileName() != null) {
            sb.append("FileName: ").append(this.fileName()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileName": {
                return Optional.of(clazz.cast(this.fileName()));
            }
            case "data": {
                return Optional.of(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileName;
        private ByteBuffer data;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            this.fileName(model.fileName);
            this.data(model.data);
        }

        public final String getFileName() {
            return this.fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public final ByteBuffer getData() {
            return this.data;
        }

        @Override
        public final Builder data(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
        }

        public Attachment build() {
            return new Attachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Attachment> {
        public Builder fileName(String var1);

        public Builder data(ByteBuffer var1);
    }
}

