/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The statuses of the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorCheckRefreshStatuses</a>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTrustedAdvisorCheckRefreshStatusesResponse extends AmazonWebServiceResult<ResponseMetadata>
        implements
        ToCopyableBuilder<DescribeTrustedAdvisorCheckRefreshStatusesResponse.Builder, DescribeTrustedAdvisorCheckRefreshStatusesResponse> {
    private final List<TrustedAdvisorCheckRefreshStatus> statuses;

    private DescribeTrustedAdvisorCheckRefreshStatusesResponse(BuilderImpl builder) {
        this.statuses = builder.statuses;
    }

    /**
     * <p>
     * The refresh status of the specified Trusted Advisor checks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The refresh status of the specified Trusted Advisor checks.
     */
    public List<TrustedAdvisorCheckRefreshStatus> statuses() {
        return statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statuses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckRefreshStatusesResponse)) {
            return false;
        }
        DescribeTrustedAdvisorCheckRefreshStatusesResponse other = (DescribeTrustedAdvisorCheckRefreshStatusesResponse) obj;
        return Objects.equals(statuses(), other.statuses());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (statuses() != null) {
            sb.append("Statuses: ").append(statuses()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statuses":
            return Optional.of(clazz.cast(statuses()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTrustedAdvisorCheckRefreshStatusesResponse> {
        /**
         * <p>
         * The refresh status of the specified Trusted Advisor checks.
         * </p>
         * 
         * @param statuses
         *        The refresh status of the specified Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<TrustedAdvisorCheckRefreshStatus> statuses);

        /**
         * <p>
         * The refresh status of the specified Trusted Advisor checks.
         * </p>
         * 
         * @param statuses
         *        The refresh status of the specified Trusted Advisor checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(TrustedAdvisorCheckRefreshStatus... statuses);
    }

    static final class BuilderImpl implements Builder {
        private List<TrustedAdvisorCheckRefreshStatus> statuses;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckRefreshStatusesResponse model) {
            statuses(model.statuses);
        }

        public final Collection<TrustedAdvisorCheckRefreshStatus.Builder> getStatuses() {
            return statuses != null ? statuses.stream().map(TrustedAdvisorCheckRefreshStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statuses(Collection<TrustedAdvisorCheckRefreshStatus> statuses) {
            this.statuses = TrustedAdvisorCheckRefreshStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(TrustedAdvisorCheckRefreshStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        public final void setStatuses(Collection<TrustedAdvisorCheckRefreshStatus.BuilderImpl> statuses) {
            this.statuses = TrustedAdvisorCheckRefreshStatusListCopier.copyFromBuilder(statuses);
        }

        @Override
        public DescribeTrustedAdvisorCheckRefreshStatusesResponse build() {
            return new DescribeTrustedAdvisorCheckRefreshStatusesResponse(this);
        }
    }
}
