/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCasesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeCasesRequest.Builder, DescribeCasesRequest> {
    private final List<String> caseIdList;

    private final String displayId;

    private final String afterTime;

    private final String beforeTime;

    private final Boolean includeResolvedCases;

    private final String nextToken;

    private final Integer maxResults;

    private final String language;

    private final Boolean includeCommunications;

    private DescribeCasesRequest(BuilderImpl builder) {
        this.caseIdList = builder.caseIdList;
        this.displayId = builder.displayId;
        this.afterTime = builder.afterTime;
        this.beforeTime = builder.beforeTime;
        this.includeResolvedCases = builder.includeResolvedCases;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.language = builder.language;
        this.includeCommunications = builder.includeCommunications;
    }

    /**
     * <p>
     * A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
     */
    public List<String> caseIdList() {
        return caseIdList;
    }

    /**
     * <p>
     * The ID displayed for a case in the AWS Support Center user interface.
     * </p>
     * 
     * @return The ID displayed for a case in the AWS Support Center user interface.
     */
    public String displayId() {
        return displayId;
    }

    /**
     * <p>
     * The start date for a filtered date search on support case communications. Case communications are available for
     * 12 months after creation.
     * </p>
     * 
     * @return The start date for a filtered date search on support case communications. Case communications are
     *         available for 12 months after creation.
     */
    public String afterTime() {
        return afterTime;
    }

    /**
     * <p>
     * The end date for a filtered date search on support case communications. Case communications are available for 12
     * months after creation.
     * </p>
     * 
     * @return The end date for a filtered date search on support case communications. Case communications are available
     *         for 12 months after creation.
     */
    public String beforeTime() {
        return beforeTime;
    }

    /**
     * <p>
     * Specifies whether resolved support cases should be included in the <a>DescribeCases</a> results. The default is
     * <i>false</i>.
     * </p>
     * 
     * @return Specifies whether resolved support cases should be included in the <a>DescribeCases</a> results. The
     *         default is <i>false</i>.
     */
    public Boolean includeResolvedCases() {
        return includeResolvedCases;
    }

    /**
     * <p>
     * A resumption point for pagination.
     * </p>
     * 
     * @return A resumption point for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return before paginating.
     * </p>
     * 
     * @return The maximum number of results to return before paginating.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en")
     * and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     * </p>
     * 
     * @return The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
     *         ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     */
    public String language() {
        return language;
    }

    /**
     * <p>
     * Specifies whether communications should be included in the <a>DescribeCases</a> results. The default is
     * <i>true</i>.
     * </p>
     * 
     * @return Specifies whether communications should be included in the <a>DescribeCases</a> results. The default is
     *         <i>true</i>.
     */
    public Boolean includeCommunications() {
        return includeCommunications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseIdList());
        hashCode = 31 * hashCode + Objects.hashCode(displayId());
        hashCode = 31 * hashCode + Objects.hashCode(afterTime());
        hashCode = 31 * hashCode + Objects.hashCode(beforeTime());
        hashCode = 31 * hashCode + Objects.hashCode(includeResolvedCases());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(includeCommunications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCasesRequest)) {
            return false;
        }
        DescribeCasesRequest other = (DescribeCasesRequest) obj;
        return Objects.equals(caseIdList(), other.caseIdList()) && Objects.equals(displayId(), other.displayId())
                && Objects.equals(afterTime(), other.afterTime()) && Objects.equals(beforeTime(), other.beforeTime())
                && Objects.equals(includeResolvedCases(), other.includeResolvedCases())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(language(), other.language())
                && Objects.equals(includeCommunications(), other.includeCommunications());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (caseIdList() != null) {
            sb.append("CaseIdList: ").append(caseIdList()).append(",");
        }
        if (displayId() != null) {
            sb.append("DisplayId: ").append(displayId()).append(",");
        }
        if (afterTime() != null) {
            sb.append("AfterTime: ").append(afterTime()).append(",");
        }
        if (beforeTime() != null) {
            sb.append("BeforeTime: ").append(beforeTime()).append(",");
        }
        if (includeResolvedCases() != null) {
            sb.append("IncludeResolvedCases: ").append(includeResolvedCases()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (language() != null) {
            sb.append("Language: ").append(language()).append(",");
        }
        if (includeCommunications() != null) {
            sb.append("IncludeCommunications: ").append(includeCommunications()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseIdList":
            return Optional.of(clazz.cast(caseIdList()));
        case "displayId":
            return Optional.of(clazz.cast(displayId()));
        case "afterTime":
            return Optional.of(clazz.cast(afterTime()));
        case "beforeTime":
            return Optional.of(clazz.cast(beforeTime()));
        case "includeResolvedCases":
            return Optional.of(clazz.cast(includeResolvedCases()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "language":
            return Optional.of(clazz.cast(language()));
        case "includeCommunications":
            return Optional.of(clazz.cast(includeCommunications()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeCasesRequest> {
        /**
         * <p>
         * A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
         * </p>
         * 
         * @param caseIdList
         *        A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseIdList(Collection<String> caseIdList);

        /**
         * <p>
         * A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
         * </p>
         * 
         * @param caseIdList
         *        A list of ID numbers of the support cases you want returned. The maximum number of cases is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseIdList(String... caseIdList);

        /**
         * <p>
         * The ID displayed for a case in the AWS Support Center user interface.
         * </p>
         * 
         * @param displayId
         *        The ID displayed for a case in the AWS Support Center user interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayId(String displayId);

        /**
         * <p>
         * The start date for a filtered date search on support case communications. Case communications are available
         * for 12 months after creation.
         * </p>
         * 
         * @param afterTime
         *        The start date for a filtered date search on support case communications. Case communications are
         *        available for 12 months after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterTime(String afterTime);

        /**
         * <p>
         * The end date for a filtered date search on support case communications. Case communications are available for
         * 12 months after creation.
         * </p>
         * 
         * @param beforeTime
         *        The end date for a filtered date search on support case communications. Case communications are
         *        available for 12 months after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeTime(String beforeTime);

        /**
         * <p>
         * Specifies whether resolved support cases should be included in the <a>DescribeCases</a> results. The default
         * is <i>false</i>.
         * </p>
         * 
         * @param includeResolvedCases
         *        Specifies whether resolved support cases should be included in the <a>DescribeCases</a> results. The
         *        default is <i>false</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeResolvedCases(Boolean includeResolvedCases);

        /**
         * <p>
         * A resumption point for pagination.
         * </p>
         * 
         * @param nextToken
         *        A resumption point for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return before paginating.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return before paginating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
         * ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
         *        English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that
         *        take them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * Specifies whether communications should be included in the <a>DescribeCases</a> results. The default is
         * <i>true</i>.
         * </p>
         * 
         * @param includeCommunications
         *        Specifies whether communications should be included in the <a>DescribeCases</a> results. The default
         *        is <i>true</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCommunications(Boolean includeCommunications);
    }

    static final class BuilderImpl implements Builder {
        private List<String> caseIdList;

        private String displayId;

        private String afterTime;

        private String beforeTime;

        private Boolean includeResolvedCases;

        private String nextToken;

        private Integer maxResults;

        private String language;

        private Boolean includeCommunications;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCasesRequest model) {
            caseIdList(model.caseIdList);
            displayId(model.displayId);
            afterTime(model.afterTime);
            beforeTime(model.beforeTime);
            includeResolvedCases(model.includeResolvedCases);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            language(model.language);
            includeCommunications(model.includeCommunications);
        }

        public final Collection<String> getCaseIdList() {
            return caseIdList;
        }

        @Override
        public final Builder caseIdList(Collection<String> caseIdList) {
            this.caseIdList = CaseIdListCopier.copy(caseIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseIdList(String... caseIdList) {
            caseIdList(Arrays.asList(caseIdList));
            return this;
        }

        public final void setCaseIdList(Collection<String> caseIdList) {
            this.caseIdList = CaseIdListCopier.copy(caseIdList);
        }

        public final String getDisplayId() {
            return displayId;
        }

        @Override
        public final Builder displayId(String displayId) {
            this.displayId = displayId;
            return this;
        }

        public final void setDisplayId(String displayId) {
            this.displayId = displayId;
        }

        public final String getAfterTime() {
            return afterTime;
        }

        @Override
        public final Builder afterTime(String afterTime) {
            this.afterTime = afterTime;
            return this;
        }

        public final void setAfterTime(String afterTime) {
            this.afterTime = afterTime;
        }

        public final String getBeforeTime() {
            return beforeTime;
        }

        @Override
        public final Builder beforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
            return this;
        }

        public final void setBeforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
        }

        public final Boolean getIncludeResolvedCases() {
            return includeResolvedCases;
        }

        @Override
        public final Builder includeResolvedCases(Boolean includeResolvedCases) {
            this.includeResolvedCases = includeResolvedCases;
            return this;
        }

        public final void setIncludeResolvedCases(Boolean includeResolvedCases) {
            this.includeResolvedCases = includeResolvedCases;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final Boolean getIncludeCommunications() {
            return includeCommunications;
        }

        @Override
        public final Builder includeCommunications(Boolean includeCommunications) {
            this.includeCommunications = includeCommunications;
            return this;
        }

        public final void setIncludeCommunications(Boolean includeCommunications) {
            this.includeCommunications = includeCommunications;
        }

        @Override
        public DescribeCasesRequest build() {
            return new DescribeCasesRequest(this);
        }
    }
}
