/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.AttachmentDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The file name and ID of an attachment to a case communication. You can use the ID to retrieve the attachment with the
 * <a>DescribeAttachment</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachmentDetails implements StructuredPojo, ToCopyableBuilder<AttachmentDetails.Builder, AttachmentDetails> {
    private final String attachmentId;

    private final String fileName;

    private AttachmentDetails(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.fileName = builder.fileName;
    }

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @return The ID of the attachment.
     */
    public String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * The file name of the attachment.
     * </p>
     * 
     * @return The file name of the attachment.
     */
    public String fileName() {
        return fileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentDetails)) {
            return false;
        }
        AttachmentDetails other = (AttachmentDetails) obj;
        return Objects.equals(attachmentId(), other.attachmentId()) && Objects.equals(fileName(), other.fileName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attachmentId() != null) {
            sb.append("AttachmentId: ").append(attachmentId()).append(",");
        }
        if (fileName() != null) {
            sb.append("FileName: ").append(fileName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentId":
            return Optional.of(clazz.cast(attachmentId()));
        case "fileName":
            return Optional.of(clazz.cast(fileName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttachmentDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AttachmentDetails> {
        /**
         * <p>
         * The ID of the attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * The file name of the attachment.
         * </p>
         * 
         * @param fileName
         *        The file name of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentId;

        private String fileName;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachmentDetails model) {
            attachmentId(model.attachmentId);
            fileName(model.fileName);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final String getFileName() {
            return fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public AttachmentDetails build() {
            return new AttachmentDetails(this);
        }
    }
}
