/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the <a>AddCommunicationToCase</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddCommunicationToCaseResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AddCommunicationToCaseResponse.Builder, AddCommunicationToCaseResponse> {
    private final Boolean result;

    private AddCommunicationToCaseResponse(BuilderImpl builder) {
        this.result = builder.result;
    }

    /**
     * <p>
     * True if <a>AddCommunicationToCase</a> succeeds. Otherwise, returns an error.
     * </p>
     * 
     * @return True if <a>AddCommunicationToCase</a> succeeds. Otherwise, returns an error.
     */
    public Boolean result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(result());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCommunicationToCaseResponse)) {
            return false;
        }
        AddCommunicationToCaseResponse other = (AddCommunicationToCaseResponse) obj;
        return Objects.equals(result(), other.result());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (result() != null) {
            sb.append("Result: ").append(result()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "result":
            return Optional.of(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AddCommunicationToCaseResponse> {
        /**
         * <p>
         * True if <a>AddCommunicationToCase</a> succeeds. Otherwise, returns an error.
         * </p>
         * 
         * @param result
         *        True if <a>AddCommunicationToCase</a> succeeds. Otherwise, returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(Boolean result);
    }

    static final class BuilderImpl implements Builder {
        private Boolean result;

        private BuilderImpl() {
        }

        private BuilderImpl(AddCommunicationToCaseResponse model) {
            result(model.result);
        }

        public final Boolean getResult() {
            return result;
        }

        @Override
        public final Builder result(Boolean result) {
            this.result = result;
            return this;
        }

        public final void setResult(Boolean result) {
            this.result = result;
        }

        @Override
        public AddCommunicationToCaseResponse build() {
            return new AddCommunicationToCaseResponse(this);
        }
    }
}
