/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.ServiceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an AWS service returned by the <a>DescribeServices</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Service implements StructuredPojo, ToCopyableBuilder<Service.Builder, Service> {
    private final String code;

    private final String name;

    private final List<Category> categories;

    private Service(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
        this.categories = builder.categories;
    }

    /**
     * <p>
     * The code for an AWS service returned by the <a>DescribeServices</a> response. The <code>name</code> element
     * contains the corresponding friendly name.
     * </p>
     * 
     * @return The code for an AWS service returned by the <a>DescribeServices</a> response. The <code>name</code>
     *         element contains the corresponding friendly name.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * The friendly name for an AWS service. The <code>code</code> element contains the corresponding code.
     * </p>
     * 
     * @return The friendly name for an AWS service. The <code>code</code> element contains the corresponding code.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A list of categories that describe the type of support issue a case describes. Categories consist of a category
     * name and a category code. Category names and codes are passed to AWS Support when you call <a>CreateCase</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of categories that describe the type of support issue a case describes. Categories consist of a
     *         category name and a category code. Category names and codes are passed to AWS Support when you call
     *         <a>CreateCase</a>.
     */
    public List<Category> categories() {
        return categories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((code() == null) ? 0 : code().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((categories() == null) ? 0 : categories().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.categories() == null ^ this.categories() == null) {
            return false;
        }
        if (other.categories() != null && !other.categories().equals(this.categories())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (code() != null) {
            sb.append("Code: ").append(code()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (categories() != null) {
            sb.append("Categories: ").append(categories()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * The code for an AWS service returned by the <a>DescribeServices</a> response. The <code>name</code> element
         * contains the corresponding friendly name.
         * </p>
         * 
         * @param code
         *        The code for an AWS service returned by the <a>DescribeServices</a> response. The <code>name</code>
         *        element contains the corresponding friendly name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The friendly name for an AWS service. The <code>code</code> element contains the corresponding code.
         * </p>
         * 
         * @param name
         *        The friendly name for an AWS service. The <code>code</code> element contains the corresponding code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of categories that describe the type of support issue a case describes. Categories consist of a
         * category name and a category code. Category names and codes are passed to AWS Support when you call
         * <a>CreateCase</a>.
         * </p>
         * 
         * @param categories
         *        A list of categories that describe the type of support issue a case describes. Categories consist of a
         *        category name and a category code. Category names and codes are passed to AWS Support when you call
         *        <a>CreateCase</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<Category> categories);

        /**
         * <p>
         * A list of categories that describe the type of support issue a case describes. Categories consist of a
         * category name and a category code. Category names and codes are passed to AWS Support when you call
         * <a>CreateCase</a>.
         * </p>
         * 
         * @param categories
         *        A list of categories that describe the type of support issue a case describes. Categories consist of a
         *        category name and a category code. Category names and codes are passed to AWS Support when you call
         *        <a>CreateCase</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Category... categories);
    }

    private static final class BuilderImpl implements Builder {
        private String code;

        private String name;

        private List<Category> categories;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            setCode(model.code);
            setName(model.name);
            setCategories(model.categories);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Category> getCategories() {
            return categories;
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        public final void setCategories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
        }

        @Override
        public Service build() {
            return new Service(this);
        }
    }
}
