/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of severity levels returned by the <a>DescribeSeverityLevels</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSeverityLevelsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeSeverityLevelsResponse.Builder, DescribeSeverityLevelsResponse> {
    private final List<SeverityLevel> severityLevels;

    private DescribeSeverityLevelsResponse(BuilderImpl builder) {
        this.severityLevels = builder.severityLevels;
    }

    /**
     * <p>
     * The available severity levels for the support case. Available severity levels are defined by your service level
     * agreement with AWS.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The available severity levels for the support case. Available severity levels are defined by your service
     *         level agreement with AWS.
     */
    public List<SeverityLevel> severityLevels() {
        return severityLevels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((severityLevels() == null) ? 0 : severityLevels().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSeverityLevelsResponse)) {
            return false;
        }
        DescribeSeverityLevelsResponse other = (DescribeSeverityLevelsResponse) obj;
        if (other.severityLevels() == null ^ this.severityLevels() == null) {
            return false;
        }
        if (other.severityLevels() != null && !other.severityLevels().equals(this.severityLevels())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (severityLevels() != null) {
            sb.append("SeverityLevels: ").append(severityLevels()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSeverityLevelsResponse> {
        /**
         * <p>
         * The available severity levels for the support case. Available severity levels are defined by your service
         * level agreement with AWS.
         * </p>
         * 
         * @param severityLevels
         *        The available severity levels for the support case. Available severity levels are defined by your
         *        service level agreement with AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLevels(Collection<SeverityLevel> severityLevels);

        /**
         * <p>
         * The available severity levels for the support case. Available severity levels are defined by your service
         * level agreement with AWS.
         * </p>
         * 
         * @param severityLevels
         *        The available severity levels for the support case. Available severity levels are defined by your
         *        service level agreement with AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityLevels(SeverityLevel... severityLevels);
    }

    private static final class BuilderImpl implements Builder {
        private List<SeverityLevel> severityLevels;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSeverityLevelsResponse model) {
            setSeverityLevels(model.severityLevels);
        }

        public final Collection<SeverityLevel> getSeverityLevels() {
            return severityLevels;
        }

        @Override
        public final Builder severityLevels(Collection<SeverityLevel> severityLevels) {
            this.severityLevels = SeverityLevelsListCopier.copy(severityLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(SeverityLevel... severityLevels) {
            severityLevels(Arrays.asList(severityLevels));
            return this;
        }

        public final void setSeverityLevels(Collection<SeverityLevel> severityLevels) {
            this.severityLevels = SeverityLevelsListCopier.copy(severityLevels);
        }

        @Override
        public DescribeSeverityLevelsResponse build() {
            return new DescribeSeverityLevelsResponse(this);
        }
    }
}
