/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.CommunicationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A communication associated with an AWS Support case. The communication consists of the case ID, the message body,
 * attachment information, the account email address, and the date and time of the communication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Communication implements StructuredPojo, ToCopyableBuilder<Communication.Builder, Communication> {
    private final String caseId;

    private final String body;

    private final String submittedBy;

    private final String timeCreated;

    private final List<AttachmentDetails> attachmentSet;

    private Communication(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.body = builder.body;
        this.submittedBy = builder.submittedBy;
        this.timeCreated = builder.timeCreated;
        this.attachmentSet = builder.attachmentSet;
    }

    /**
     * <p>
     * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
     * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     * </p>
     * 
     * @return The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
     *         formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     */
    public String caseId() {
        return caseId;
    }

    /**
     * <p>
     * The text of the communication between the customer and AWS Support.
     * </p>
     * 
     * @return The text of the communication between the customer and AWS Support.
     */
    public String body() {
        return body;
    }

    /**
     * <p>
     * The email address of the account that submitted the AWS Support case.
     * </p>
     * 
     * @return The email address of the account that submitted the AWS Support case.
     */
    public String submittedBy() {
        return submittedBy;
    }

    /**
     * <p>
     * The time the communication was created.
     * </p>
     * 
     * @return The time the communication was created.
     */
    public String timeCreated() {
        return timeCreated;
    }

    /**
     * <p>
     * Information about the attachments to the case communication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the attachments to the case communication.
     */
    public List<AttachmentDetails> attachmentSet() {
        return attachmentSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((caseId() == null) ? 0 : caseId().hashCode());
        hashCode = 31 * hashCode + ((body() == null) ? 0 : body().hashCode());
        hashCode = 31 * hashCode + ((submittedBy() == null) ? 0 : submittedBy().hashCode());
        hashCode = 31 * hashCode + ((timeCreated() == null) ? 0 : timeCreated().hashCode());
        hashCode = 31 * hashCode + ((attachmentSet() == null) ? 0 : attachmentSet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Communication)) {
            return false;
        }
        Communication other = (Communication) obj;
        if (other.caseId() == null ^ this.caseId() == null) {
            return false;
        }
        if (other.caseId() != null && !other.caseId().equals(this.caseId())) {
            return false;
        }
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        if (other.body() != null && !other.body().equals(this.body())) {
            return false;
        }
        if (other.submittedBy() == null ^ this.submittedBy() == null) {
            return false;
        }
        if (other.submittedBy() != null && !other.submittedBy().equals(this.submittedBy())) {
            return false;
        }
        if (other.timeCreated() == null ^ this.timeCreated() == null) {
            return false;
        }
        if (other.timeCreated() != null && !other.timeCreated().equals(this.timeCreated())) {
            return false;
        }
        if (other.attachmentSet() == null ^ this.attachmentSet() == null) {
            return false;
        }
        if (other.attachmentSet() != null && !other.attachmentSet().equals(this.attachmentSet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (caseId() != null) {
            sb.append("CaseId: ").append(caseId()).append(",");
        }
        if (body() != null) {
            sb.append("Body: ").append(body()).append(",");
        }
        if (submittedBy() != null) {
            sb.append("SubmittedBy: ").append(submittedBy()).append(",");
        }
        if (timeCreated() != null) {
            sb.append("TimeCreated: ").append(timeCreated()).append(",");
        }
        if (attachmentSet() != null) {
            sb.append("AttachmentSet: ").append(attachmentSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommunicationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Communication> {
        /**
         * <p>
         * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
         * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * </p>
         * 
         * @param caseId
         *        The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
         *        formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * The text of the communication between the customer and AWS Support.
         * </p>
         * 
         * @param body
         *        The text of the communication between the customer and AWS Support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The email address of the account that submitted the AWS Support case.
         * </p>
         * 
         * @param submittedBy
         *        The email address of the account that submitted the AWS Support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedBy(String submittedBy);

        /**
         * <p>
         * The time the communication was created.
         * </p>
         * 
         * @param timeCreated
         *        The time the communication was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeCreated(String timeCreated);

        /**
         * <p>
         * Information about the attachments to the case communication.
         * </p>
         * 
         * @param attachmentSet
         *        Information about the attachments to the case communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSet(Collection<AttachmentDetails> attachmentSet);

        /**
         * <p>
         * Information about the attachments to the case communication.
         * </p>
         * 
         * @param attachmentSet
         *        Information about the attachments to the case communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSet(AttachmentDetails... attachmentSet);
    }

    private static final class BuilderImpl implements Builder {
        private String caseId;

        private String body;

        private String submittedBy;

        private String timeCreated;

        private List<AttachmentDetails> attachmentSet;

        private BuilderImpl() {
        }

        private BuilderImpl(Communication model) {
            setCaseId(model.caseId);
            setBody(model.body);
            setSubmittedBy(model.submittedBy);
            setTimeCreated(model.timeCreated);
            setAttachmentSet(model.attachmentSet);
        }

        public final String getCaseId() {
            return caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getSubmittedBy() {
            return submittedBy;
        }

        @Override
        public final Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public final void setSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
        }

        public final String getTimeCreated() {
            return timeCreated;
        }

        @Override
        public final Builder timeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
        }

        public final Collection<AttachmentDetails> getAttachmentSet() {
            return attachmentSet;
        }

        @Override
        public final Builder attachmentSet(Collection<AttachmentDetails> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copy(attachmentSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentSet(AttachmentDetails... attachmentSet) {
            attachmentSet(Arrays.asList(attachmentSet));
            return this;
        }

        public final void setAttachmentSet(Collection<AttachmentDetails> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copy(attachmentSet);
        }

        @Override
        public Communication build() {
            return new Communication(this);
        }
    }
}
