/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCommunicationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeCommunicationsRequest.Builder, DescribeCommunicationsRequest> {
    private final String caseId;

    private final String beforeTime;

    private final String afterTime;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeCommunicationsRequest(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.beforeTime = builder.beforeTime;
        this.afterTime = builder.afterTime;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
     * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     * </p>
     * 
     * @return The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
     *         formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     */
    public String caseId() {
        return caseId;
    }

    /**
     * <p>
     * The end date for a filtered date search on support case communications. Case communications are available for 12
     * months after creation.
     * </p>
     * 
     * @return The end date for a filtered date search on support case communications. Case communications are available
     *         for 12 months after creation.
     */
    public String beforeTime() {
        return beforeTime;
    }

    /**
     * <p>
     * The start date for a filtered date search on support case communications. Case communications are available for
     * 12 months after creation.
     * </p>
     * 
     * @return The start date for a filtered date search on support case communications. Case communications are
     *         available for 12 months after creation.
     */
    public String afterTime() {
        return afterTime;
    }

    /**
     * <p>
     * A resumption point for pagination.
     * </p>
     * 
     * @return A resumption point for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return before paginating.
     * </p>
     * 
     * @return The maximum number of results to return before paginating.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((caseId() == null) ? 0 : caseId().hashCode());
        hashCode = 31 * hashCode + ((beforeTime() == null) ? 0 : beforeTime().hashCode());
        hashCode = 31 * hashCode + ((afterTime() == null) ? 0 : afterTime().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommunicationsRequest)) {
            return false;
        }
        DescribeCommunicationsRequest other = (DescribeCommunicationsRequest) obj;
        if (other.caseId() == null ^ this.caseId() == null) {
            return false;
        }
        if (other.caseId() != null && !other.caseId().equals(this.caseId())) {
            return false;
        }
        if (other.beforeTime() == null ^ this.beforeTime() == null) {
            return false;
        }
        if (other.beforeTime() != null && !other.beforeTime().equals(this.beforeTime())) {
            return false;
        }
        if (other.afterTime() == null ^ this.afterTime() == null) {
            return false;
        }
        if (other.afterTime() != null && !other.afterTime().equals(this.afterTime())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (caseId() != null) {
            sb.append("CaseId: ").append(caseId()).append(",");
        }
        if (beforeTime() != null) {
            sb.append("BeforeTime: ").append(beforeTime()).append(",");
        }
        if (afterTime() != null) {
            sb.append("AfterTime: ").append(afterTime()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeCommunicationsRequest> {
        /**
         * <p>
         * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
         * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * </p>
         * 
         * @param caseId
         *        The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
         *        formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * The end date for a filtered date search on support case communications. Case communications are available for
         * 12 months after creation.
         * </p>
         * 
         * @param beforeTime
         *        The end date for a filtered date search on support case communications. Case communications are
         *        available for 12 months after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeTime(String beforeTime);

        /**
         * <p>
         * The start date for a filtered date search on support case communications. Case communications are available
         * for 12 months after creation.
         * </p>
         * 
         * @param afterTime
         *        The start date for a filtered date search on support case communications. Case communications are
         *        available for 12 months after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterTime(String afterTime);

        /**
         * <p>
         * A resumption point for pagination.
         * </p>
         * 
         * @param nextToken
         *        A resumption point for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return before paginating.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return before paginating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);
    }

    private static final class BuilderImpl implements Builder {
        private String caseId;

        private String beforeTime;

        private String afterTime;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommunicationsRequest model) {
            setCaseId(model.caseId);
            setBeforeTime(model.beforeTime);
            setAfterTime(model.afterTime);
            setNextToken(model.nextToken);
            setMaxResults(model.maxResults);
        }

        public final String getCaseId() {
            return caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getBeforeTime() {
            return beforeTime;
        }

        @Override
        public final Builder beforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
            return this;
        }

        public final void setBeforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
        }

        public final String getAfterTime() {
            return afterTime;
        }

        @Override
        public final Builder afterTime(String afterTime) {
            this.afterTime = afterTime;
            return this;
        }

        public final void setAfterTime(String afterTime) {
            this.afterTime = afterTime;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public DescribeCommunicationsRequest build() {
            return new DescribeCommunicationsRequest(this);
        }
    }
}
