/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTokenWithIamResponse extends SsoOidcResponse implements
        ToCopyableBuilder<CreateTokenWithIamResponse.Builder, CreateTokenWithIamResponse> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(CreateTokenWithIamResponse::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<String> TOKEN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenType").getter(getter(CreateTokenWithIamResponse::tokenType)).setter(setter(Builder::tokenType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenType").build()).build();

    private static final SdkField<Integer> EXPIRES_IN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("expiresIn").getter(getter(CreateTokenWithIamResponse::expiresIn)).setter(setter(Builder::expiresIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresIn").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("refreshToken").getter(getter(CreateTokenWithIamResponse::refreshToken))
            .setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()).build();

    private static final SdkField<String> ID_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idToken").getter(getter(CreateTokenWithIamResponse::idToken)).setter(setter(Builder::idToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idToken").build()).build();

    private static final SdkField<String> ISSUED_TOKEN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("issuedTokenType").getter(getter(CreateTokenWithIamResponse::issuedTokenType))
            .setter(setter(Builder::issuedTokenType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuedTokenType").build()).build();

    private static final SdkField<List<String>> SCOPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("scope")
            .getter(getter(CreateTokenWithIamResponse::scope))
            .setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsAdditionalDetails> AWS_ADDITIONAL_DETAILS_FIELD = SdkField
            .<AwsAdditionalDetails> builder(MarshallingType.SDK_POJO).memberName("awsAdditionalDetails")
            .getter(getter(CreateTokenWithIamResponse::awsAdditionalDetails)).setter(setter(Builder::awsAdditionalDetails))
            .constructor(AwsAdditionalDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAdditionalDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            TOKEN_TYPE_FIELD, EXPIRES_IN_FIELD, REFRESH_TOKEN_FIELD, ID_TOKEN_FIELD, ISSUED_TOKEN_TYPE_FIELD, SCOPE_FIELD,
            AWS_ADDITIONAL_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accessToken;

    private final String tokenType;

    private final Integer expiresIn;

    private final String refreshToken;

    private final String idToken;

    private final String issuedTokenType;

    private final List<String> scope;

    private final AwsAdditionalDetails awsAdditionalDetails;

    private CreateTokenWithIamResponse(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.tokenType = builder.tokenType;
        this.expiresIn = builder.expiresIn;
        this.refreshToken = builder.refreshToken;
        this.idToken = builder.idToken;
        this.issuedTokenType = builder.issuedTokenType;
        this.scope = builder.scope;
        this.awsAdditionalDetails = builder.awsAdditionalDetails;
    }

    /**
     * <p>
     * A bearer token to access Amazon Web Services accounts and applications assigned to a user.
     * </p>
     * 
     * @return A bearer token to access Amazon Web Services accounts and applications assigned to a user.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * Used to notify the requester that the returned token is an access token. The supported token type is
     * <code>Bearer</code>.
     * </p>
     * 
     * @return Used to notify the requester that the returned token is an access token. The supported token type is
     *         <code>Bearer</code>.
     */
    public final String tokenType() {
        return tokenType;
    }

    /**
     * <p>
     * Indicates the time in seconds when an access token will expire.
     * </p>
     * 
     * @return Indicates the time in seconds when an access token will expire.
     */
    public final Integer expiresIn() {
        return expiresIn;
    }

    /**
     * <p>
     * A token that, if present, can be used to refresh a previously issued access token that might have expired.
     * </p>
     * <p>
     * For more information about the features and limitations of the current IAM Identity Center OIDC implementation,
     * see <i>Considerations for Using this Guide</i> in the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API
     * Reference</a>.
     * </p>
     * 
     * @return A token that, if present, can be used to refresh a previously issued access token that might have
     *         expired.</p>
     *         <p>
     *         For more information about the features and limitations of the current IAM Identity Center OIDC
     *         implementation, see <i>Considerations for Using this Guide</i> in the <a
     *         href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center
     *         OIDC API Reference</a>.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * <p>
     * A JSON Web Token (JWT) that identifies the user associated with the issued access token.
     * </p>
     * 
     * @return A JSON Web Token (JWT) that identifies the user associated with the issued access token.
     */
    public final String idToken() {
        return idToken;
    }

    /**
     * <p>
     * Indicates the type of tokens that are issued by IAM Identity Center. The following values are supported:
     * </p>
     * <p>
     * * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
     * </p>
     * <p>
     * * Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code>
     * </p>
     * 
     * @return Indicates the type of tokens that are issued by IAM Identity Center. The following values are supported:
     *         </p>
     *         <p>
     *         * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
     *         </p>
     *         <p>
     *         * Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code>
     */
    public final String issuedTokenType() {
        return issuedTokenType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scope property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasScope() {
        return scope != null && !(scope instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scopes for which authorization is granted. The access token that is issued is limited to the scopes
     * that are granted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScope} method.
     * </p>
     * 
     * @return The list of scopes for which authorization is granted. The access token that is issued is limited to the
     *         scopes that are granted.
     */
    public final List<String> scope() {
        return scope;
    }

    /**
     * <p>
     * A structure containing information from the <code>idToken</code>. Only the <code>identityContext</code> is in it,
     * which is a value extracted from the <code>idToken</code>. This provides direct access to identity information
     * without requiring JWT parsing.
     * </p>
     * 
     * @return A structure containing information from the <code>idToken</code>. Only the <code>identityContext</code>
     *         is in it, which is a value extracted from the <code>idToken</code>. This provides direct access to
     *         identity information without requiring JWT parsing.
     */
    public final AwsAdditionalDetails awsAdditionalDetails() {
        return awsAdditionalDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(tokenType());
        hashCode = 31 * hashCode + Objects.hashCode(expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(idToken());
        hashCode = 31 * hashCode + Objects.hashCode(issuedTokenType());
        hashCode = 31 * hashCode + Objects.hashCode(hasScope() ? scope() : null);
        hashCode = 31 * hashCode + Objects.hashCode(awsAdditionalDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenWithIamResponse)) {
            return false;
        }
        CreateTokenWithIamResponse other = (CreateTokenWithIamResponse) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(tokenType(), other.tokenType())
                && Objects.equals(expiresIn(), other.expiresIn()) && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(idToken(), other.idToken()) && Objects.equals(issuedTokenType(), other.issuedTokenType())
                && hasScope() == other.hasScope() && Objects.equals(scope(), other.scope())
                && Objects.equals(awsAdditionalDetails(), other.awsAdditionalDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTokenWithIamResponse")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TokenType", tokenType()).add("ExpiresIn", expiresIn())
                .add("RefreshToken", refreshToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IdToken", idToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IssuedTokenType", issuedTokenType()).add("Scope", hasScope() ? scope() : null)
                .add("AwsAdditionalDetails", awsAdditionalDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "tokenType":
            return Optional.ofNullable(clazz.cast(tokenType()));
        case "expiresIn":
            return Optional.ofNullable(clazz.cast(expiresIn()));
        case "refreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "idToken":
            return Optional.ofNullable(clazz.cast(idToken()));
        case "issuedTokenType":
            return Optional.ofNullable(clazz.cast(issuedTokenType()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "awsAdditionalDetails":
            return Optional.ofNullable(clazz.cast(awsAdditionalDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("tokenType", TOKEN_TYPE_FIELD);
        map.put("expiresIn", EXPIRES_IN_FIELD);
        map.put("refreshToken", REFRESH_TOKEN_FIELD);
        map.put("idToken", ID_TOKEN_FIELD);
        map.put("issuedTokenType", ISSUED_TOKEN_TYPE_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("awsAdditionalDetails", AWS_ADDITIONAL_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenWithIamResponse, T> g) {
        return obj -> g.apply((CreateTokenWithIamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoOidcResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTokenWithIamResponse> {
        /**
         * <p>
         * A bearer token to access Amazon Web Services accounts and applications assigned to a user.
         * </p>
         * 
         * @param accessToken
         *        A bearer token to access Amazon Web Services accounts and applications assigned to a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * Used to notify the requester that the returned token is an access token. The supported token type is
         * <code>Bearer</code>.
         * </p>
         * 
         * @param tokenType
         *        Used to notify the requester that the returned token is an access token. The supported token type is
         *        <code>Bearer</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenType(String tokenType);

        /**
         * <p>
         * Indicates the time in seconds when an access token will expire.
         * </p>
         * 
         * @param expiresIn
         *        Indicates the time in seconds when an access token will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresIn(Integer expiresIn);

        /**
         * <p>
         * A token that, if present, can be used to refresh a previously issued access token that might have expired.
         * </p>
         * <p>
         * For more information about the features and limitations of the current IAM Identity Center OIDC
         * implementation, see <i>Considerations for Using this Guide</i> in the <a
         * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC
         * API Reference</a>.
         * </p>
         * 
         * @param refreshToken
         *        A token that, if present, can be used to refresh a previously issued access token that might have
         *        expired.</p>
         *        <p>
         *        For more information about the features and limitations of the current IAM Identity Center OIDC
         *        implementation, see <i>Considerations for Using this Guide</i> in the <a
         *        href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity
         *        Center OIDC API Reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * A JSON Web Token (JWT) that identifies the user associated with the issued access token.
         * </p>
         * 
         * @param idToken
         *        A JSON Web Token (JWT) that identifies the user associated with the issued access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idToken(String idToken);

        /**
         * <p>
         * Indicates the type of tokens that are issued by IAM Identity Center. The following values are supported:
         * </p>
         * <p>
         * * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
         * </p>
         * <p>
         * * Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code>
         * </p>
         * 
         * @param issuedTokenType
         *        Indicates the type of tokens that are issued by IAM Identity Center. The following values are
         *        supported: </p>
         *        <p>
         *        * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
         *        </p>
         *        <p>
         *        * Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuedTokenType(String issuedTokenType);

        /**
         * <p>
         * The list of scopes for which authorization is granted. The access token that is issued is limited to the
         * scopes that are granted.
         * </p>
         * 
         * @param scope
         *        The list of scopes for which authorization is granted. The access token that is issued is limited to
         *        the scopes that are granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Collection<String> scope);

        /**
         * <p>
         * The list of scopes for which authorization is granted. The access token that is issued is limited to the
         * scopes that are granted.
         * </p>
         * 
         * @param scope
         *        The list of scopes for which authorization is granted. The access token that is issued is limited to
         *        the scopes that are granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String... scope);

        /**
         * <p>
         * A structure containing information from the <code>idToken</code>. Only the <code>identityContext</code> is in
         * it, which is a value extracted from the <code>idToken</code>. This provides direct access to identity
         * information without requiring JWT parsing.
         * </p>
         * 
         * @param awsAdditionalDetails
         *        A structure containing information from the <code>idToken</code>. Only the
         *        <code>identityContext</code> is in it, which is a value extracted from the <code>idToken</code>. This
         *        provides direct access to identity information without requiring JWT parsing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAdditionalDetails(AwsAdditionalDetails awsAdditionalDetails);

        /**
         * <p>
         * A structure containing information from the <code>idToken</code>. Only the <code>identityContext</code> is in
         * it, which is a value extracted from the <code>idToken</code>. This provides direct access to identity
         * information without requiring JWT parsing.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsAdditionalDetails.Builder} avoiding
         * the need to create one manually via {@link AwsAdditionalDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsAdditionalDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsAdditionalDetails(AwsAdditionalDetails)}.
         * 
         * @param awsAdditionalDetails
         *        a consumer that will call methods on {@link AwsAdditionalDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAdditionalDetails(AwsAdditionalDetails)
         */
        default Builder awsAdditionalDetails(Consumer<AwsAdditionalDetails.Builder> awsAdditionalDetails) {
            return awsAdditionalDetails(AwsAdditionalDetails.builder().applyMutation(awsAdditionalDetails).build());
        }
    }

    static final class BuilderImpl extends SsoOidcResponse.BuilderImpl implements Builder {
        private String accessToken;

        private String tokenType;

        private Integer expiresIn;

        private String refreshToken;

        private String idToken;

        private String issuedTokenType;

        private List<String> scope = DefaultSdkAutoConstructList.getInstance();

        private AwsAdditionalDetails awsAdditionalDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenWithIamResponse model) {
            super(model);
            accessToken(model.accessToken);
            tokenType(model.tokenType);
            expiresIn(model.expiresIn);
            refreshToken(model.refreshToken);
            idToken(model.idToken);
            issuedTokenType(model.issuedTokenType);
            scope(model.scope);
            awsAdditionalDetails(model.awsAdditionalDetails);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getTokenType() {
            return tokenType;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public final Integer getExpiresIn() {
            return expiresIn;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getIdToken() {
            return idToken;
        }

        public final void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        @Override
        public final Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public final String getIssuedTokenType() {
            return issuedTokenType;
        }

        public final void setIssuedTokenType(String issuedTokenType) {
            this.issuedTokenType = issuedTokenType;
        }

        @Override
        public final Builder issuedTokenType(String issuedTokenType) {
            this.issuedTokenType = issuedTokenType;
            return this;
        }

        public final Collection<String> getScope() {
            if (scope instanceof SdkAutoConstructList) {
                return null;
            }
            return scope;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
        }

        @Override
        public final Builder scope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(String... scope) {
            scope(Arrays.asList(scope));
            return this;
        }

        public final AwsAdditionalDetails.Builder getAwsAdditionalDetails() {
            return awsAdditionalDetails != null ? awsAdditionalDetails.toBuilder() : null;
        }

        public final void setAwsAdditionalDetails(AwsAdditionalDetails.BuilderImpl awsAdditionalDetails) {
            this.awsAdditionalDetails = awsAdditionalDetails != null ? awsAdditionalDetails.build() : null;
        }

        @Override
        public final Builder awsAdditionalDetails(AwsAdditionalDetails awsAdditionalDetails) {
            this.awsAdditionalDetails = awsAdditionalDetails;
            return this;
        }

        @Override
        public CreateTokenWithIamResponse build() {
            return new CreateTokenWithIamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
