/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssooidc.model.GrantTypesCopier;
import software.amazon.awssdk.services.ssooidc.model.RedirectUrisCopier;
import software.amazon.awssdk.services.ssooidc.model.ScopesCopier;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterClientRequest
extends SsoOidcRequest
implements ToCopyableBuilder<Builder, RegisterClientRequest> {
    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientName").getter(RegisterClientRequest.getter(RegisterClientRequest::clientName)).setter(RegisterClientRequest.setter(Builder::clientName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientName").build()}).build();
    private static final SdkField<String> CLIENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientType").getter(RegisterClientRequest.getter(RegisterClientRequest::clientType)).setter(RegisterClientRequest.setter(Builder::clientType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientType").build()}).build();
    private static final SdkField<List<String>> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scopes").getter(RegisterClientRequest.getter(RegisterClientRequest::scopes)).setter(RegisterClientRequest.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REDIRECT_URIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("redirectUris").getter(RegisterClientRequest.getter(RegisterClientRequest::redirectUris)).setter(RegisterClientRequest.setter(Builder::redirectUris)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUris").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GRANT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("grantTypes").getter(RegisterClientRequest.getter(RegisterClientRequest::grantTypes)).setter(RegisterClientRequest.setter(Builder::grantTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ISSUER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuerUrl").getter(RegisterClientRequest.getter(RegisterClientRequest::issuerUrl)).setter(RegisterClientRequest.setter(Builder::issuerUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerUrl").build()}).build();
    private static final SdkField<String> ENTITLED_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entitledApplicationArn").getter(RegisterClientRequest.getter(RegisterClientRequest::entitledApplicationArn)).setter(RegisterClientRequest.setter(Builder::entitledApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitledApplicationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_NAME_FIELD, CLIENT_TYPE_FIELD, SCOPES_FIELD, REDIRECT_URIS_FIELD, GRANT_TYPES_FIELD, ISSUER_URL_FIELD, ENTITLED_APPLICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientName", CLIENT_NAME_FIELD);
            this.put("clientType", CLIENT_TYPE_FIELD);
            this.put("scopes", SCOPES_FIELD);
            this.put("redirectUris", REDIRECT_URIS_FIELD);
            this.put("grantTypes", GRANT_TYPES_FIELD);
            this.put("issuerUrl", ISSUER_URL_FIELD);
            this.put("entitledApplicationArn", ENTITLED_APPLICATION_ARN_FIELD);
        }
    });
    private final String clientName;
    private final String clientType;
    private final List<String> scopes;
    private final List<String> redirectUris;
    private final List<String> grantTypes;
    private final String issuerUrl;
    private final String entitledApplicationArn;

    private RegisterClientRequest(BuilderImpl builder) {
        super(builder);
        this.clientName = builder.clientName;
        this.clientType = builder.clientType;
        this.scopes = builder.scopes;
        this.redirectUris = builder.redirectUris;
        this.grantTypes = builder.grantTypes;
        this.issuerUrl = builder.issuerUrl;
        this.entitledApplicationArn = builder.entitledApplicationArn;
    }

    public final String clientName() {
        return this.clientName;
    }

    public final String clientType() {
        return this.clientType;
    }

    public final boolean hasScopes() {
        return this.scopes != null && !(this.scopes instanceof SdkAutoConstructList);
    }

    public final List<String> scopes() {
        return this.scopes;
    }

    public final boolean hasRedirectUris() {
        return this.redirectUris != null && !(this.redirectUris instanceof SdkAutoConstructList);
    }

    public final List<String> redirectUris() {
        return this.redirectUris;
    }

    public final boolean hasGrantTypes() {
        return this.grantTypes != null && !(this.grantTypes instanceof SdkAutoConstructList);
    }

    public final List<String> grantTypes() {
        return this.grantTypes;
    }

    public final String issuerUrl() {
        return this.issuerUrl;
    }

    public final String entitledApplicationArn() {
        return this.entitledApplicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScopes() ? this.scopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRedirectUris() ? this.redirectUris() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantTypes() ? this.grantTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.issuerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitledApplicationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterClientRequest)) {
            return false;
        }
        RegisterClientRequest other = (RegisterClientRequest)((Object)obj);
        return Objects.equals(this.clientName(), other.clientName()) && Objects.equals(this.clientType(), other.clientType()) && this.hasScopes() == other.hasScopes() && Objects.equals(this.scopes(), other.scopes()) && this.hasRedirectUris() == other.hasRedirectUris() && Objects.equals(this.redirectUris(), other.redirectUris()) && this.hasGrantTypes() == other.hasGrantTypes() && Objects.equals(this.grantTypes(), other.grantTypes()) && Objects.equals(this.issuerUrl(), other.issuerUrl()) && Objects.equals(this.entitledApplicationArn(), other.entitledApplicationArn());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterClientRequest").add("ClientName", (Object)this.clientName()).add("ClientType", (Object)this.clientType()).add("Scopes", this.hasScopes() ? this.scopes() : null).add("RedirectUris", this.hasRedirectUris() ? this.redirectUris() : null).add("GrantTypes", this.hasGrantTypes() ? this.grantTypes() : null).add("IssuerUrl", (Object)this.issuerUrl()).add("EntitledApplicationArn", (Object)this.entitledApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientName": {
                return Optional.ofNullable(clazz.cast(this.clientName()));
            }
            case "clientType": {
                return Optional.ofNullable(clazz.cast(this.clientType()));
            }
            case "scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
            case "redirectUris": {
                return Optional.ofNullable(clazz.cast(this.redirectUris()));
            }
            case "grantTypes": {
                return Optional.ofNullable(clazz.cast(this.grantTypes()));
            }
            case "issuerUrl": {
                return Optional.ofNullable(clazz.cast(this.issuerUrl()));
            }
            case "entitledApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.entitledApplicationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegisterClientRequest, T> g) {
        return obj -> g.apply((RegisterClientRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoOidcRequest.BuilderImpl
    implements Builder {
        private String clientName;
        private String clientType;
        private List<String> scopes = DefaultSdkAutoConstructList.getInstance();
        private List<String> redirectUris = DefaultSdkAutoConstructList.getInstance();
        private List<String> grantTypes = DefaultSdkAutoConstructList.getInstance();
        private String issuerUrl;
        private String entitledApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterClientRequest model) {
            super(model);
            this.clientName(model.clientName);
            this.clientType(model.clientType);
            this.scopes(model.scopes);
            this.redirectUris(model.redirectUris);
            this.grantTypes(model.grantTypes);
            this.issuerUrl(model.issuerUrl);
            this.entitledApplicationArn(model.entitledApplicationArn);
        }

        public final String getClientName() {
            return this.clientName;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final String getClientType() {
            return this.clientType;
        }

        public final void setClientType(String clientType) {
            this.clientType = clientType;
        }

        @Override
        public final Builder clientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        public final Collection<String> getScopes() {
            if (this.scopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scopes;
        }

        public final void setScopes(Collection<String> scopes) {
            this.scopes = ScopesCopier.copy(scopes);
        }

        @Override
        public final Builder scopes(Collection<String> scopes) {
            this.scopes = ScopesCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(String ... scopes) {
            this.scopes(Arrays.asList(scopes));
            return this;
        }

        public final Collection<String> getRedirectUris() {
            if (this.redirectUris instanceof SdkAutoConstructList) {
                return null;
            }
            return this.redirectUris;
        }

        public final void setRedirectUris(Collection<String> redirectUris) {
            this.redirectUris = RedirectUrisCopier.copy(redirectUris);
        }

        @Override
        public final Builder redirectUris(Collection<String> redirectUris) {
            this.redirectUris = RedirectUrisCopier.copy(redirectUris);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redirectUris(String ... redirectUris) {
            this.redirectUris(Arrays.asList(redirectUris));
            return this;
        }

        public final Collection<String> getGrantTypes() {
            if (this.grantTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grantTypes;
        }

        public final void setGrantTypes(Collection<String> grantTypes) {
            this.grantTypes = GrantTypesCopier.copy(grantTypes);
        }

        @Override
        public final Builder grantTypes(Collection<String> grantTypes) {
            this.grantTypes = GrantTypesCopier.copy(grantTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTypes(String ... grantTypes) {
            this.grantTypes(Arrays.asList(grantTypes));
            return this;
        }

        public final String getIssuerUrl() {
            return this.issuerUrl;
        }

        public final void setIssuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
        }

        @Override
        public final Builder issuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        public final String getEntitledApplicationArn() {
            return this.entitledApplicationArn;
        }

        public final void setEntitledApplicationArn(String entitledApplicationArn) {
            this.entitledApplicationArn = entitledApplicationArn;
        }

        @Override
        public final Builder entitledApplicationArn(String entitledApplicationArn) {
            this.entitledApplicationArn = entitledApplicationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterClientRequest build() {
            return new RegisterClientRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsoOidcRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterClientRequest> {
        public Builder clientName(String var1);

        public Builder clientType(String var1);

        public Builder scopes(Collection<String> var1);

        public Builder scopes(String ... var1);

        public Builder redirectUris(Collection<String> var1);

        public Builder redirectUris(String ... var1);

        public Builder grantTypes(Collection<String> var1);

        public Builder grantTypes(String ... var1);

        public Builder issuerUrl(String var1);

        public Builder entitledApplicationArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

