/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTokenWithIamRequest extends SsoOidcRequest implements
        ToCopyableBuilder<CreateTokenWithIamRequest.Builder, CreateTokenWithIamRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(CreateTokenWithIamRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<String> GRANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("grantType").getter(getter(CreateTokenWithIamRequest::grantType)).setter(setter(Builder::grantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantType").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(CreateTokenWithIamRequest::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("refreshToken").getter(getter(CreateTokenWithIamRequest::refreshToken))
            .setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()).build();

    private static final SdkField<String> ASSERTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assertion").getter(getter(CreateTokenWithIamRequest::assertion)).setter(setter(Builder::assertion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assertion").build()).build();

    private static final SdkField<List<String>> SCOPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("scope")
            .getter(getter(CreateTokenWithIamRequest::scope))
            .setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("redirectUri").getter(getter(CreateTokenWithIamRequest::redirectUri))
            .setter(setter(Builder::redirectUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUri").build()).build();

    private static final SdkField<String> SUBJECT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectToken").getter(getter(CreateTokenWithIamRequest::subjectToken))
            .setter(setter(Builder::subjectToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectToken").build()).build();

    private static final SdkField<String> SUBJECT_TOKEN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectTokenType").getter(getter(CreateTokenWithIamRequest::subjectTokenType))
            .setter(setter(Builder::subjectTokenType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectTokenType").build()).build();

    private static final SdkField<String> REQUESTED_TOKEN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestedTokenType").getter(getter(CreateTokenWithIamRequest::requestedTokenType))
            .setter(setter(Builder::requestedTokenType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedTokenType").build())
            .build();

    private static final SdkField<String> CODE_VERIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeVerifier").getter(getter(CreateTokenWithIamRequest::codeVerifier))
            .setter(setter(Builder::codeVerifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeVerifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            GRANT_TYPE_FIELD, CODE_FIELD, REFRESH_TOKEN_FIELD, ASSERTION_FIELD, SCOPE_FIELD, REDIRECT_URI_FIELD,
            SUBJECT_TOKEN_FIELD, SUBJECT_TOKEN_TYPE_FIELD, REQUESTED_TOKEN_TYPE_FIELD, CODE_VERIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("clientId", CLIENT_ID_FIELD);
                    put("grantType", GRANT_TYPE_FIELD);
                    put("code", CODE_FIELD);
                    put("refreshToken", REFRESH_TOKEN_FIELD);
                    put("assertion", ASSERTION_FIELD);
                    put("scope", SCOPE_FIELD);
                    put("redirectUri", REDIRECT_URI_FIELD);
                    put("subjectToken", SUBJECT_TOKEN_FIELD);
                    put("subjectTokenType", SUBJECT_TOKEN_TYPE_FIELD);
                    put("requestedTokenType", REQUESTED_TOKEN_TYPE_FIELD);
                    put("codeVerifier", CODE_VERIFIER_FIELD);
                }
            });

    private final String clientId;

    private final String grantType;

    private final String code;

    private final String refreshToken;

    private final String assertion;

    private final List<String> scope;

    private final String redirectUri;

    private final String subjectToken;

    private final String subjectTokenType;

    private final String requestedTokenType;

    private final String codeVerifier;

    private CreateTokenWithIamRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.grantType = builder.grantType;
        this.code = builder.code;
        this.refreshToken = builder.refreshToken;
        this.assertion = builder.assertion;
        this.scope = builder.scope;
        this.redirectUri = builder.redirectUri;
        this.subjectToken = builder.subjectToken;
        this.subjectTokenType = builder.subjectTokenType;
        this.requestedTokenType = builder.requestedTokenType;
        this.codeVerifier = builder.codeVerifier;
    }

    /**
     * <p>
     * The unique identifier string for the client or application. This value is an application ARN that has OAuth
     * grants configured.
     * </p>
     * 
     * @return The unique identifier string for the client or application. This value is an application ARN that has
     *         OAuth grants configured.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * Supports the following OAuth grant types: Authorization Code, Refresh Token, JWT Bearer, and Token Exchange.
     * Specify one of the following values, depending on the grant type that you want:
     * </p>
     * <p>
     * * Authorization Code - <code>authorization_code</code>
     * </p>
     * <p>
     * * Refresh Token - <code>refresh_token</code>
     * </p>
     * <p>
     * * JWT Bearer - <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code>
     * </p>
     * <p>
     * * Token Exchange - <code>urn:ietf:params:oauth:grant-type:token-exchange</code>
     * </p>
     * 
     * @return Supports the following OAuth grant types: Authorization Code, Refresh Token, JWT Bearer, and Token
     *         Exchange. Specify one of the following values, depending on the grant type that you want:</p>
     *         <p>
     *         * Authorization Code - <code>authorization_code</code>
     *         </p>
     *         <p>
     *         * Refresh Token - <code>refresh_token</code>
     *         </p>
     *         <p>
     *         * JWT Bearer - <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code>
     *         </p>
     *         <p>
     *         * Token Exchange - <code>urn:ietf:params:oauth:grant-type:token-exchange</code>
     */
    public final String grantType() {
        return grantType;
    }

    /**
     * <p>
     * Used only when calling this API for the Authorization Code grant type. This short-term code is used to identify
     * this authorization request. The code is obtained through a redirect from IAM Identity Center to a redirect URI
     * persisted in the Authorization Code GrantOptions for the application.
     * </p>
     * 
     * @return Used only when calling this API for the Authorization Code grant type. This short-term code is used to
     *         identify this authorization request. The code is obtained through a redirect from IAM Identity Center to
     *         a redirect URI persisted in the Authorization Code GrantOptions for the application.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term
     * tokens, such as the access token, that might expire.
     * </p>
     * <p>
     * For more information about the features and limitations of the current IAM Identity Center OIDC implementation,
     * see <i>Considerations for Using this Guide</i> in the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API
     * Reference</a>.
     * </p>
     * 
     * @return Used only when calling this API for the Refresh Token grant type. This token is used to refresh
     *         short-term tokens, such as the access token, that might expire.</p>
     *         <p>
     *         For more information about the features and limitations of the current IAM Identity Center OIDC
     *         implementation, see <i>Considerations for Using this Guide</i> in the <a
     *         href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center
     *         OIDC API Reference</a>.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * <p>
     * Used only when calling this API for the JWT Bearer grant type. This value specifies the JSON Web Token (JWT)
     * issued by a trusted token issuer. To authorize a trusted token issuer, configure the JWT Bearer GrantOptions for
     * the application.
     * </p>
     * 
     * @return Used only when calling this API for the JWT Bearer grant type. This value specifies the JSON Web Token
     *         (JWT) issued by a trusted token issuer. To authorize a trusted token issuer, configure the JWT Bearer
     *         GrantOptions for the application.
     */
    public final String assertion() {
        return assertion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scope property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasScope() {
        return scope != null && !(scope instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes
     * that are granted. If the value is not specified, IAM Identity Center authorizes all scopes configured for the
     * application, including the following default scopes: <code>openid</code>, <code>aws</code>,
     * <code>sts:identity_context</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScope} method.
     * </p>
     * 
     * @return The list of scopes for which authorization is requested. The access token that is issued is limited to
     *         the scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes
     *         configured for the application, including the following default scopes: <code>openid</code>,
     *         <code>aws</code>, <code>sts:identity_context</code>.
     */
    public final List<String> scope() {
        return scope;
    }

    /**
     * <p>
     * Used only when calling this API for the Authorization Code grant type. This value specifies the location of the
     * client or application that has registered to receive the authorization code.
     * </p>
     * 
     * @return Used only when calling this API for the Authorization Code grant type. This value specifies the location
     *         of the client or application that has registered to receive the authorization code.
     */
    public final String redirectUri() {
        return redirectUri;
    }

    /**
     * <p>
     * Used only when calling this API for the Token Exchange grant type. This value specifies the subject of the
     * exchange. The value of the subject token must be an access token issued by IAM Identity Center to a different
     * client or application. The access token must have authorized scopes that indicate the requested application as a
     * target audience.
     * </p>
     * 
     * @return Used only when calling this API for the Token Exchange grant type. This value specifies the subject of
     *         the exchange. The value of the subject token must be an access token issued by IAM Identity Center to a
     *         different client or application. The access token must have authorized scopes that indicate the requested
     *         application as a target audience.
     */
    public final String subjectToken() {
        return subjectToken;
    }

    /**
     * <p>
     * Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that is
     * passed as the subject of the exchange. The following value is supported:
     * </p>
     * <p>
     * * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
     * </p>
     * 
     * @return Used only when calling this API for the Token Exchange grant type. This value specifies the type of token
     *         that is passed as the subject of the exchange. The following value is supported:</p>
     *         <p>
     *         * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
     */
    public final String subjectTokenType() {
        return subjectTokenType;
    }

    /**
     * <p>
     * Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that
     * the requester can receive. The following values are supported:
     * </p>
     * <p>
     * * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
     * </p>
     * <p>
     * * Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code>
     * </p>
     * 
     * @return Used only when calling this API for the Token Exchange grant type. This value specifies the type of token
     *         that the requester can receive. The following values are supported:</p>
     *         <p>
     *         * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
     *         </p>
     *         <p>
     *         * Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code>
     */
    public final String requestedTokenType() {
        return requestedTokenType;
    }

    /**
     * <p>
     * Used only when calling this API for the Authorization Code grant type. This value is generated by the client and
     * presented to validate the original code challenge value the client passed at authorization time.
     * </p>
     * 
     * @return Used only when calling this API for the Authorization Code grant type. This value is generated by the
     *         client and presented to validate the original code challenge value the client passed at authorization
     *         time.
     */
    public final String codeVerifier() {
        return codeVerifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(grantType());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(assertion());
        hashCode = 31 * hashCode + Objects.hashCode(hasScope() ? scope() : null);
        hashCode = 31 * hashCode + Objects.hashCode(redirectUri());
        hashCode = 31 * hashCode + Objects.hashCode(subjectToken());
        hashCode = 31 * hashCode + Objects.hashCode(subjectTokenType());
        hashCode = 31 * hashCode + Objects.hashCode(requestedTokenType());
        hashCode = 31 * hashCode + Objects.hashCode(codeVerifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenWithIamRequest)) {
            return false;
        }
        CreateTokenWithIamRequest other = (CreateTokenWithIamRequest) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(grantType(), other.grantType())
                && Objects.equals(code(), other.code()) && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(assertion(), other.assertion()) && hasScope() == other.hasScope()
                && Objects.equals(scope(), other.scope()) && Objects.equals(redirectUri(), other.redirectUri())
                && Objects.equals(subjectToken(), other.subjectToken())
                && Objects.equals(subjectTokenType(), other.subjectTokenType())
                && Objects.equals(requestedTokenType(), other.requestedTokenType())
                && Objects.equals(codeVerifier(), other.codeVerifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTokenWithIamRequest").add("ClientId", clientId()).add("GrantType", grantType())
                .add("Code", code()).add("RefreshToken", refreshToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Assertion", assertion() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Scope", hasScope() ? scope() : null).add("RedirectUri", redirectUri())
                .add("SubjectToken", subjectToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SubjectTokenType", subjectTokenType()).add("RequestedTokenType", requestedTokenType())
                .add("CodeVerifier", codeVerifier() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "grantType":
            return Optional.ofNullable(clazz.cast(grantType()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "refreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "assertion":
            return Optional.ofNullable(clazz.cast(assertion()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "redirectUri":
            return Optional.ofNullable(clazz.cast(redirectUri()));
        case "subjectToken":
            return Optional.ofNullable(clazz.cast(subjectToken()));
        case "subjectTokenType":
            return Optional.ofNullable(clazz.cast(subjectTokenType()));
        case "requestedTokenType":
            return Optional.ofNullable(clazz.cast(requestedTokenType()));
        case "codeVerifier":
            return Optional.ofNullable(clazz.cast(codeVerifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenWithIamRequest, T> g) {
        return obj -> g.apply((CreateTokenWithIamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoOidcRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTokenWithIamRequest> {
        /**
         * <p>
         * The unique identifier string for the client or application. This value is an application ARN that has OAuth
         * grants configured.
         * </p>
         * 
         * @param clientId
         *        The unique identifier string for the client or application. This value is an application ARN that has
         *        OAuth grants configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * Supports the following OAuth grant types: Authorization Code, Refresh Token, JWT Bearer, and Token Exchange.
         * Specify one of the following values, depending on the grant type that you want:
         * </p>
         * <p>
         * * Authorization Code - <code>authorization_code</code>
         * </p>
         * <p>
         * * Refresh Token - <code>refresh_token</code>
         * </p>
         * <p>
         * * JWT Bearer - <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code>
         * </p>
         * <p>
         * * Token Exchange - <code>urn:ietf:params:oauth:grant-type:token-exchange</code>
         * </p>
         * 
         * @param grantType
         *        Supports the following OAuth grant types: Authorization Code, Refresh Token, JWT Bearer, and Token
         *        Exchange. Specify one of the following values, depending on the grant type that you want:</p>
         *        <p>
         *        * Authorization Code - <code>authorization_code</code>
         *        </p>
         *        <p>
         *        * Refresh Token - <code>refresh_token</code>
         *        </p>
         *        <p>
         *        * JWT Bearer - <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code>
         *        </p>
         *        <p>
         *        * Token Exchange - <code>urn:ietf:params:oauth:grant-type:token-exchange</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantType(String grantType);

        /**
         * <p>
         * Used only when calling this API for the Authorization Code grant type. This short-term code is used to
         * identify this authorization request. The code is obtained through a redirect from IAM Identity Center to a
         * redirect URI persisted in the Authorization Code GrantOptions for the application.
         * </p>
         * 
         * @param code
         *        Used only when calling this API for the Authorization Code grant type. This short-term code is used to
         *        identify this authorization request. The code is obtained through a redirect from IAM Identity Center
         *        to a redirect URI persisted in the Authorization Code GrantOptions for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term
         * tokens, such as the access token, that might expire.
         * </p>
         * <p>
         * For more information about the features and limitations of the current IAM Identity Center OIDC
         * implementation, see <i>Considerations for Using this Guide</i> in the <a
         * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC
         * API Reference</a>.
         * </p>
         * 
         * @param refreshToken
         *        Used only when calling this API for the Refresh Token grant type. This token is used to refresh
         *        short-term tokens, such as the access token, that might expire.</p>
         *        <p>
         *        For more information about the features and limitations of the current IAM Identity Center OIDC
         *        implementation, see <i>Considerations for Using this Guide</i> in the <a
         *        href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity
         *        Center OIDC API Reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * Used only when calling this API for the JWT Bearer grant type. This value specifies the JSON Web Token (JWT)
         * issued by a trusted token issuer. To authorize a trusted token issuer, configure the JWT Bearer GrantOptions
         * for the application.
         * </p>
         * 
         * @param assertion
         *        Used only when calling this API for the JWT Bearer grant type. This value specifies the JSON Web Token
         *        (JWT) issued by a trusted token issuer. To authorize a trusted token issuer, configure the JWT Bearer
         *        GrantOptions for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assertion(String assertion);

        /**
         * <p>
         * The list of scopes for which authorization is requested. The access token that is issued is limited to the
         * scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes configured
         * for the application, including the following default scopes: <code>openid</code>, <code>aws</code>,
         * <code>sts:identity_context</code>.
         * </p>
         * 
         * @param scope
         *        The list of scopes for which authorization is requested. The access token that is issued is limited to
         *        the scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes
         *        configured for the application, including the following default scopes: <code>openid</code>,
         *        <code>aws</code>, <code>sts:identity_context</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Collection<String> scope);

        /**
         * <p>
         * The list of scopes for which authorization is requested. The access token that is issued is limited to the
         * scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes configured
         * for the application, including the following default scopes: <code>openid</code>, <code>aws</code>,
         * <code>sts:identity_context</code>.
         * </p>
         * 
         * @param scope
         *        The list of scopes for which authorization is requested. The access token that is issued is limited to
         *        the scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes
         *        configured for the application, including the following default scopes: <code>openid</code>,
         *        <code>aws</code>, <code>sts:identity_context</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String... scope);

        /**
         * <p>
         * Used only when calling this API for the Authorization Code grant type. This value specifies the location of
         * the client or application that has registered to receive the authorization code.
         * </p>
         * 
         * @param redirectUri
         *        Used only when calling this API for the Authorization Code grant type. This value specifies the
         *        location of the client or application that has registered to receive the authorization code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectUri(String redirectUri);

        /**
         * <p>
         * Used only when calling this API for the Token Exchange grant type. This value specifies the subject of the
         * exchange. The value of the subject token must be an access token issued by IAM Identity Center to a different
         * client or application. The access token must have authorized scopes that indicate the requested application
         * as a target audience.
         * </p>
         * 
         * @param subjectToken
         *        Used only when calling this API for the Token Exchange grant type. This value specifies the subject of
         *        the exchange. The value of the subject token must be an access token issued by IAM Identity Center to
         *        a different client or application. The access token must have authorized scopes that indicate the
         *        requested application as a target audience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectToken(String subjectToken);

        /**
         * <p>
         * Used only when calling this API for the Token Exchange grant type. This value specifies the type of token
         * that is passed as the subject of the exchange. The following value is supported:
         * </p>
         * <p>
         * * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
         * </p>
         * 
         * @param subjectTokenType
         *        Used only when calling this API for the Token Exchange grant type. This value specifies the type of
         *        token that is passed as the subject of the exchange. The following value is supported:</p>
         *        <p>
         *        * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectTokenType(String subjectTokenType);

        /**
         * <p>
         * Used only when calling this API for the Token Exchange grant type. This value specifies the type of token
         * that the requester can receive. The following values are supported:
         * </p>
         * <p>
         * * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
         * </p>
         * <p>
         * * Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code>
         * </p>
         * 
         * @param requestedTokenType
         *        Used only when calling this API for the Token Exchange grant type. This value specifies the type of
         *        token that the requester can receive. The following values are supported:</p>
         *        <p>
         *        * Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code>
         *        </p>
         *        <p>
         *        * Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedTokenType(String requestedTokenType);

        /**
         * <p>
         * Used only when calling this API for the Authorization Code grant type. This value is generated by the client
         * and presented to validate the original code challenge value the client passed at authorization time.
         * </p>
         * 
         * @param codeVerifier
         *        Used only when calling this API for the Authorization Code grant type. This value is generated by the
         *        client and presented to validate the original code challenge value the client passed at authorization
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeVerifier(String codeVerifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoOidcRequest.BuilderImpl implements Builder {
        private String clientId;

        private String grantType;

        private String code;

        private String refreshToken;

        private String assertion;

        private List<String> scope = DefaultSdkAutoConstructList.getInstance();

        private String redirectUri;

        private String subjectToken;

        private String subjectTokenType;

        private String requestedTokenType;

        private String codeVerifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenWithIamRequest model) {
            super(model);
            clientId(model.clientId);
            grantType(model.grantType);
            code(model.code);
            refreshToken(model.refreshToken);
            assertion(model.assertion);
            scope(model.scope);
            redirectUri(model.redirectUri);
            subjectToken(model.subjectToken);
            subjectTokenType(model.subjectTokenType);
            requestedTokenType(model.requestedTokenType);
            codeVerifier(model.codeVerifier);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getGrantType() {
            return grantType;
        }

        public final void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @Override
        public final Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getAssertion() {
            return assertion;
        }

        public final void setAssertion(String assertion) {
            this.assertion = assertion;
        }

        @Override
        public final Builder assertion(String assertion) {
            this.assertion = assertion;
            return this;
        }

        public final Collection<String> getScope() {
            if (scope instanceof SdkAutoConstructList) {
                return null;
            }
            return scope;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
        }

        @Override
        public final Builder scope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(String... scope) {
            scope(Arrays.asList(scope));
            return this;
        }

        public final String getRedirectUri() {
            return redirectUri;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public final String getSubjectToken() {
            return subjectToken;
        }

        public final void setSubjectToken(String subjectToken) {
            this.subjectToken = subjectToken;
        }

        @Override
        public final Builder subjectToken(String subjectToken) {
            this.subjectToken = subjectToken;
            return this;
        }

        public final String getSubjectTokenType() {
            return subjectTokenType;
        }

        public final void setSubjectTokenType(String subjectTokenType) {
            this.subjectTokenType = subjectTokenType;
        }

        @Override
        public final Builder subjectTokenType(String subjectTokenType) {
            this.subjectTokenType = subjectTokenType;
            return this;
        }

        public final String getRequestedTokenType() {
            return requestedTokenType;
        }

        public final void setRequestedTokenType(String requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
        }

        @Override
        public final Builder requestedTokenType(String requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
            return this;
        }

        public final String getCodeVerifier() {
            return codeVerifier;
        }

        public final void setCodeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
        }

        @Override
        public final Builder codeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTokenWithIamRequest build() {
            return new CreateTokenWithIamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
