/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterClientResponse
extends SsoOidcResponse
implements ToCopyableBuilder<Builder, RegisterClientResponse> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(RegisterClientResponse.getter(RegisterClientResponse::clientId)).setter(RegisterClientResponse.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientSecret").getter(RegisterClientResponse.getter(RegisterClientResponse::clientSecret)).setter(RegisterClientResponse.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()}).build();
    private static final SdkField<Long> CLIENT_ID_ISSUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("clientIdIssuedAt").getter(RegisterClientResponse.getter(RegisterClientResponse::clientIdIssuedAt)).setter(RegisterClientResponse.setter(Builder::clientIdIssuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIdIssuedAt").build()}).build();
    private static final SdkField<Long> CLIENT_SECRET_EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("clientSecretExpiresAt").getter(RegisterClientResponse.getter(RegisterClientResponse::clientSecretExpiresAt)).setter(RegisterClientResponse.setter(Builder::clientSecretExpiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecretExpiresAt").build()}).build();
    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationEndpoint").getter(RegisterClientResponse.getter(RegisterClientResponse::authorizationEndpoint)).setter(RegisterClientResponse.setter(Builder::authorizationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationEndpoint").build()}).build();
    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenEndpoint").getter(RegisterClientResponse.getter(RegisterClientResponse::tokenEndpoint)).setter(RegisterClientResponse.setter(Builder::tokenEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, CLIENT_ID_ISSUED_AT_FIELD, CLIENT_SECRET_EXPIRES_AT_FIELD, AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD));
    private final String clientId;
    private final String clientSecret;
    private final Long clientIdIssuedAt;
    private final Long clientSecretExpiresAt;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;

    private RegisterClientResponse(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.clientIdIssuedAt = builder.clientIdIssuedAt;
        this.clientSecretExpiresAt = builder.clientSecretExpiresAt;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String clientSecret() {
        return this.clientSecret;
    }

    public final Long clientIdIssuedAt() {
        return this.clientIdIssuedAt;
    }

    public final Long clientSecretExpiresAt() {
        return this.clientSecretExpiresAt;
    }

    public final String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public final String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIdIssuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecretExpiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterClientResponse)) {
            return false;
        }
        RegisterClientResponse other = (RegisterClientResponse)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientSecret(), other.clientSecret()) && Objects.equals(this.clientIdIssuedAt(), other.clientIdIssuedAt()) && Objects.equals(this.clientSecretExpiresAt(), other.clientSecretExpiresAt()) && Objects.equals(this.authorizationEndpoint(), other.authorizationEndpoint()) && Objects.equals(this.tokenEndpoint(), other.tokenEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterClientResponse").add("ClientId", (Object)this.clientId()).add("ClientSecret", (Object)this.clientSecret()).add("ClientIdIssuedAt", (Object)this.clientIdIssuedAt()).add("ClientSecretExpiresAt", (Object)this.clientSecretExpiresAt()).add("AuthorizationEndpoint", (Object)this.authorizationEndpoint()).add("TokenEndpoint", (Object)this.tokenEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "clientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
            case "clientIdIssuedAt": {
                return Optional.ofNullable(clazz.cast(this.clientIdIssuedAt()));
            }
            case "clientSecretExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.clientSecretExpiresAt()));
            }
            case "authorizationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.authorizationEndpoint()));
            }
            case "tokenEndpoint": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterClientResponse, T> g) {
        return obj -> g.apply((RegisterClientResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoOidcResponse.BuilderImpl
    implements Builder {
        private String clientId;
        private String clientSecret;
        private Long clientIdIssuedAt;
        private Long clientSecretExpiresAt;
        private String authorizationEndpoint;
        private String tokenEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterClientResponse model) {
            super(model);
            this.clientId(model.clientId);
            this.clientSecret(model.clientSecret);
            this.clientIdIssuedAt(model.clientIdIssuedAt);
            this.clientSecretExpiresAt(model.clientSecretExpiresAt);
            this.authorizationEndpoint(model.authorizationEndpoint);
            this.tokenEndpoint(model.tokenEndpoint);
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final Long getClientIdIssuedAt() {
            return this.clientIdIssuedAt;
        }

        public final void setClientIdIssuedAt(Long clientIdIssuedAt) {
            this.clientIdIssuedAt = clientIdIssuedAt;
        }

        @Override
        public final Builder clientIdIssuedAt(Long clientIdIssuedAt) {
            this.clientIdIssuedAt = clientIdIssuedAt;
            return this;
        }

        public final Long getClientSecretExpiresAt() {
            return this.clientSecretExpiresAt;
        }

        public final void setClientSecretExpiresAt(Long clientSecretExpiresAt) {
            this.clientSecretExpiresAt = clientSecretExpiresAt;
        }

        @Override
        public final Builder clientSecretExpiresAt(Long clientSecretExpiresAt) {
            this.clientSecretExpiresAt = clientSecretExpiresAt;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        @Override
        public RegisterClientResponse build() {
            return new RegisterClientResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoOidcResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterClientResponse> {
        public Builder clientId(String var1);

        public Builder clientSecret(String var1);

        public Builder clientIdIssuedAt(Long var1);

        public Builder clientSecretExpiresAt(Long var1);

        public Builder authorizationEndpoint(String var1);

        public Builder tokenEndpoint(String var1);
    }
}

