/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTokenResponse extends SsoOidcResponse implements
        ToCopyableBuilder<CreateTokenResponse.Builder, CreateTokenResponse> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(CreateTokenResponse::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<String> TOKEN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenType").getter(getter(CreateTokenResponse::tokenType)).setter(setter(Builder::tokenType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenType").build()).build();

    private static final SdkField<Integer> EXPIRES_IN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("expiresIn").getter(getter(CreateTokenResponse::expiresIn)).setter(setter(Builder::expiresIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresIn").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("refreshToken").getter(getter(CreateTokenResponse::refreshToken)).setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()).build();

    private static final SdkField<String> ID_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idToken").getter(getter(CreateTokenResponse::idToken)).setter(setter(Builder::idToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            TOKEN_TYPE_FIELD, EXPIRES_IN_FIELD, REFRESH_TOKEN_FIELD, ID_TOKEN_FIELD));

    private final String accessToken;

    private final String tokenType;

    private final Integer expiresIn;

    private final String refreshToken;

    private final String idToken;

    private CreateTokenResponse(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.tokenType = builder.tokenType;
        this.expiresIn = builder.expiresIn;
        this.refreshToken = builder.refreshToken;
        this.idToken = builder.idToken;
    }

    /**
     * <p>
     * An opaque token to access IAM Identity Center resources assigned to a user.
     * </p>
     * 
     * @return An opaque token to access IAM Identity Center resources assigned to a user.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * Used to notify the client that the returned token is an access token. The supported type is
     * <code>BearerToken</code>.
     * </p>
     * 
     * @return Used to notify the client that the returned token is an access token. The supported type is
     *         <code>BearerToken</code>.
     */
    public final String tokenType() {
        return tokenType;
    }

    /**
     * <p>
     * Indicates the time in seconds when an access token will expire.
     * </p>
     * 
     * @return Indicates the time in seconds when an access token will expire.
     */
    public final Integer expiresIn() {
        return expiresIn;
    }

    /**
     * <p>
     * Currently, <code>refreshToken</code> is not yet implemented and is not supported. For more information about the
     * features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using
     * this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM
     * Identity Center OIDC API Reference</a>.
     * </p>
     * <p>
     * A token that, if present, can be used to refresh a previously issued access token that might have expired.
     * </p>
     * 
     * @return Currently, <code>refreshToken</code> is not yet implemented and is not supported. For more information
     *         about the features and limitations of the current IAM Identity Center OIDC implementation, see
     *         <i>Considerations for Using this Guide</i> in the <a
     *         href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center
     *         OIDC API Reference</a>.</p>
     *         <p>
     *         A token that, if present, can be used to refresh a previously issued access token that might have
     *         expired.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * <p>
     * Currently, <code>idToken</code> is not yet implemented and is not supported. For more information about the
     * features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using
     * this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM
     * Identity Center OIDC API Reference</a>.
     * </p>
     * <p>
     * The identifier of the user that associated with the access token, if present.
     * </p>
     * 
     * @return Currently, <code>idToken</code> is not yet implemented and is not supported. For more information about
     *         the features and limitations of the current IAM Identity Center OIDC implementation, see
     *         <i>Considerations for Using this Guide</i> in the <a
     *         href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center
     *         OIDC API Reference</a>.</p>
     *         <p>
     *         The identifier of the user that associated with the access token, if present.
     */
    public final String idToken() {
        return idToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(tokenType());
        hashCode = 31 * hashCode + Objects.hashCode(expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(idToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenResponse)) {
            return false;
        }
        CreateTokenResponse other = (CreateTokenResponse) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(tokenType(), other.tokenType())
                && Objects.equals(expiresIn(), other.expiresIn()) && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(idToken(), other.idToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTokenResponse").add("AccessToken", accessToken()).add("TokenType", tokenType())
                .add("ExpiresIn", expiresIn()).add("RefreshToken", refreshToken()).add("IdToken", idToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "tokenType":
            return Optional.ofNullable(clazz.cast(tokenType()));
        case "expiresIn":
            return Optional.ofNullable(clazz.cast(expiresIn()));
        case "refreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "idToken":
            return Optional.ofNullable(clazz.cast(idToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenResponse, T> g) {
        return obj -> g.apply((CreateTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoOidcResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTokenResponse> {
        /**
         * <p>
         * An opaque token to access IAM Identity Center resources assigned to a user.
         * </p>
         * 
         * @param accessToken
         *        An opaque token to access IAM Identity Center resources assigned to a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * Used to notify the client that the returned token is an access token. The supported type is
         * <code>BearerToken</code>.
         * </p>
         * 
         * @param tokenType
         *        Used to notify the client that the returned token is an access token. The supported type is
         *        <code>BearerToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenType(String tokenType);

        /**
         * <p>
         * Indicates the time in seconds when an access token will expire.
         * </p>
         * 
         * @param expiresIn
         *        Indicates the time in seconds when an access token will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresIn(Integer expiresIn);

        /**
         * <p>
         * Currently, <code>refreshToken</code> is not yet implemented and is not supported. For more information about
         * the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations
         * for Using this Guide</i> in the <a
         * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC
         * API Reference</a>.
         * </p>
         * <p>
         * A token that, if present, can be used to refresh a previously issued access token that might have expired.
         * </p>
         * 
         * @param refreshToken
         *        Currently, <code>refreshToken</code> is not yet implemented and is not supported. For more information
         *        about the features and limitations of the current IAM Identity Center OIDC implementation, see
         *        <i>Considerations for Using this Guide</i> in the <a
         *        href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity
         *        Center OIDC API Reference</a>.</p>
         *        <p>
         *        A token that, if present, can be used to refresh a previously issued access token that might have
         *        expired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * Currently, <code>idToken</code> is not yet implemented and is not supported. For more information about the
         * features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for
         * Using this Guide</i> in the <a
         * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC
         * API Reference</a>.
         * </p>
         * <p>
         * The identifier of the user that associated with the access token, if present.
         * </p>
         * 
         * @param idToken
         *        Currently, <code>idToken</code> is not yet implemented and is not supported. For more information
         *        about the features and limitations of the current IAM Identity Center OIDC implementation, see
         *        <i>Considerations for Using this Guide</i> in the <a
         *        href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity
         *        Center OIDC API Reference</a>.</p>
         *        <p>
         *        The identifier of the user that associated with the access token, if present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idToken(String idToken);
    }

    static final class BuilderImpl extends SsoOidcResponse.BuilderImpl implements Builder {
        private String accessToken;

        private String tokenType;

        private Integer expiresIn;

        private String refreshToken;

        private String idToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenResponse model) {
            super(model);
            accessToken(model.accessToken);
            tokenType(model.tokenType);
            expiresIn(model.expiresIn);
            refreshToken(model.refreshToken);
            idToken(model.idToken);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getTokenType() {
            return tokenType;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public final Integer getExpiresIn() {
            return expiresIn;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getIdToken() {
            return idToken;
        }

        public final void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        @Override
        public final Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        @Override
        public CreateTokenResponse build() {
            return new CreateTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
