/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssooidc.model.ScopesCopier;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterClientRequest
extends SsoOidcRequest
implements ToCopyableBuilder<Builder, RegisterClientRequest> {
    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientName").getter(RegisterClientRequest.getter(RegisterClientRequest::clientName)).setter(RegisterClientRequest.setter(Builder::clientName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientName").build()}).build();
    private static final SdkField<String> CLIENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientType").getter(RegisterClientRequest.getter(RegisterClientRequest::clientType)).setter(RegisterClientRequest.setter(Builder::clientType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientType").build()}).build();
    private static final SdkField<List<String>> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scopes").getter(RegisterClientRequest.getter(RegisterClientRequest::scopes)).setter(RegisterClientRequest.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_NAME_FIELD, CLIENT_TYPE_FIELD, SCOPES_FIELD));
    private final String clientName;
    private final String clientType;
    private final List<String> scopes;

    private RegisterClientRequest(BuilderImpl builder) {
        super(builder);
        this.clientName = builder.clientName;
        this.clientType = builder.clientType;
        this.scopes = builder.scopes;
    }

    public String clientName() {
        return this.clientName;
    }

    public String clientType() {
        return this.clientType;
    }

    public boolean hasScopes() {
        return this.scopes != null && !(this.scopes instanceof SdkAutoConstructList);
    }

    public List<String> scopes() {
        return this.scopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScopes() ? this.scopes() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterClientRequest)) {
            return false;
        }
        RegisterClientRequest other = (RegisterClientRequest)((Object)obj);
        return Objects.equals(this.clientName(), other.clientName()) && Objects.equals(this.clientType(), other.clientType()) && this.hasScopes() == other.hasScopes() && Objects.equals(this.scopes(), other.scopes());
    }

    public String toString() {
        return ToString.builder((String)"RegisterClientRequest").add("ClientName", (Object)this.clientName()).add("ClientType", (Object)this.clientType()).add("Scopes", this.hasScopes() ? this.scopes() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientName": {
                return Optional.ofNullable(clazz.cast(this.clientName()));
            }
            case "clientType": {
                return Optional.ofNullable(clazz.cast(this.clientType()));
            }
            case "scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterClientRequest, T> g) {
        return obj -> g.apply((RegisterClientRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoOidcRequest.BuilderImpl
    implements Builder {
        private String clientName;
        private String clientType;
        private List<String> scopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterClientRequest model) {
            super(model);
            this.clientName(model.clientName);
            this.clientType(model.clientType);
            this.scopes(model.scopes);
        }

        public final String getClientName() {
            return this.clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public final String getClientType() {
            return this.clientType;
        }

        @Override
        public final Builder clientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        public final void setClientType(String clientType) {
            this.clientType = clientType;
        }

        public final Collection<String> getScopes() {
            if (this.scopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scopes;
        }

        @Override
        public final Builder scopes(Collection<String> scopes) {
            this.scopes = ScopesCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(String ... scopes) {
            this.scopes(Arrays.asList(scopes));
            return this;
        }

        public final void setScopes(Collection<String> scopes) {
            this.scopes = ScopesCopier.copy(scopes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterClientRequest build() {
            return new RegisterClientRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoOidcRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterClientRequest> {
        public Builder clientName(String var1);

        public Builder clientType(String var1);

        public Builder scopes(Collection<String> var1);

        public Builder scopes(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

