/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the client is making the request too frequently and is more than the service can handle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlowDownException extends SsoOidcException implements
        ToCopyableBuilder<SlowDownException.Builder, SlowDownException> {
    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SlowDownException::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> ERROR_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SlowDownException::error_description)).setter(setter(Builder::error_description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error_description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD,
            ERROR_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String error;

    private final String error_description;

    private SlowDownException(BuilderImpl builder) {
        super(builder);
        this.error = builder.error;
        this.error_description = builder.error_description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Error property for this object.
     * 
     * @return The value of the Error property for this object.
     */
    public String error() {
        return error;
    }

    /**
     * Returns the value of the Error_description property for this object.
     * 
     * @return The value of the Error_description property for this object.
     */
    public String error_description() {
        return error_description;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlowDownException, T> g) {
        return obj -> g.apply((SlowDownException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlowDownException>, SsoOidcException.Builder {
        /**
         * Sets the value of the Error property for this object.
         *
         * @param error
         *        The new value for the Error property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * Sets the value of the Error_description property for this object.
         *
         * @param error_description
         *        The new value for the Error_description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error_description(String error_description);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends SsoOidcException.BuilderImpl implements Builder {
        private String error;

        private String error_description;

        private BuilderImpl() {
        }

        private BuilderImpl(SlowDownException model) {
            super(model);
            error(model.error);
            error_description(model.error_description);
        }

        public final String getError() {
            return error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final String getError_description() {
            return error_description;
        }

        @Override
        public final Builder error_description(String error_description) {
            this.error_description = error_description;
            return this;
        }

        public final void setError_description(String error_description) {
            this.error_description = error_description;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public SlowDownException build() {
            return new SlowDownException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
