/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationRequest extends SsoAdminRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(UpdateApplicationRequest::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<UpdateApplicationPortalOptions> PORTAL_OPTIONS_FIELD = SdkField
            .<UpdateApplicationPortalOptions> builder(MarshallingType.SDK_POJO).memberName("PortalOptions")
            .getter(getter(UpdateApplicationRequest::portalOptions)).setter(setter(Builder::portalOptions))
            .constructor(UpdateApplicationPortalOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortalOptions").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateApplicationRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, PORTAL_OPTIONS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationArn;

    private final String description;

    private final String name;

    private final UpdateApplicationPortalOptions portalOptions;

    private final String status;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.description = builder.description;
        this.name = builder.name;
        this.portalOptions = builder.portalOptions;
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies the ARN of the application. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services
     * Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return Specifies the ARN of the application. For more information about ARNs, see <a
     *         href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web
     *         Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The description of the .
     * </p>
     * 
     * @return The description of the .
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the updated name for the application.
     * </p>
     * 
     * @return Specifies the updated name for the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A structure that describes the options for the portal associated with an application.
     * </p>
     * 
     * @return A structure that describes the options for the portal associated with an application.
     */
    public final UpdateApplicationPortalOptions portalOptions() {
        return portalOptions;
    }

    /**
     * <p>
     * Specifies whether the application is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies whether the application is enabled or disabled.
     * @see ApplicationStatus
     */
    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies whether the application is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies whether the application is enabled or disabled.
     * @see ApplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(portalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(applicationArn(), other.applicationArn()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(portalOptions(), other.portalOptions())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationRequest").add("ApplicationArn", applicationArn())
                .add("Description", description()).add("Name", name()).add("PortalOptions", portalOptions())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PortalOptions":
            return Optional.ofNullable(clazz.cast(portalOptions()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("PortalOptions", PORTAL_OPTIONS_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * Specifies the ARN of the application. For more information about ARNs, see <a
         * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services
         * Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param applicationArn
         *        Specifies the ARN of the application. For more information about ARNs, see <a
         *        href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web
         *        Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The description of the .
         * </p>
         * 
         * @param description
         *        The description of the .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the updated name for the application.
         * </p>
         * 
         * @param name
         *        Specifies the updated name for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure that describes the options for the portal associated with an application.
         * </p>
         * 
         * @param portalOptions
         *        A structure that describes the options for the portal associated with an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalOptions(UpdateApplicationPortalOptions portalOptions);

        /**
         * <p>
         * A structure that describes the options for the portal associated with an application.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateApplicationPortalOptions.Builder}
         * avoiding the need to create one manually via {@link UpdateApplicationPortalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateApplicationPortalOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #portalOptions(UpdateApplicationPortalOptions)}.
         * 
         * @param portalOptions
         *        a consumer that will call methods on {@link UpdateApplicationPortalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portalOptions(UpdateApplicationPortalOptions)
         */
        default Builder portalOptions(Consumer<UpdateApplicationPortalOptions.Builder> portalOptions) {
            return portalOptions(UpdateApplicationPortalOptions.builder().applyMutation(portalOptions).build());
        }

        /**
         * <p>
         * Specifies whether the application is enabled or disabled.
         * </p>
         * 
         * @param status
         *        Specifies whether the application is enabled or disabled.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies whether the application is enabled or disabled.
         * </p>
         * 
         * @param status
         *        Specifies whether the application is enabled or disabled.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(ApplicationStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String applicationArn;

        private String description;

        private String name;

        private UpdateApplicationPortalOptions portalOptions;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            applicationArn(model.applicationArn);
            description(model.description);
            name(model.name);
            portalOptions(model.portalOptions);
            status(model.status);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final UpdateApplicationPortalOptions.Builder getPortalOptions() {
            return portalOptions != null ? portalOptions.toBuilder() : null;
        }

        public final void setPortalOptions(UpdateApplicationPortalOptions.BuilderImpl portalOptions) {
            this.portalOptions = portalOptions != null ? portalOptions.build() : null;
        }

        @Override
        public final Builder portalOptions(UpdateApplicationPortalOptions portalOptions) {
            this.portalOptions = portalOptions;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
