/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutApplicationAssignmentConfigurationRequest extends SsoAdminRequest implements
        ToCopyableBuilder<PutApplicationAssignmentConfigurationRequest.Builder, PutApplicationAssignmentConfigurationRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(PutApplicationAssignmentConfigurationRequest::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<Boolean> ASSIGNMENT_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssignmentRequired").getter(getter(PutApplicationAssignmentConfigurationRequest::assignmentRequired))
            .setter(setter(Builder::assignmentRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentRequired").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            ASSIGNMENT_REQUIRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationArn;

    private final Boolean assignmentRequired;

    private PutApplicationAssignmentConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.assignmentRequired = builder.assignmentRequired;
    }

    /**
     * <p>
     * Specifies the ARN of the application. For more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services
     * Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return Specifies the ARN of the application. For more information about ARNs, see <a
     *         href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web
     *         Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * If <code>AssignmentsRequired</code> is <code>true</code> (default value), users don’t have access to the
     * application unless an assignment is created using the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
     * >CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application.
     * </p>
     * 
     * @return If <code>AssignmentsRequired</code> is <code>true</code> (default value), users don’t have access to the
     *         application unless an assignment is created using the <a href=
     *         "https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
     *         >CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application.
     */
    public final Boolean assignmentRequired() {
        return assignmentRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentRequired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApplicationAssignmentConfigurationRequest)) {
            return false;
        }
        PutApplicationAssignmentConfigurationRequest other = (PutApplicationAssignmentConfigurationRequest) obj;
        return Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(assignmentRequired(), other.assignmentRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutApplicationAssignmentConfigurationRequest").add("ApplicationArn", applicationArn())
                .add("AssignmentRequired", assignmentRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "AssignmentRequired":
            return Optional.ofNullable(clazz.cast(assignmentRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("AssignmentRequired", ASSIGNMENT_REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutApplicationAssignmentConfigurationRequest, T> g) {
        return obj -> g.apply((PutApplicationAssignmentConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutApplicationAssignmentConfigurationRequest> {
        /**
         * <p>
         * Specifies the ARN of the application. For more information about ARNs, see <a
         * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services
         * Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param applicationArn
         *        Specifies the ARN of the application. For more information about ARNs, see <a
         *        href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web
         *        Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * If <code>AssignmentsRequired</code> is <code>true</code> (default value), users don’t have access to the
         * application unless an assignment is created using the <a
         * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
         * >CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application.
         * </p>
         * 
         * @param assignmentRequired
         *        If <code>AssignmentsRequired</code> is <code>true</code> (default value), users don’t have access to
         *        the application unless an assignment is created using the <a href=
         *        "https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html"
         *        >CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentRequired(Boolean assignmentRequired);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String applicationArn;

        private Boolean assignmentRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(PutApplicationAssignmentConfigurationRequest model) {
            super(model);
            applicationArn(model.applicationArn);
            assignmentRequired(model.assignmentRequired);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final Boolean getAssignmentRequired() {
            return assignmentRequired;
        }

        public final void setAssignmentRequired(Boolean assignmentRequired) {
            this.assignmentRequired = assignmentRequired;
        }

        @Override
        public final Builder assignmentRequired(Boolean assignmentRequired) {
            this.assignmentRequired = assignmentRequired;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutApplicationAssignmentConfigurationRequest build() {
            return new PutApplicationAssignmentConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
