/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPermissionSetsProvisionedToAccountRequest extends SsoAdminRequest implements
        ToCopyableBuilder<ListPermissionSetsProvisionedToAccountRequest.Builder, ListPermissionSetsProvisionedToAccountRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ListPermissionSetsProvisionedToAccountRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(ListPermissionSetsProvisionedToAccountRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPermissionSetsProvisionedToAccountRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPermissionSetsProvisionedToAccountRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningStatus")
            .getter(getter(ListPermissionSetsProvisionedToAccountRequest::provisioningStatusAsString))
            .setter(setter(Builder::provisioningStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            INSTANCE_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PROVISIONING_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String instanceArn;

    private final Integer maxResults;

    private final String nextToken;

    private final String provisioningStatus;

    private ListPermissionSetsProvisionedToAccountRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.instanceArn = builder.instanceArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.provisioningStatus = builder.provisioningStatus;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account from which to list the assignments.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account from which to list the assignments.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ARN of the IAM Identity Center instance under which the operation will be executed. For more information
     * about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon
     * Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The ARN of the IAM Identity Center instance under which the operation will be executed. For more
     *         information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General
     *         Reference</i>.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The maximum number of results to display for the assignment.
     * </p>
     * 
     * @return The maximum number of results to display for the assignment.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make
     * subsequent calls.
     * </p>
     * 
     * @return The pagination token for the list API. Initially the value is null. Use the output of previous API calls
     *         to make subsequent calls.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The status object for the permission set provisioning operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link ProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The status object for the permission set provisioning operation.
     * @see ProvisioningStatus
     */
    public final ProvisioningStatus provisioningStatus() {
        return ProvisioningStatus.fromValue(provisioningStatus);
    }

    /**
     * <p>
     * The status object for the permission set provisioning operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link ProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The status object for the permission set provisioning operation.
     * @see ProvisioningStatus
     */
    public final String provisioningStatusAsString() {
        return provisioningStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionSetsProvisionedToAccountRequest)) {
            return false;
        }
        ListPermissionSetsProvisionedToAccountRequest other = (ListPermissionSetsProvisionedToAccountRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(provisioningStatusAsString(), other.provisioningStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPermissionSetsProvisionedToAccountRequest").add("AccountId", accountId())
                .add("InstanceArn", instanceArn()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ProvisioningStatus", provisioningStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ProvisioningStatus":
            return Optional.ofNullable(clazz.cast(provisioningStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ProvisioningStatus", PROVISIONING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionSetsProvisionedToAccountRequest, T> g) {
        return obj -> g.apply((ListPermissionSetsProvisionedToAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPermissionSetsProvisionedToAccountRequest> {
        /**
         * <p>
         * The identifier of the Amazon Web Services account from which to list the assignments.
         * </p>
         * 
         * @param accountId
         *        The identifier of the Amazon Web Services account from which to list the assignments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ARN of the IAM Identity Center instance under which the operation will be executed. For more information
         * about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
         * Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the IAM Identity Center instance under which the operation will be executed. For more
         *        information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The maximum number of results to display for the assignment.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to display for the assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to
         * make subsequent calls.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the list API. Initially the value is null. Use the output of previous API
         *        calls to make subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The status object for the permission set provisioning operation.
         * </p>
         * 
         * @param provisioningStatus
         *        The status object for the permission set provisioning operation.
         * @see ProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningStatus
         */
        Builder provisioningStatus(String provisioningStatus);

        /**
         * <p>
         * The status object for the permission set provisioning operation.
         * </p>
         * 
         * @param provisioningStatus
         *        The status object for the permission set provisioning operation.
         * @see ProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningStatus
         */
        Builder provisioningStatus(ProvisioningStatus provisioningStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String accountId;

        private String instanceArn;

        private Integer maxResults;

        private String nextToken;

        private String provisioningStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionSetsProvisionedToAccountRequest model) {
            super(model);
            accountId(model.accountId);
            instanceArn(model.instanceArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            provisioningStatus(model.provisioningStatus);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProvisioningStatus() {
            return provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(ProvisioningStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPermissionSetsProvisionedToAccountRequest build() {
            return new ListPermissionSetsProvisionedToAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
