/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationAccessScopesResponse extends SsoAdminResponse implements
        ToCopyableBuilder<ListApplicationAccessScopesResponse.Builder, ListApplicationAccessScopesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationAccessScopesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ScopeDetails>> SCOPES_FIELD = SdkField
            .<List<ScopeDetails>> builder(MarshallingType.LIST)
            .memberName("Scopes")
            .getter(getter(ListApplicationAccessScopesResponse::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScopeDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScopeDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_TOKEN_FIELD, SCOPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ScopeDetails> scopes;

    private ListApplicationAccessScopesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scopes = builder.scopes;
    }

    /**
     * <p>
     * If present, this value indicates that more output is available than is included in the current response. Use this
     * value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part
     * of the output. You should repeat this until the <code>NextToken</code> response element comes back as
     * <code>null</code>. This indicates that this is the last page of results.
     * </p>
     * 
     * @return If present, this value indicates that more output is available than is included in the current response.
     *         Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to
     *         get the next part of the output. You should repeat this until the <code>NextToken</code> response element
     *         comes back as <code>null</code>. This indicates that this is the last page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scopes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array list of access scopes and their authorized targets that are associated with the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScopes} method.
     * </p>
     * 
     * @return An array list of access scopes and their authorized targets that are associated with the application.
     */
    public final List<ScopeDetails> scopes() {
        return scopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasScopes() ? scopes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationAccessScopesResponse)) {
            return false;
        }
        ListApplicationAccessScopesResponse other = (ListApplicationAccessScopesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasScopes() == other.hasScopes()
                && Objects.equals(scopes(), other.scopes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationAccessScopesResponse").add("NextToken", nextToken())
                .add("Scopes", hasScopes() ? scopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Scopes", SCOPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationAccessScopesResponse, T> g) {
        return obj -> g.apply((ListApplicationAccessScopesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationAccessScopesResponse> {
        /**
         * <p>
         * If present, this value indicates that more output is available than is included in the current response. Use
         * this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         * next part of the output. You should repeat this until the <code>NextToken</code> response element comes back
         * as <code>null</code>. This indicates that this is the last page of results.
         * </p>
         * 
         * @param nextToken
         *        If present, this value indicates that more output is available than is included in the current
         *        response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the
         *        operation to get the next part of the output. You should repeat this until the <code>NextToken</code>
         *        response element comes back as <code>null</code>. This indicates that this is the last page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array list of access scopes and their authorized targets that are associated with the application.
         * </p>
         * 
         * @param scopes
         *        An array list of access scopes and their authorized targets that are associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Collection<ScopeDetails> scopes);

        /**
         * <p>
         * An array list of access scopes and their authorized targets that are associated with the application.
         * </p>
         * 
         * @param scopes
         *        An array list of access scopes and their authorized targets that are associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(ScopeDetails... scopes);

        /**
         * <p>
         * An array list of access scopes and their authorized targets that are associated with the application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssoadmin.model.ScopeDetails.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssoadmin.model.ScopeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssoadmin.model.ScopeDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #scopes(List<ScopeDetails>)}.
         * 
         * @param scopes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssoadmin.model.ScopeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scopes(java.util.Collection<ScopeDetails>)
         */
        Builder scopes(Consumer<ScopeDetails.Builder>... scopes);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ScopeDetails> scopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationAccessScopesResponse model) {
            super(model);
            nextToken(model.nextToken);
            scopes(model.scopes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScopeDetails.Builder> getScopes() {
            List<ScopeDetails.Builder> result = ScopesCopier.copyToBuilder(this.scopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScopes(Collection<ScopeDetails.BuilderImpl> scopes) {
            this.scopes = ScopesCopier.copyFromBuilder(scopes);
        }

        @Override
        public final Builder scopes(Collection<ScopeDetails> scopes) {
            this.scopes = ScopesCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(ScopeDetails... scopes) {
            scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Consumer<ScopeDetails.Builder>... scopes) {
            scopes(Stream.of(scopes).map(c -> ScopeDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListApplicationAccessScopesResponse build() {
            return new ListApplicationAccessScopesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
