/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Grant union represents the set of possible configuration options for the selected grant type. Exactly one member
 * of the union must be specified, and must match the grant type selected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Grant implements SdkPojo, Serializable, ToCopyableBuilder<Grant.Builder, Grant> {
    private static final SdkField<AuthorizationCodeGrant> AUTHORIZATION_CODE_FIELD = SdkField
            .<AuthorizationCodeGrant> builder(MarshallingType.SDK_POJO).memberName("AuthorizationCode")
            .getter(getter(Grant::authorizationCode)).setter(setter(Builder::authorizationCode))
            .constructor(AuthorizationCodeGrant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCode").build()).build();

    private static final SdkField<JwtBearerGrant> JWT_BEARER_FIELD = SdkField.<JwtBearerGrant> builder(MarshallingType.SDK_POJO)
            .memberName("JwtBearer").getter(getter(Grant::jwtBearer)).setter(setter(Builder::jwtBearer))
            .constructor(JwtBearerGrant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwtBearer").build()).build();

    private static final SdkField<RefreshTokenGrant> REFRESH_TOKEN_FIELD = SdkField
            .<RefreshTokenGrant> builder(MarshallingType.SDK_POJO).memberName("RefreshToken").getter(getter(Grant::refreshToken))
            .setter(setter(Builder::refreshToken)).constructor(RefreshTokenGrant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshToken").build()).build();

    private static final SdkField<TokenExchangeGrant> TOKEN_EXCHANGE_FIELD = SdkField
            .<TokenExchangeGrant> builder(MarshallingType.SDK_POJO).memberName("TokenExchange")
            .getter(getter(Grant::tokenExchange)).setter(setter(Builder::tokenExchange)).constructor(TokenExchangeGrant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenExchange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_CODE_FIELD,
            JWT_BEARER_FIELD, REFRESH_TOKEN_FIELD, TOKEN_EXCHANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AuthorizationCodeGrant authorizationCode;

    private final JwtBearerGrant jwtBearer;

    private final RefreshTokenGrant refreshToken;

    private final TokenExchangeGrant tokenExchange;

    private final Type type;

    private Grant(BuilderImpl builder) {
        this.authorizationCode = builder.authorizationCode;
        this.jwtBearer = builder.jwtBearer;
        this.refreshToken = builder.refreshToken;
        this.tokenExchange = builder.tokenExchange;
        this.type = builder.type;
    }

    /**
     * <p>
     * Configuration options for the <code>authorization_code</code> grant type.
     * </p>
     * 
     * @return Configuration options for the <code>authorization_code</code> grant type.
     */
    public final AuthorizationCodeGrant authorizationCode() {
        return authorizationCode;
    }

    /**
     * <p>
     * Configuration options for the <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code> grant type.
     * </p>
     * 
     * @return Configuration options for the <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code> grant type.
     */
    public final JwtBearerGrant jwtBearer() {
        return jwtBearer;
    }

    /**
     * <p>
     * Configuration options for the <code>refresh_token</code> grant type.
     * </p>
     * 
     * @return Configuration options for the <code>refresh_token</code> grant type.
     */
    public final RefreshTokenGrant refreshToken() {
        return refreshToken;
    }

    /**
     * <p>
     * Configuration options for the <code>urn:ietf:params:oauth:grant-type:token-exchange</code> grant type.
     * </p>
     * 
     * @return Configuration options for the <code>urn:ietf:params:oauth:grant-type:token-exchange</code> grant type.
     */
    public final TokenExchangeGrant tokenExchange() {
        return tokenExchange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationCode());
        hashCode = 31 * hashCode + Objects.hashCode(jwtBearer());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(tokenExchange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grant)) {
            return false;
        }
        Grant other = (Grant) obj;
        return Objects.equals(authorizationCode(), other.authorizationCode()) && Objects.equals(jwtBearer(), other.jwtBearer())
                && Objects.equals(refreshToken(), other.refreshToken()) && Objects.equals(tokenExchange(), other.tokenExchange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Grant").add("AuthorizationCode", authorizationCode()).add("JwtBearer", jwtBearer())
                .add("RefreshToken", refreshToken()).add("TokenExchange", tokenExchange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizationCode":
            return Optional.ofNullable(clazz.cast(authorizationCode()));
        case "JwtBearer":
            return Optional.ofNullable(clazz.cast(jwtBearer()));
        case "RefreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "TokenExchange":
            return Optional.ofNullable(clazz.cast(tokenExchange()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #authorizationCode()} initialized to the given value.
     *
     * <p>
     * Configuration options for the <code>authorization_code</code> grant type.
     * </p>
     * 
     * @param authorizationCode
     *        Configuration options for the <code>authorization_code</code> grant type.
     */
    public static Grant fromAuthorizationCode(AuthorizationCodeGrant authorizationCode) {
        return builder().authorizationCode(authorizationCode).build();
    }

    /**
     * Create an instance of this class with {@link #authorizationCode()} initialized to the given value.
     *
     * <p>
     * Configuration options for the <code>authorization_code</code> grant type.
     * </p>
     * 
     * @param authorizationCode
     *        Configuration options for the <code>authorization_code</code> grant type.
     */
    public static Grant fromAuthorizationCode(Consumer<AuthorizationCodeGrant.Builder> authorizationCode) {
        AuthorizationCodeGrant.Builder builder = AuthorizationCodeGrant.builder();
        authorizationCode.accept(builder);
        return fromAuthorizationCode(builder.build());
    }

    /**
     * Create an instance of this class with {@link #jwtBearer()} initialized to the given value.
     *
     * <p>
     * Configuration options for the <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code> grant type.
     * </p>
     * 
     * @param jwtBearer
     *        Configuration options for the <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code> grant type.
     */
    public static Grant fromJwtBearer(JwtBearerGrant jwtBearer) {
        return builder().jwtBearer(jwtBearer).build();
    }

    /**
     * Create an instance of this class with {@link #jwtBearer()} initialized to the given value.
     *
     * <p>
     * Configuration options for the <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code> grant type.
     * </p>
     * 
     * @param jwtBearer
     *        Configuration options for the <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code> grant type.
     */
    public static Grant fromJwtBearer(Consumer<JwtBearerGrant.Builder> jwtBearer) {
        JwtBearerGrant.Builder builder = JwtBearerGrant.builder();
        jwtBearer.accept(builder);
        return fromJwtBearer(builder.build());
    }

    /**
     * Create an instance of this class with {@link #refreshToken()} initialized to the given value.
     *
     * <p>
     * Configuration options for the <code>refresh_token</code> grant type.
     * </p>
     * 
     * @param refreshToken
     *        Configuration options for the <code>refresh_token</code> grant type.
     */
    public static Grant fromRefreshToken(RefreshTokenGrant refreshToken) {
        return builder().refreshToken(refreshToken).build();
    }

    /**
     * Create an instance of this class with {@link #refreshToken()} initialized to the given value.
     *
     * <p>
     * Configuration options for the <code>refresh_token</code> grant type.
     * </p>
     * 
     * @param refreshToken
     *        Configuration options for the <code>refresh_token</code> grant type.
     */
    public static Grant fromRefreshToken(Consumer<RefreshTokenGrant.Builder> refreshToken) {
        RefreshTokenGrant.Builder builder = RefreshTokenGrant.builder();
        refreshToken.accept(builder);
        return fromRefreshToken(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tokenExchange()} initialized to the given value.
     *
     * <p>
     * Configuration options for the <code>urn:ietf:params:oauth:grant-type:token-exchange</code> grant type.
     * </p>
     * 
     * @param tokenExchange
     *        Configuration options for the <code>urn:ietf:params:oauth:grant-type:token-exchange</code> grant type.
     */
    public static Grant fromTokenExchange(TokenExchangeGrant tokenExchange) {
        return builder().tokenExchange(tokenExchange).build();
    }

    /**
     * Create an instance of this class with {@link #tokenExchange()} initialized to the given value.
     *
     * <p>
     * Configuration options for the <code>urn:ietf:params:oauth:grant-type:token-exchange</code> grant type.
     * </p>
     * 
     * @param tokenExchange
     *        Configuration options for the <code>urn:ietf:params:oauth:grant-type:token-exchange</code> grant type.
     */
    public static Grant fromTokenExchange(Consumer<TokenExchangeGrant.Builder> tokenExchange) {
        TokenExchangeGrant.Builder builder = TokenExchangeGrant.builder();
        tokenExchange.accept(builder);
        return fromTokenExchange(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthorizationCode", AUTHORIZATION_CODE_FIELD);
        map.put("JwtBearer", JWT_BEARER_FIELD);
        map.put("RefreshToken", REFRESH_TOKEN_FIELD);
        map.put("TokenExchange", TOKEN_EXCHANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Grant, T> g) {
        return obj -> g.apply((Grant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Grant> {
        /**
         * <p>
         * Configuration options for the <code>authorization_code</code> grant type.
         * </p>
         * 
         * @param authorizationCode
         *        Configuration options for the <code>authorization_code</code> grant type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationCode(AuthorizationCodeGrant authorizationCode);

        /**
         * <p>
         * Configuration options for the <code>authorization_code</code> grant type.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizationCodeGrant.Builder} avoiding
         * the need to create one manually via {@link AuthorizationCodeGrant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizationCodeGrant.Builder#build()} is called immediately and
         * its result is passed to {@link #authorizationCode(AuthorizationCodeGrant)}.
         * 
         * @param authorizationCode
         *        a consumer that will call methods on {@link AuthorizationCodeGrant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationCode(AuthorizationCodeGrant)
         */
        default Builder authorizationCode(Consumer<AuthorizationCodeGrant.Builder> authorizationCode) {
            return authorizationCode(AuthorizationCodeGrant.builder().applyMutation(authorizationCode).build());
        }

        /**
         * <p>
         * Configuration options for the <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code> grant type.
         * </p>
         * 
         * @param jwtBearer
         *        Configuration options for the <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code> grant type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jwtBearer(JwtBearerGrant jwtBearer);

        /**
         * <p>
         * Configuration options for the <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code> grant type.
         * </p>
         * This is a convenience method that creates an instance of the {@link JwtBearerGrant.Builder} avoiding the need
         * to create one manually via {@link JwtBearerGrant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JwtBearerGrant.Builder#build()} is called immediately and its
         * result is passed to {@link #jwtBearer(JwtBearerGrant)}.
         * 
         * @param jwtBearer
         *        a consumer that will call methods on {@link JwtBearerGrant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jwtBearer(JwtBearerGrant)
         */
        default Builder jwtBearer(Consumer<JwtBearerGrant.Builder> jwtBearer) {
            return jwtBearer(JwtBearerGrant.builder().applyMutation(jwtBearer).build());
        }

        /**
         * <p>
         * Configuration options for the <code>refresh_token</code> grant type.
         * </p>
         * 
         * @param refreshToken
         *        Configuration options for the <code>refresh_token</code> grant type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(RefreshTokenGrant refreshToken);

        /**
         * <p>
         * Configuration options for the <code>refresh_token</code> grant type.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshTokenGrant.Builder} avoiding the
         * need to create one manually via {@link RefreshTokenGrant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshTokenGrant.Builder#build()} is called immediately and its
         * result is passed to {@link #refreshToken(RefreshTokenGrant)}.
         * 
         * @param refreshToken
         *        a consumer that will call methods on {@link RefreshTokenGrant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshToken(RefreshTokenGrant)
         */
        default Builder refreshToken(Consumer<RefreshTokenGrant.Builder> refreshToken) {
            return refreshToken(RefreshTokenGrant.builder().applyMutation(refreshToken).build());
        }

        /**
         * <p>
         * Configuration options for the <code>urn:ietf:params:oauth:grant-type:token-exchange</code> grant type.
         * </p>
         * 
         * @param tokenExchange
         *        Configuration options for the <code>urn:ietf:params:oauth:grant-type:token-exchange</code> grant type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenExchange(TokenExchangeGrant tokenExchange);

        /**
         * <p>
         * Configuration options for the <code>urn:ietf:params:oauth:grant-type:token-exchange</code> grant type.
         * </p>
         * This is a convenience method that creates an instance of the {@link TokenExchangeGrant.Builder} avoiding the
         * need to create one manually via {@link TokenExchangeGrant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TokenExchangeGrant.Builder#build()} is called immediately and its
         * result is passed to {@link #tokenExchange(TokenExchangeGrant)}.
         * 
         * @param tokenExchange
         *        a consumer that will call methods on {@link TokenExchangeGrant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tokenExchange(TokenExchangeGrant)
         */
        default Builder tokenExchange(Consumer<TokenExchangeGrant.Builder> tokenExchange) {
            return tokenExchange(TokenExchangeGrant.builder().applyMutation(tokenExchange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AuthorizationCodeGrant authorizationCode;

        private JwtBearerGrant jwtBearer;

        private RefreshTokenGrant refreshToken;

        private TokenExchangeGrant tokenExchange;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Grant model) {
            authorizationCode(model.authorizationCode);
            jwtBearer(model.jwtBearer);
            refreshToken(model.refreshToken);
            tokenExchange(model.tokenExchange);
        }

        public final AuthorizationCodeGrant.Builder getAuthorizationCode() {
            return authorizationCode != null ? authorizationCode.toBuilder() : null;
        }

        public final void setAuthorizationCode(AuthorizationCodeGrant.BuilderImpl authorizationCode) {
            Object oldValue = this.authorizationCode;
            this.authorizationCode = authorizationCode != null ? authorizationCode.build() : null;
            handleUnionValueChange(Type.AUTHORIZATION_CODE, oldValue, this.authorizationCode);
        }

        @Override
        public final Builder authorizationCode(AuthorizationCodeGrant authorizationCode) {
            Object oldValue = this.authorizationCode;
            this.authorizationCode = authorizationCode;
            handleUnionValueChange(Type.AUTHORIZATION_CODE, oldValue, this.authorizationCode);
            return this;
        }

        public final JwtBearerGrant.Builder getJwtBearer() {
            return jwtBearer != null ? jwtBearer.toBuilder() : null;
        }

        public final void setJwtBearer(JwtBearerGrant.BuilderImpl jwtBearer) {
            Object oldValue = this.jwtBearer;
            this.jwtBearer = jwtBearer != null ? jwtBearer.build() : null;
            handleUnionValueChange(Type.JWT_BEARER, oldValue, this.jwtBearer);
        }

        @Override
        public final Builder jwtBearer(JwtBearerGrant jwtBearer) {
            Object oldValue = this.jwtBearer;
            this.jwtBearer = jwtBearer;
            handleUnionValueChange(Type.JWT_BEARER, oldValue, this.jwtBearer);
            return this;
        }

        public final RefreshTokenGrant.Builder getRefreshToken() {
            return refreshToken != null ? refreshToken.toBuilder() : null;
        }

        public final void setRefreshToken(RefreshTokenGrant.BuilderImpl refreshToken) {
            Object oldValue = this.refreshToken;
            this.refreshToken = refreshToken != null ? refreshToken.build() : null;
            handleUnionValueChange(Type.REFRESH_TOKEN, oldValue, this.refreshToken);
        }

        @Override
        public final Builder refreshToken(RefreshTokenGrant refreshToken) {
            Object oldValue = this.refreshToken;
            this.refreshToken = refreshToken;
            handleUnionValueChange(Type.REFRESH_TOKEN, oldValue, this.refreshToken);
            return this;
        }

        public final TokenExchangeGrant.Builder getTokenExchange() {
            return tokenExchange != null ? tokenExchange.toBuilder() : null;
        }

        public final void setTokenExchange(TokenExchangeGrant.BuilderImpl tokenExchange) {
            Object oldValue = this.tokenExchange;
            this.tokenExchange = tokenExchange != null ? tokenExchange.build() : null;
            handleUnionValueChange(Type.TOKEN_EXCHANGE, oldValue, this.tokenExchange);
        }

        @Override
        public final Builder tokenExchange(TokenExchangeGrant tokenExchange) {
            Object oldValue = this.tokenExchange;
            this.tokenExchange = tokenExchange;
            handleUnionValueChange(Type.TOKEN_EXCHANGE, oldValue, this.tokenExchange);
            return this;
        }

        @Override
        public Grant build() {
            return new Grant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Grant#type()
     */
    public enum Type {
        AUTHORIZATION_CODE,

        JWT_BEARER,

        REFRESH_TOKEN,

        TOKEN_EXCHANGE,

        UNKNOWN_TO_SDK_VERSION
    }
}
