/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApplicationGrantRequest extends SsoAdminRequest implements
        ToCopyableBuilder<DeleteApplicationGrantRequest.Builder, DeleteApplicationGrantRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(DeleteApplicationGrantRequest::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<String> GRANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrantType").getter(getter(DeleteApplicationGrantRequest::grantTypeAsString))
            .setter(setter(Builder::grantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            GRANT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationArn;

    private final String grantType;

    private DeleteApplicationGrantRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.grantType = builder.grantType;
    }

    /**
     * <p>
     * Specifies the ARN of the application with the grant to delete.
     * </p>
     * 
     * @return Specifies the ARN of the application with the grant to delete.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * Specifies the type of grant to delete from the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #grantType} will
     * return {@link GrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #grantTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of grant to delete from the application.
     * @see GrantType
     */
    public final GrantType grantType() {
        return GrantType.fromValue(grantType);
    }

    /**
     * <p>
     * Specifies the type of grant to delete from the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #grantType} will
     * return {@link GrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #grantTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of grant to delete from the application.
     * @see GrantType
     */
    public final String grantTypeAsString() {
        return grantType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(grantTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationGrantRequest)) {
            return false;
        }
        DeleteApplicationGrantRequest other = (DeleteApplicationGrantRequest) obj;
        return Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(grantTypeAsString(), other.grantTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteApplicationGrantRequest").add("ApplicationArn", applicationArn())
                .add("GrantType", grantTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "GrantType":
            return Optional.ofNullable(clazz.cast(grantTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("GrantType", GRANT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationGrantRequest, T> g) {
        return obj -> g.apply((DeleteApplicationGrantRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteApplicationGrantRequest> {
        /**
         * <p>
         * Specifies the ARN of the application with the grant to delete.
         * </p>
         * 
         * @param applicationArn
         *        Specifies the ARN of the application with the grant to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * Specifies the type of grant to delete from the application.
         * </p>
         * 
         * @param grantType
         *        Specifies the type of grant to delete from the application.
         * @see GrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantType
         */
        Builder grantType(String grantType);

        /**
         * <p>
         * Specifies the type of grant to delete from the application.
         * </p>
         * 
         * @param grantType
         *        Specifies the type of grant to delete from the application.
         * @see GrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrantType
         */
        Builder grantType(GrantType grantType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String applicationArn;

        private String grantType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationGrantRequest model) {
            super(model);
            applicationArn(model.applicationArn);
            grantType(model.grantType);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getGrantType() {
            return grantType;
        }

        public final void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @Override
        public final Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        @Override
        public final Builder grantType(GrantType grantType) {
            this.grantType(grantType == null ? null : grantType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationGrantRequest build() {
            return new DeleteApplicationGrantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
