/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the <a>AccountAssignment</a> creation request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountAssignmentOperationStatusMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountAssignmentOperationStatusMetadata.Builder, AccountAssignmentOperationStatusMetadata> {
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(AccountAssignmentOperationStatusMetadata::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(AccountAssignmentOperationStatusMetadata::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AccountAssignmentOperationStatusMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_DATE_FIELD,
            REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdDate;

    private final String requestId;

    private final String status;

    private AccountAssignmentOperationStatusMetadata(BuilderImpl builder) {
        this.createdDate = builder.createdDate;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The date that the permission set was created.
     * </p>
     * 
     * @return The date that the permission set was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The identifier for tracking the request operation that is generated by the universally unique identifier (UUID)
     * workflow.
     * </p>
     * 
     * @return The identifier for tracking the request operation that is generated by the universally unique identifier
     *         (UUID) workflow.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The status of the permission set provisioning process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the permission set provisioning process.
     * @see StatusValues
     */
    public final StatusValues status() {
        return StatusValues.fromValue(status);
    }

    /**
     * <p>
     * The status of the permission set provisioning process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the permission set provisioning process.
     * @see StatusValues
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAssignmentOperationStatusMetadata)) {
            return false;
        }
        AccountAssignmentOperationStatusMetadata other = (AccountAssignmentOperationStatusMetadata) obj;
        return Objects.equals(createdDate(), other.createdDate()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountAssignmentOperationStatusMetadata").add("CreatedDate", createdDate())
                .add("RequestId", requestId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountAssignmentOperationStatusMetadata, T> g) {
        return obj -> g.apply((AccountAssignmentOperationStatusMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountAssignmentOperationStatusMetadata> {
        /**
         * <p>
         * The date that the permission set was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the permission set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The identifier for tracking the request operation that is generated by the universally unique identifier
         * (UUID) workflow.
         * </p>
         * 
         * @param requestId
         *        The identifier for tracking the request operation that is generated by the universally unique
         *        identifier (UUID) workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The status of the permission set provisioning process.
         * </p>
         * 
         * @param status
         *        The status of the permission set provisioning process.
         * @see StatusValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusValues
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the permission set provisioning process.
         * </p>
         * 
         * @param status
         *        The status of the permission set provisioning process.
         * @see StatusValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusValues
         */
        Builder status(StatusValues status);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdDate;

        private String requestId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAssignmentOperationStatusMetadata model) {
            createdDate(model.createdDate);
            requestId(model.requestId);
            status(model.status);
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusValues status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public AccountAssignmentOperationStatusMetadata build() {
            return new AccountAssignmentOperationStatusMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
