/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value used for mapping a specified attribute to an identity source. For more information, see <a
 * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/attributemappingsconcept.html">Attribute mappings</a>
 * in the <i>IAM Identity Center User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessControlAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessControlAttributeValue.Builder, AccessControlAttributeValue> {
    private static final SdkField<List<String>> SOURCE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Source")
            .getter(getter(AccessControlAttributeValue::source))
            .setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> source;

    private AccessControlAttributeValue(BuilderImpl builder) {
        this.source = builder.source;
    }

    /**
     * For responses, this returns true if the service returned a value for the Source property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSource() {
        return source != null && !(source instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identity source to use when mapping a specified attribute to IAM Identity Center.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSource} method.
     * </p>
     * 
     * @return The identity source to use when mapping a specified attribute to IAM Identity Center.
     */
    public final List<String> source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSource() ? source() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControlAttributeValue)) {
            return false;
        }
        AccessControlAttributeValue other = (AccessControlAttributeValue) obj;
        return hasSource() == other.hasSource() && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessControlAttributeValue").add("Source", hasSource() ? source() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessControlAttributeValue, T> g) {
        return obj -> g.apply((AccessControlAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessControlAttributeValue> {
        /**
         * <p>
         * The identity source to use when mapping a specified attribute to IAM Identity Center.
         * </p>
         * 
         * @param source
         *        The identity source to use when mapping a specified attribute to IAM Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Collection<String> source);

        /**
         * <p>
         * The identity source to use when mapping a specified attribute to IAM Identity Center.
         * </p>
         * 
         * @param source
         *        The identity source to use when mapping a specified attribute to IAM Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String... source);
    }

    static final class BuilderImpl implements Builder {
        private List<String> source = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControlAttributeValue model) {
            source(model.source);
        }

        public final Collection<String> getSource() {
            if (source instanceof SdkAutoConstructList) {
                return null;
            }
            return source;
        }

        public final void setSource(Collection<String> source) {
            this.source = AccessControlAttributeValueSourceListCopier.copy(source);
        }

        @Override
        public final Builder source(Collection<String> source) {
            this.source = AccessControlAttributeValueSourceListCopier.copy(source);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder source(String... source) {
            source(Arrays.asList(source));
            return this;
        }

        @Override
        public AccessControlAttributeValue build() {
            return new AccessControlAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
