/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrustedTokenIssuerType {
    OIDC_JWT("OIDC_JWT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrustedTokenIssuerType> VALUE_MAP;
    private final String value;

    private TrustedTokenIssuerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrustedTokenIssuerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrustedTokenIssuerType> knownValues() {
        EnumSet<TrustedTokenIssuerType> knownValues = EnumSet.allOf(TrustedTokenIssuerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrustedTokenIssuerType.class, TrustedTokenIssuerType::toString);
    }
}

