/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes a trusted token issuer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustedTokenIssuerMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustedTokenIssuerMetadata.Builder, TrustedTokenIssuerMetadata> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TrustedTokenIssuerMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedTokenIssuerArn").getter(getter(TrustedTokenIssuerMetadata::trustedTokenIssuerArn))
            .setter(setter(Builder::trustedTokenIssuerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerArn").build())
            .build();

    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedTokenIssuerType").getter(getter(TrustedTokenIssuerMetadata::trustedTokenIssuerTypeAsString))
            .setter(setter(Builder::trustedTokenIssuerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TRUSTED_TOKEN_ISSUER_ARN_FIELD, TRUSTED_TOKEN_ISSUER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String trustedTokenIssuerArn;

    private final String trustedTokenIssuerType;

    private TrustedTokenIssuerMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.trustedTokenIssuerArn = builder.trustedTokenIssuerArn;
        this.trustedTokenIssuerType = builder.trustedTokenIssuerType;
    }

    /**
     * <p>
     * The name of the trusted token issuer configuration in the instance of IAM Identity Center.
     * </p>
     * 
     * @return The name of the trusted token issuer configuration in the instance of IAM Identity Center.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the trusted token issuer configuration in the instance of IAM Identity Center.
     * </p>
     * 
     * @return The ARN of the trusted token issuer configuration in the instance of IAM Identity Center.
     */
    public final String trustedTokenIssuerArn() {
        return trustedTokenIssuerArn;
    }

    /**
     * <p>
     * The type of trusted token issuer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustedTokenIssuerType} will return {@link TrustedTokenIssuerType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trustedTokenIssuerTypeAsString}.
     * </p>
     * 
     * @return The type of trusted token issuer.
     * @see TrustedTokenIssuerType
     */
    public final TrustedTokenIssuerType trustedTokenIssuerType() {
        return TrustedTokenIssuerType.fromValue(trustedTokenIssuerType);
    }

    /**
     * <p>
     * The type of trusted token issuer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustedTokenIssuerType} will return {@link TrustedTokenIssuerType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trustedTokenIssuerTypeAsString}.
     * </p>
     * 
     * @return The type of trusted token issuer.
     * @see TrustedTokenIssuerType
     */
    public final String trustedTokenIssuerTypeAsString() {
        return trustedTokenIssuerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerArn());
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedTokenIssuerMetadata)) {
            return false;
        }
        TrustedTokenIssuerMetadata other = (TrustedTokenIssuerMetadata) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(trustedTokenIssuerArn(), other.trustedTokenIssuerArn())
                && Objects.equals(trustedTokenIssuerTypeAsString(), other.trustedTokenIssuerTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrustedTokenIssuerMetadata").add("Name", name())
                .add("TrustedTokenIssuerArn", trustedTokenIssuerArn())
                .add("TrustedTokenIssuerType", trustedTokenIssuerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TrustedTokenIssuerArn":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerArn()));
        case "TrustedTokenIssuerType":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrustedTokenIssuerMetadata, T> g) {
        return obj -> g.apply((TrustedTokenIssuerMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustedTokenIssuerMetadata> {
        /**
         * <p>
         * The name of the trusted token issuer configuration in the instance of IAM Identity Center.
         * </p>
         * 
         * @param name
         *        The name of the trusted token issuer configuration in the instance of IAM Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the trusted token issuer configuration in the instance of IAM Identity Center.
         * </p>
         * 
         * @param trustedTokenIssuerArn
         *        The ARN of the trusted token issuer configuration in the instance of IAM Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedTokenIssuerArn(String trustedTokenIssuerArn);

        /**
         * <p>
         * The type of trusted token issuer.
         * </p>
         * 
         * @param trustedTokenIssuerType
         *        The type of trusted token issuer.
         * @see TrustedTokenIssuerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustedTokenIssuerType
         */
        Builder trustedTokenIssuerType(String trustedTokenIssuerType);

        /**
         * <p>
         * The type of trusted token issuer.
         * </p>
         * 
         * @param trustedTokenIssuerType
         *        The type of trusted token issuer.
         * @see TrustedTokenIssuerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustedTokenIssuerType
         */
        Builder trustedTokenIssuerType(TrustedTokenIssuerType trustedTokenIssuerType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String trustedTokenIssuerArn;

        private String trustedTokenIssuerType;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedTokenIssuerMetadata model) {
            name(model.name);
            trustedTokenIssuerArn(model.trustedTokenIssuerArn);
            trustedTokenIssuerType(model.trustedTokenIssuerType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrustedTokenIssuerArn() {
            return trustedTokenIssuerArn;
        }

        public final void setTrustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
        }

        @Override
        public final Builder trustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
            return this;
        }

        public final String getTrustedTokenIssuerType() {
            return trustedTokenIssuerType;
        }

        public final void setTrustedTokenIssuerType(String trustedTokenIssuerType) {
            this.trustedTokenIssuerType = trustedTokenIssuerType;
        }

        @Override
        public final Builder trustedTokenIssuerType(String trustedTokenIssuerType) {
            this.trustedTokenIssuerType = trustedTokenIssuerType;
            return this;
        }

        @Override
        public final Builder trustedTokenIssuerType(TrustedTokenIssuerType trustedTokenIssuerType) {
            this.trustedTokenIssuerType(trustedTokenIssuerType == null ? null : trustedTokenIssuerType.toString());
            return this;
        }

        @Override
        public TrustedTokenIssuerMetadata build() {
            return new TrustedTokenIssuerMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
