/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse;

public class ListPermissionSetsPublisher
implements SdkPublisher<ListPermissionSetsResponse> {
    private final SsoAdminAsyncClient client;
    private final ListPermissionSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPermissionSetsPublisher(SsoAdminAsyncClient client, ListPermissionSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPermissionSetsPublisher(SsoAdminAsyncClient client, ListPermissionSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPermissionSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPermissionSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> permissionSets() {
        Function<ListPermissionSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissionSets() != null) {
                return response.permissionSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPermissionSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPermissionSetsResponseFetcher
    implements AsyncPageFetcher<ListPermissionSetsResponse> {
        private ListPermissionSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPermissionSetsResponse> nextPage(ListPermissionSetsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionSetsPublisher.this.client.listPermissionSets(ListPermissionSetsPublisher.this.firstRequest);
            }
            return ListPermissionSetsPublisher.this.client.listPermissionSets((ListPermissionSetsRequest)((Object)ListPermissionSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

