/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes configuration settings for a trusted token issuer that supports OpenID Connect (OIDC) and
 * JSON Web Tokens (JWTs).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OidcJwtConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OidcJwtConfiguration.Builder, OidcJwtConfiguration> {
    private static final SdkField<String> CLAIM_ATTRIBUTE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClaimAttributePath").getter(getter(OidcJwtConfiguration::claimAttributePath))
            .setter(setter(Builder::claimAttributePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClaimAttributePath").build())
            .build();

    private static final SdkField<String> IDENTITY_STORE_ATTRIBUTE_PATH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityStoreAttributePath")
            .getter(getter(OidcJwtConfiguration::identityStoreAttributePath))
            .setter(setter(Builder::identityStoreAttributePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreAttributePath").build())
            .build();

    private static final SdkField<String> ISSUER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IssuerUrl").getter(getter(OidcJwtConfiguration::issuerUrl)).setter(setter(Builder::issuerUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuerUrl").build()).build();

    private static final SdkField<String> JWKS_RETRIEVAL_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JwksRetrievalOption").getter(getter(OidcJwtConfiguration::jwksRetrievalOptionAsString))
            .setter(setter(Builder::jwksRetrievalOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwksRetrievalOption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLAIM_ATTRIBUTE_PATH_FIELD,
            IDENTITY_STORE_ATTRIBUTE_PATH_FIELD, ISSUER_URL_FIELD, JWKS_RETRIEVAL_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String claimAttributePath;

    private final String identityStoreAttributePath;

    private final String issuerUrl;

    private final String jwksRetrievalOption;

    private OidcJwtConfiguration(BuilderImpl builder) {
        this.claimAttributePath = builder.claimAttributePath;
        this.identityStoreAttributePath = builder.identityStoreAttributePath;
        this.issuerUrl = builder.issuerUrl;
        this.jwksRetrievalOption = builder.jwksRetrievalOption;
    }

    /**
     * <p>
     * The path of the source attribute in the JWT from the trusted token issuer. The attribute mapped by this JMESPath
     * expression is compared against the attribute mapped by <code>IdentityStoreAttributePath</code> when a trusted
     * token issuer token is exchanged for an IAM Identity Center token.
     * </p>
     * 
     * @return The path of the source attribute in the JWT from the trusted token issuer. The attribute mapped by this
     *         JMESPath expression is compared against the attribute mapped by <code>IdentityStoreAttributePath</code>
     *         when a trusted token issuer token is exchanged for an IAM Identity Center token.
     */
    public final String claimAttributePath() {
        return claimAttributePath;
    }

    /**
     * <p>
     * The path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this JMESPath
     * expression is compared against the attribute mapped by <code>ClaimAttributePath</code> when a trusted token
     * issuer token is exchanged for an IAM Identity Center token.
     * </p>
     * 
     * @return The path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this
     *         JMESPath expression is compared against the attribute mapped by <code>ClaimAttributePath</code> when a
     *         trusted token issuer token is exchanged for an IAM Identity Center token.
     */
    public final String identityStoreAttributePath() {
        return identityStoreAttributePath;
    }

    /**
     * <p>
     * The URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the information
     * required to verify the tokens that the trusted token issuer generates.
     * </p>
     * 
     * @return The URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the
     *         information required to verify the tokens that the trusted token issuer generates.
     */
    public final String issuerUrl() {
        return issuerUrl;
    }

    /**
     * <p>
     * The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #jwksRetrievalOption} will return {@link JwksRetrievalOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #jwksRetrievalOptionAsString}.
     * </p>
     * 
     * @return The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT.
     * @see JwksRetrievalOption
     */
    public final JwksRetrievalOption jwksRetrievalOption() {
        return JwksRetrievalOption.fromValue(jwksRetrievalOption);
    }

    /**
     * <p>
     * The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #jwksRetrievalOption} will return {@link JwksRetrievalOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #jwksRetrievalOptionAsString}.
     * </p>
     * 
     * @return The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT.
     * @see JwksRetrievalOption
     */
    public final String jwksRetrievalOptionAsString() {
        return jwksRetrievalOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(claimAttributePath());
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreAttributePath());
        hashCode = 31 * hashCode + Objects.hashCode(issuerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(jwksRetrievalOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcJwtConfiguration)) {
            return false;
        }
        OidcJwtConfiguration other = (OidcJwtConfiguration) obj;
        return Objects.equals(claimAttributePath(), other.claimAttributePath())
                && Objects.equals(identityStoreAttributePath(), other.identityStoreAttributePath())
                && Objects.equals(issuerUrl(), other.issuerUrl())
                && Objects.equals(jwksRetrievalOptionAsString(), other.jwksRetrievalOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OidcJwtConfiguration").add("ClaimAttributePath", claimAttributePath())
                .add("IdentityStoreAttributePath", identityStoreAttributePath()).add("IssuerUrl", issuerUrl())
                .add("JwksRetrievalOption", jwksRetrievalOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClaimAttributePath":
            return Optional.ofNullable(clazz.cast(claimAttributePath()));
        case "IdentityStoreAttributePath":
            return Optional.ofNullable(clazz.cast(identityStoreAttributePath()));
        case "IssuerUrl":
            return Optional.ofNullable(clazz.cast(issuerUrl()));
        case "JwksRetrievalOption":
            return Optional.ofNullable(clazz.cast(jwksRetrievalOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OidcJwtConfiguration, T> g) {
        return obj -> g.apply((OidcJwtConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OidcJwtConfiguration> {
        /**
         * <p>
         * The path of the source attribute in the JWT from the trusted token issuer. The attribute mapped by this
         * JMESPath expression is compared against the attribute mapped by <code>IdentityStoreAttributePath</code> when
         * a trusted token issuer token is exchanged for an IAM Identity Center token.
         * </p>
         * 
         * @param claimAttributePath
         *        The path of the source attribute in the JWT from the trusted token issuer. The attribute mapped by
         *        this JMESPath expression is compared against the attribute mapped by
         *        <code>IdentityStoreAttributePath</code> when a trusted token issuer token is exchanged for an IAM
         *        Identity Center token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimAttributePath(String claimAttributePath);

        /**
         * <p>
         * The path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this
         * JMESPath expression is compared against the attribute mapped by <code>ClaimAttributePath</code> when a
         * trusted token issuer token is exchanged for an IAM Identity Center token.
         * </p>
         * 
         * @param identityStoreAttributePath
         *        The path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this
         *        JMESPath expression is compared against the attribute mapped by <code>ClaimAttributePath</code> when a
         *        trusted token issuer token is exchanged for an IAM Identity Center token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreAttributePath(String identityStoreAttributePath);

        /**
         * <p>
         * The URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the
         * information required to verify the tokens that the trusted token issuer generates.
         * </p>
         * 
         * @param issuerUrl
         *        The URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the
         *        information required to verify the tokens that the trusted token issuer generates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuerUrl(String issuerUrl);

        /**
         * <p>
         * The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT.
         * </p>
         * 
         * @param jwksRetrievalOption
         *        The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a
         *        JWT.
         * @see JwksRetrievalOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JwksRetrievalOption
         */
        Builder jwksRetrievalOption(String jwksRetrievalOption);

        /**
         * <p>
         * The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT.
         * </p>
         * 
         * @param jwksRetrievalOption
         *        The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a
         *        JWT.
         * @see JwksRetrievalOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JwksRetrievalOption
         */
        Builder jwksRetrievalOption(JwksRetrievalOption jwksRetrievalOption);
    }

    static final class BuilderImpl implements Builder {
        private String claimAttributePath;

        private String identityStoreAttributePath;

        private String issuerUrl;

        private String jwksRetrievalOption;

        private BuilderImpl() {
        }

        private BuilderImpl(OidcJwtConfiguration model) {
            claimAttributePath(model.claimAttributePath);
            identityStoreAttributePath(model.identityStoreAttributePath);
            issuerUrl(model.issuerUrl);
            jwksRetrievalOption(model.jwksRetrievalOption);
        }

        public final String getClaimAttributePath() {
            return claimAttributePath;
        }

        public final void setClaimAttributePath(String claimAttributePath) {
            this.claimAttributePath = claimAttributePath;
        }

        @Override
        public final Builder claimAttributePath(String claimAttributePath) {
            this.claimAttributePath = claimAttributePath;
            return this;
        }

        public final String getIdentityStoreAttributePath() {
            return identityStoreAttributePath;
        }

        public final void setIdentityStoreAttributePath(String identityStoreAttributePath) {
            this.identityStoreAttributePath = identityStoreAttributePath;
        }

        @Override
        public final Builder identityStoreAttributePath(String identityStoreAttributePath) {
            this.identityStoreAttributePath = identityStoreAttributePath;
            return this;
        }

        public final String getIssuerUrl() {
            return issuerUrl;
        }

        public final void setIssuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
        }

        @Override
        public final Builder issuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        public final String getJwksRetrievalOption() {
            return jwksRetrievalOption;
        }

        public final void setJwksRetrievalOption(String jwksRetrievalOption) {
            this.jwksRetrievalOption = jwksRetrievalOption;
        }

        @Override
        public final Builder jwksRetrievalOption(String jwksRetrievalOption) {
            this.jwksRetrievalOption = jwksRetrievalOption;
            return this;
        }

        @Override
        public final Builder jwksRetrievalOption(JwksRetrievalOption jwksRetrievalOption) {
            this.jwksRetrievalOption(jwksRetrievalOption == null ? null : jwksRetrievalOption.toString());
            return this;
        }

        @Override
        public OidcJwtConfiguration build() {
            return new OidcJwtConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
