/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes details for authentication that uses IAM.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamAuthenticationMethod implements SdkPojo, Serializable,
        ToCopyableBuilder<IamAuthenticationMethod.Builder, IamAuthenticationMethod> {
    private static final SdkField<Document> ACTOR_POLICY_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("ActorPolicy").getter(getter(IamAuthenticationMethod::actorPolicy)).setter(setter(Builder::actorPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActorPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTOR_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Document actorPolicy;

    private IamAuthenticationMethod(BuilderImpl builder) {
        this.actorPolicy = builder.actorPolicy;
    }

    /**
     * <p>
     * An IAM policy document in JSON.
     * </p>
     * 
     * @return An IAM policy document in JSON.
     */
    public final Document actorPolicy() {
        return actorPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actorPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamAuthenticationMethod)) {
            return false;
        }
        IamAuthenticationMethod other = (IamAuthenticationMethod) obj;
        return Objects.equals(actorPolicy(), other.actorPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamAuthenticationMethod").add("ActorPolicy", actorPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActorPolicy":
            return Optional.ofNullable(clazz.cast(actorPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IamAuthenticationMethod, T> g) {
        return obj -> g.apply((IamAuthenticationMethod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamAuthenticationMethod> {
        /**
         * <p>
         * An IAM policy document in JSON.
         * </p>
         * 
         * @param actorPolicy
         *        An IAM policy document in JSON.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actorPolicy(Document actorPolicy);
    }

    static final class BuilderImpl implements Builder {
        private Document actorPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(IamAuthenticationMethod model) {
            actorPolicy(model.actorPolicy);
        }

        public final Document getActorPolicy() {
            return actorPolicy;
        }

        public final void setActorPolicy(Document actorPolicy) {
            this.actorPolicy = actorPolicy;
        }

        @Override
        public final Builder actorPolicy(Document actorPolicy) {
            this.actorPolicy = actorPolicy;
            return this;
        }

        @Override
        public IamAuthenticationMethod build() {
            return new IamAuthenticationMethod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
