/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes the configuration of a resource server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceServerConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceServerConfig.Builder, ResourceServerConfig> {
    private static final SdkField<Map<String, ResourceServerScopeDetails>> SCOPES_FIELD = SdkField
            .<Map<String, ResourceServerScopeDetails>> builder(MarshallingType.MAP)
            .memberName("Scopes")
            .getter(getter(ResourceServerConfig::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ResourceServerScopeDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceServerScopeDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, ResourceServerScopeDetails> scopes;

    private ResourceServerConfig(BuilderImpl builder) {
        this.scopes = builder.scopes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scopes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the IAM Identity Center access scopes that are associated with this resource server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScopes} method.
     * </p>
     * 
     * @return A list of the IAM Identity Center access scopes that are associated with this resource server.
     */
    public final Map<String, ResourceServerScopeDetails> scopes() {
        return scopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasScopes() ? scopes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceServerConfig)) {
            return false;
        }
        ResourceServerConfig other = (ResourceServerConfig) obj;
        return hasScopes() == other.hasScopes() && Objects.equals(scopes(), other.scopes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceServerConfig").add("Scopes", hasScopes() ? scopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceServerConfig, T> g) {
        return obj -> g.apply((ResourceServerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceServerConfig> {
        /**
         * <p>
         * A list of the IAM Identity Center access scopes that are associated with this resource server.
         * </p>
         * 
         * @param scopes
         *        A list of the IAM Identity Center access scopes that are associated with this resource server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Map<String, ResourceServerScopeDetails> scopes);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, ResourceServerScopeDetails> scopes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceServerConfig model) {
            scopes(model.scopes);
        }

        public final Map<String, ResourceServerScopeDetails.Builder> getScopes() {
            Map<String, ResourceServerScopeDetails.Builder> result = ResourceServerScopesCopier.copyToBuilder(this.scopes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setScopes(Map<String, ResourceServerScopeDetails.BuilderImpl> scopes) {
            this.scopes = ResourceServerScopesCopier.copyFromBuilder(scopes);
        }

        @Override
        public final Builder scopes(Map<String, ResourceServerScopeDetails> scopes) {
            this.scopes = ResourceServerScopesCopier.copy(scopes);
            return this;
        }

        @Override
        public ResourceServerConfig build() {
            return new ResourceServerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
