/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the attributes to add to your attribute-based access control (ABAC) configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceAccessControlAttributeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceAccessControlAttributeConfiguration.Builder, InstanceAccessControlAttributeConfiguration> {
    private static final SdkField<List<AccessControlAttribute>> ACCESS_CONTROL_ATTRIBUTES_FIELD = SdkField
            .<List<AccessControlAttribute>> builder(MarshallingType.LIST)
            .memberName("AccessControlAttributes")
            .getter(getter(InstanceAccessControlAttributeConfiguration::accessControlAttributes))
            .setter(setter(Builder::accessControlAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessControlAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessControlAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACCESS_CONTROL_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AccessControlAttribute> accessControlAttributes;

    private InstanceAccessControlAttributeConfiguration(BuilderImpl builder) {
        this.accessControlAttributes = builder.accessControlAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessControlAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAccessControlAttributes() {
        return accessControlAttributes != null && !(accessControlAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessControlAttributes} method.
     * </p>
     * 
     * @return Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
     */
    public final List<AccessControlAttribute> accessControlAttributes() {
        return accessControlAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessControlAttributes() ? accessControlAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAccessControlAttributeConfiguration)) {
            return false;
        }
        InstanceAccessControlAttributeConfiguration other = (InstanceAccessControlAttributeConfiguration) obj;
        return hasAccessControlAttributes() == other.hasAccessControlAttributes()
                && Objects.equals(accessControlAttributes(), other.accessControlAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceAccessControlAttributeConfiguration")
                .add("AccessControlAttributes", hasAccessControlAttributes() ? accessControlAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessControlAttributes":
            return Optional.ofNullable(clazz.cast(accessControlAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceAccessControlAttributeConfiguration, T> g) {
        return obj -> g.apply((InstanceAccessControlAttributeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceAccessControlAttributeConfiguration> {
        /**
         * <p>
         * Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
         * </p>
         * 
         * @param accessControlAttributes
         *        Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlAttributes(Collection<AccessControlAttribute> accessControlAttributes);

        /**
         * <p>
         * Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
         * </p>
         * 
         * @param accessControlAttributes
         *        Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlAttributes(AccessControlAttribute... accessControlAttributes);

        /**
         * <p>
         * Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssoadmin.model.AccessControlAttribute.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ssoadmin.model.AccessControlAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssoadmin.model.AccessControlAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #accessControlAttributes(List<AccessControlAttribute>)}.
         * 
         * @param accessControlAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssoadmin.model.AccessControlAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControlAttributes(java.util.Collection<AccessControlAttribute>)
         */
        Builder accessControlAttributes(Consumer<AccessControlAttribute.Builder>... accessControlAttributes);
    }

    static final class BuilderImpl implements Builder {
        private List<AccessControlAttribute> accessControlAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAccessControlAttributeConfiguration model) {
            accessControlAttributes(model.accessControlAttributes);
        }

        public final List<AccessControlAttribute.Builder> getAccessControlAttributes() {
            List<AccessControlAttribute.Builder> result = AccessControlAttributeListCopier
                    .copyToBuilder(this.accessControlAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControlAttributes(Collection<AccessControlAttribute.BuilderImpl> accessControlAttributes) {
            this.accessControlAttributes = AccessControlAttributeListCopier.copyFromBuilder(accessControlAttributes);
        }

        @Override
        public final Builder accessControlAttributes(Collection<AccessControlAttribute> accessControlAttributes) {
            this.accessControlAttributes = AccessControlAttributeListCopier.copy(accessControlAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlAttributes(AccessControlAttribute... accessControlAttributes) {
            accessControlAttributes(Arrays.asList(accessControlAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlAttributes(Consumer<AccessControlAttribute.Builder>... accessControlAttributes) {
            accessControlAttributes(Stream.of(accessControlAttributes)
                    .map(c -> AccessControlAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InstanceAccessControlAttributeConfiguration build() {
            return new InstanceAccessControlAttributeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
