/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ssoadmin.model.AccessDeniedException;
import software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ConflictException;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.InternalServerException;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ssoadmin.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminException;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.ThrottlingException;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ValidationException;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountIterable;
import software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourceIterable;

/**
 * Service client for accessing SSO Admin. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS IAM Identity Center (successor to AWS Single Sign-On) helps you securely create, or connect, your workforce
 * identities and manage their access centrally across AWS accounts and applications. IAM Identity Center is the
 * recommended approach for workforce authentication and authorization in AWS, for organizations of any size and type.
 * </p>
 * <note>
 * <p>
 * Although AWS Single Sign-On was renamed, the <code>sso</code> and <code>identitystore</code> API namespaces will
 * continue to retain their original name for backward compatibility purposes. For more information, see <a
 * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html#renamed">IAM Identity Center rename</a>.
 * </p>
 * </note>
 * <p>
 * This reference guide provides information on single sign-on operations which could be used for access management of
 * AWS accounts. For information about IAM Identity Center features, see the <a
 * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html">IAM Identity Center User Guide</a>.
 * </p>
 * <p>
 * Many operations in the IAM Identity Center APIs rely on identifiers for users and groups, known as principals. For
 * more information about how to work with principals and principal IDs in IAM Identity Center, see the <a
 * href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Identity Store API
 * Reference</a>.
 * </p>
 * <note>
 * <p>
 * AWS provides SDKs that consist of libraries and sample code for various programming languages and platforms (Java,
 * Ruby, .Net, iOS, Android, and more). The SDKs provide a convenient way to create programmatic access to IAM Identity
 * Center and other AWS services. For more information about the AWS SDKs, including how to download and install them,
 * see <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SsoAdminClient extends SdkClient {
    String SERVICE_NAME = "sso";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "sso";

    /**
     * <p>
     * Attaches the specified customer managed policy to the specified <a>PermissionSet</a>.
     * </p>
     *
     * @param attachCustomerManagedPolicyReferenceToPermissionSetRequest
     * @return Result of the AttachCustomerManagedPolicyReferenceToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.AttachCustomerManagedPolicyReferenceToPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachCustomerManagedPolicyReferenceToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachCustomerManagedPolicyReferenceToPermissionSetResponse attachCustomerManagedPolicyReferenceToPermissionSet(
            AttachCustomerManagedPolicyReferenceToPermissionSetRequest attachCustomerManagedPolicyReferenceToPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified customer managed policy to the specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AttachCustomerManagedPolicyReferenceToPermissionSetRequest.Builder} avoiding the need to create one
     * manually via {@link AttachCustomerManagedPolicyReferenceToPermissionSetRequest#builder()}
     * </p>
     *
     * @param attachCustomerManagedPolicyReferenceToPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AttachCustomerManagedPolicyReferenceToPermissionSetRequest.Builder} to create a request.
     * @return Result of the AttachCustomerManagedPolicyReferenceToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.AttachCustomerManagedPolicyReferenceToPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachCustomerManagedPolicyReferenceToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachCustomerManagedPolicyReferenceToPermissionSetResponse attachCustomerManagedPolicyReferenceToPermissionSet(
            Consumer<AttachCustomerManagedPolicyReferenceToPermissionSetRequest.Builder> attachCustomerManagedPolicyReferenceToPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        return attachCustomerManagedPolicyReferenceToPermissionSet(AttachCustomerManagedPolicyReferenceToPermissionSetRequest
                .builder().applyMutation(attachCustomerManagedPolicyReferenceToPermissionSetRequest).build());
    }

    /**
     * <p>
     * Attaches an AWS managed policy ARN to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this operation. Calling <code>ProvisionPermissionSet</code>
     * applies the corresponding IAM policy updates to all assigned accounts.
     * </p>
     * </note>
     *
     * @param attachManagedPolicyToPermissionSetRequest
     * @return Result of the AttachManagedPolicyToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.AttachManagedPolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachManagedPolicyToPermissionSetResponse attachManagedPolicyToPermissionSet(
            AttachManagedPolicyToPermissionSetRequest attachManagedPolicyToPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an AWS managed policy ARN to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this operation. Calling <code>ProvisionPermissionSet</code>
     * applies the corresponding IAM policy updates to all assigned accounts.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachManagedPolicyToPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link AttachManagedPolicyToPermissionSetRequest#builder()}
     * </p>
     *
     * @param attachManagedPolicyToPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link AttachManagedPolicyToPermissionSetRequest.Builder} to
     *        create a request.
     * @return Result of the AttachManagedPolicyToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.AttachManagedPolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachManagedPolicyToPermissionSetResponse attachManagedPolicyToPermissionSet(
            Consumer<AttachManagedPolicyToPermissionSetRequest.Builder> attachManagedPolicyToPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        return attachManagedPolicyToPermissionSet(AttachManagedPolicyToPermissionSetRequest.builder()
                .applyMutation(attachManagedPolicyToPermissionSetRequest).build());
    }

    /**
     * <p>
     * Assigns access to a principal for a specified AWS account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * The term <i>principal</i> here refers to a user or group that is defined in IAM Identity Center.
     * </p>
     * </note> <note>
     * <p>
     * As part of a successful <code>CreateAccountAssignment</code> call, the specified permission set will
     * automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the IAM role
     * created in IAM Identity Center. If the permission set is subsequently updated, the corresponding IAM policies
     * attached to roles in your accounts will not be updated automatically. In this case, you must call
     * <code> <a>ProvisionPermissionSet</a> </code> to make these updates.
     * </p>
     * </note> <note>
     * <p>
     * After a successful response, call <code>DescribeAccountAssignmentCreationStatus</code> to describe the status of
     * an assignment creation request.
     * </p>
     * </note>
     *
     * @param createAccountAssignmentRequest
     * @return Result of the CreateAccountAssignment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.CreateAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccountAssignmentResponse createAccountAssignment(CreateAccountAssignmentRequest createAccountAssignmentRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns access to a principal for a specified AWS account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * The term <i>principal</i> here refers to a user or group that is defined in IAM Identity Center.
     * </p>
     * </note> <note>
     * <p>
     * As part of a successful <code>CreateAccountAssignment</code> call, the specified permission set will
     * automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the IAM role
     * created in IAM Identity Center. If the permission set is subsequently updated, the corresponding IAM policies
     * attached to roles in your accounts will not be updated automatically. In this case, you must call
     * <code> <a>ProvisionPermissionSet</a> </code> to make these updates.
     * </p>
     * </note> <note>
     * <p>
     * After a successful response, call <code>DescribeAccountAssignmentCreationStatus</code> to describe the status of
     * an assignment creation request.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAccountAssignmentRequest#builder()}
     * </p>
     *
     * @param createAccountAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateAccountAssignmentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAccountAssignment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.CreateAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccountAssignmentResponse createAccountAssignment(
            Consumer<CreateAccountAssignmentRequest.Builder> createAccountAssignmentRequest) throws ResourceNotFoundException,
            InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        return createAccountAssignment(CreateAccountAssignmentRequest.builder().applyMutation(createAccountAssignmentRequest)
                .build());
    }

    /**
     * <p>
     * Enables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance. You
     * can also specify new attributes to add to your ABAC configuration during the enabling process. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>IAM Identity Center User Guide</i>.
     * </p>
     * <note>
     * <p>
     * After a successful response, call <code>DescribeInstanceAccessControlAttributeConfiguration</code> to validate
     * that <code>InstanceAccessControlAttributeConfiguration</code> was created.
     * </p>
     * </note>
     *
     * @param createInstanceAccessControlAttributeConfigurationRequest
     * @return Result of the CreateInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.CreateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInstanceAccessControlAttributeConfigurationResponse createInstanceAccessControlAttributeConfiguration(
            CreateInstanceAccessControlAttributeConfigurationRequest createInstanceAccessControlAttributeConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance. You
     * can also specify new attributes to add to your ABAC configuration during the enabling process. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>IAM Identity Center User Guide</i>.
     * </p>
     * <note>
     * <p>
     * After a successful response, call <code>DescribeInstanceAccessControlAttributeConfiguration</code> to validate
     * that <code>InstanceAccessControlAttributeConfiguration</code> was created.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link CreateInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param createInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CreateInstanceAccessControlAttributeConfigurationRequest.Builder} to create a request.
     * @return Result of the CreateInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.CreateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInstanceAccessControlAttributeConfigurationResponse createInstanceAccessControlAttributeConfiguration(
            Consumer<CreateInstanceAccessControlAttributeConfigurationRequest.Builder> createInstanceAccessControlAttributeConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        return createInstanceAccessControlAttributeConfiguration(CreateInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(createInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a permission set within a specified IAM Identity Center instance.
     * </p>
     * <note>
     * <p>
     * To grant users and groups access to AWS account resources, use <code> <a>CreateAccountAssignment</a> </code>.
     * </p>
     * </note>
     *
     * @param createPermissionSetRequest
     * @return Result of the CreatePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.CreatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePermissionSetResponse createPermissionSet(CreatePermissionSetRequest createPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a permission set within a specified IAM Identity Center instance.
     * </p>
     * <note>
     * <p>
     * To grant users and groups access to AWS account resources, use <code> <a>CreateAccountAssignment</a> </code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePermissionSetRequest#builder()}
     * </p>
     *
     * @param createPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link CreatePermissionSetRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.CreatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePermissionSetResponse createPermissionSet(
            Consumer<CreatePermissionSetRequest.Builder> createPermissionSetRequest) throws ResourceNotFoundException,
            InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        return createPermissionSet(CreatePermissionSetRequest.builder().applyMutation(createPermissionSetRequest).build());
    }

    /**
     * <p>
     * Deletes a principal's access from a specified AWS account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * After a successful response, call <code>DescribeAccountAssignmentCreationStatus</code> to describe the status of
     * an assignment deletion request.
     * </p>
     * </note>
     *
     * @param deleteAccountAssignmentRequest
     * @return Result of the DeleteAccountAssignment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeleteAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountAssignmentResponse deleteAccountAssignment(DeleteAccountAssignmentRequest deleteAccountAssignmentRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a principal's access from a specified AWS account using a specified permission set.
     * </p>
     * <note>
     * <p>
     * After a successful response, call <code>DescribeAccountAssignmentCreationStatus</code> to describe the status of
     * an assignment deletion request.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountAssignmentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAccountAssignmentRequest#builder()}
     * </p>
     *
     * @param deleteAccountAssignmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccountAssignmentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAccountAssignment operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeleteAccountAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountAssignmentResponse deleteAccountAssignment(
            Consumer<DeleteAccountAssignmentRequest.Builder> deleteAccountAssignmentRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, SsoAdminException {
        return deleteAccountAssignment(DeleteAccountAssignmentRequest.builder().applyMutation(deleteAccountAssignmentRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the inline policy from a specified permission set.
     * </p>
     *
     * @param deleteInlinePolicyFromPermissionSetRequest
     * @return Result of the DeleteInlinePolicyFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeleteInlinePolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInlinePolicyFromPermissionSetResponse deleteInlinePolicyFromPermissionSet(
            DeleteInlinePolicyFromPermissionSetRequest deleteInlinePolicyFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the inline policy from a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInlinePolicyFromPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteInlinePolicyFromPermissionSetRequest#builder()}
     * </p>
     *
     * @param deleteInlinePolicyFromPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInlinePolicyFromPermissionSetRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteInlinePolicyFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeleteInlinePolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInlinePolicyFromPermissionSetResponse deleteInlinePolicyFromPermissionSet(
            Consumer<DeleteInlinePolicyFromPermissionSetRequest.Builder> deleteInlinePolicyFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        return deleteInlinePolicyFromPermissionSet(DeleteInlinePolicyFromPermissionSetRequest.builder()
                .applyMutation(deleteInlinePolicyFromPermissionSetRequest).build());
    }

    /**
     * <p>
     * Disables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance and
     * deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received
     * from an identity source and any custom attributes you have previously configured will not be passed. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>IAM Identity Center User Guide</i>.
     * </p>
     *
     * @param deleteInstanceAccessControlAttributeConfigurationRequest
     * @return Result of the DeleteInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeleteInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceAccessControlAttributeConfigurationResponse deleteInstanceAccessControlAttributeConfiguration(
            DeleteInstanceAccessControlAttributeConfigurationRequest deleteInstanceAccessControlAttributeConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance and
     * deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received
     * from an identity source and any custom attributes you have previously configured will not be passed. For more
     * information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a>
     * in the <i>IAM Identity Center User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link DeleteInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteInstanceAccessControlAttributeConfigurationRequest.Builder} to create a request.
     * @return Result of the DeleteInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeleteInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceAccessControlAttributeConfigurationResponse deleteInstanceAccessControlAttributeConfiguration(
            Consumer<DeleteInstanceAccessControlAttributeConfigurationRequest.Builder> deleteInstanceAccessControlAttributeConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        return deleteInstanceAccessControlAttributeConfiguration(DeleteInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(deleteInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified permission set.
     * </p>
     *
     * @param deletePermissionSetRequest
     * @return Result of the DeletePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeletePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePermissionSetResponse deletePermissionSet(DeletePermissionSetRequest deletePermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePermissionSetRequest#builder()}
     * </p>
     *
     * @param deletePermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link DeletePermissionSetRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeletePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePermissionSetResponse deletePermissionSet(
            Consumer<DeletePermissionSetRequest.Builder> deletePermissionSetRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, SsoAdminException {
        return deletePermissionSet(DeletePermissionSetRequest.builder().applyMutation(deletePermissionSetRequest).build());
    }

    /**
     * <p>
     * Deletes the permissions boundary from a specified <a>PermissionSet</a>.
     * </p>
     *
     * @param deletePermissionsBoundaryFromPermissionSetRequest
     * @return Result of the DeletePermissionsBoundaryFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeletePermissionsBoundaryFromPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionsBoundaryFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePermissionsBoundaryFromPermissionSetResponse deletePermissionsBoundaryFromPermissionSet(
            DeletePermissionsBoundaryFromPermissionSetRequest deletePermissionsBoundaryFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the permissions boundary from a specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeletePermissionsBoundaryFromPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link DeletePermissionsBoundaryFromPermissionSetRequest#builder()}
     * </p>
     *
     * @param deletePermissionsBoundaryFromPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeletePermissionsBoundaryFromPermissionSetRequest.Builder} to create a request.
     * @return Result of the DeletePermissionsBoundaryFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DeletePermissionsBoundaryFromPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionsBoundaryFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePermissionsBoundaryFromPermissionSetResponse deletePermissionsBoundaryFromPermissionSet(
            Consumer<DeletePermissionsBoundaryFromPermissionSetRequest.Builder> deletePermissionsBoundaryFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return deletePermissionsBoundaryFromPermissionSet(DeletePermissionsBoundaryFromPermissionSetRequest.builder()
                .applyMutation(deletePermissionsBoundaryFromPermissionSetRequest).build());
    }

    /**
     * <p>
     * Describes the status of the assignment creation request.
     * </p>
     *
     * @param describeAccountAssignmentCreationStatusRequest
     * @return Result of the DescribeAccountAssignmentCreationStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribeAccountAssignmentCreationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAssignmentCreationStatusResponse describeAccountAssignmentCreationStatus(
            DescribeAccountAssignmentCreationStatusRequest describeAccountAssignmentCreationStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of the assignment creation request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAccountAssignmentCreationStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAccountAssignmentCreationStatusRequest#builder()}
     * </p>
     *
     * @param describeAccountAssignmentCreationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeAccountAssignmentCreationStatusRequest.Builder} to create a request.
     * @return Result of the DescribeAccountAssignmentCreationStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribeAccountAssignmentCreationStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAssignmentCreationStatusResponse describeAccountAssignmentCreationStatus(
            Consumer<DescribeAccountAssignmentCreationStatusRequest.Builder> describeAccountAssignmentCreationStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return describeAccountAssignmentCreationStatus(DescribeAccountAssignmentCreationStatusRequest.builder()
                .applyMutation(describeAccountAssignmentCreationStatusRequest).build());
    }

    /**
     * <p>
     * Describes the status of the assignment deletion request.
     * </p>
     *
     * @param describeAccountAssignmentDeletionStatusRequest
     * @return Result of the DescribeAccountAssignmentDeletionStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribeAccountAssignmentDeletionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAssignmentDeletionStatusResponse describeAccountAssignmentDeletionStatus(
            DescribeAccountAssignmentDeletionStatusRequest describeAccountAssignmentDeletionStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of the assignment deletion request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAccountAssignmentDeletionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAccountAssignmentDeletionStatusRequest#builder()}
     * </p>
     *
     * @param describeAccountAssignmentDeletionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeAccountAssignmentDeletionStatusRequest.Builder} to create a request.
     * @return Result of the DescribeAccountAssignmentDeletionStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribeAccountAssignmentDeletionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAssignmentDeletionStatusResponse describeAccountAssignmentDeletionStatus(
            Consumer<DescribeAccountAssignmentDeletionStatusRequest.Builder> describeAccountAssignmentDeletionStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return describeAccountAssignmentDeletionStatus(DescribeAccountAssignmentDeletionStatusRequest.builder()
                .applyMutation(describeAccountAssignmentDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Returns the list of IAM Identity Center identity store attributes that have been configured to work with
     * attributes-based access control (ABAC) for the specified IAM Identity Center instance. This will not return
     * attributes configured and sent by an external identity provider. For more information about ABAC, see <a
     * href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity Center
     * User Guide</i>.
     * </p>
     *
     * @param describeInstanceAccessControlAttributeConfigurationRequest
     * @return Result of the DescribeInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribeInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAccessControlAttributeConfigurationResponse describeInstanceAccessControlAttributeConfiguration(
            DescribeInstanceAccessControlAttributeConfigurationRequest describeInstanceAccessControlAttributeConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of IAM Identity Center identity store attributes that have been configured to work with
     * attributes-based access control (ABAC) for the specified IAM Identity Center instance. This will not return
     * attributes configured and sent by an external identity provider. For more information about ABAC, see <a
     * href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity Center
     * User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one
     * manually via {@link DescribeInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param describeInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeInstanceAccessControlAttributeConfigurationRequest.Builder} to create a request.
     * @return Result of the DescribeInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribeInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAccessControlAttributeConfigurationResponse describeInstanceAccessControlAttributeConfiguration(
            Consumer<DescribeInstanceAccessControlAttributeConfigurationRequest.Builder> describeInstanceAccessControlAttributeConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        return describeInstanceAccessControlAttributeConfiguration(DescribeInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(describeInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets the details of the permission set.
     * </p>
     *
     * @param describePermissionSetRequest
     * @return Result of the DescribePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePermissionSetResponse describePermissionSet(DescribePermissionSetRequest describePermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePermissionSetRequest#builder()}
     * </p>
     *
     * @param describePermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribePermissionSetRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePermissionSetResponse describePermissionSet(
            Consumer<DescribePermissionSetRequest.Builder> describePermissionSetRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SsoAdminException {
        return describePermissionSet(DescribePermissionSetRequest.builder().applyMutation(describePermissionSetRequest).build());
    }

    /**
     * <p>
     * Describes the status for the given permission set provisioning request.
     * </p>
     *
     * @param describePermissionSetProvisioningStatusRequest
     * @return Result of the DescribePermissionSetProvisioningStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribePermissionSetProvisioningStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePermissionSetProvisioningStatusResponse describePermissionSetProvisioningStatus(
            DescribePermissionSetProvisioningStatusRequest describePermissionSetProvisioningStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status for the given permission set provisioning request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribePermissionSetProvisioningStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribePermissionSetProvisioningStatusRequest#builder()}
     * </p>
     *
     * @param describePermissionSetProvisioningStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribePermissionSetProvisioningStatusRequest.Builder} to create a request.
     * @return Result of the DescribePermissionSetProvisioningStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DescribePermissionSetProvisioningStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePermissionSetProvisioningStatusResponse describePermissionSetProvisioningStatus(
            Consumer<DescribePermissionSetProvisioningStatusRequest.Builder> describePermissionSetProvisioningStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return describePermissionSetProvisioningStatus(DescribePermissionSetProvisioningStatusRequest.builder()
                .applyMutation(describePermissionSetProvisioningStatusRequest).build());
    }

    /**
     * <p>
     * Detaches the specified customer managed policy from the specified <a>PermissionSet</a>.
     * </p>
     *
     * @param detachCustomerManagedPolicyReferenceFromPermissionSetRequest
     * @return Result of the DetachCustomerManagedPolicyReferenceFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DetachCustomerManagedPolicyReferenceFromPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachCustomerManagedPolicyReferenceFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachCustomerManagedPolicyReferenceFromPermissionSetResponse detachCustomerManagedPolicyReferenceFromPermissionSet(
            DetachCustomerManagedPolicyReferenceFromPermissionSetRequest detachCustomerManagedPolicyReferenceFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches the specified customer managed policy from the specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.Builder} avoiding the need to create one
     * manually via {@link DetachCustomerManagedPolicyReferenceFromPermissionSetRequest#builder()}
     * </p>
     *
     * @param detachCustomerManagedPolicyReferenceFromPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.Builder} to create a request.
     * @return Result of the DetachCustomerManagedPolicyReferenceFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DetachCustomerManagedPolicyReferenceFromPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachCustomerManagedPolicyReferenceFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachCustomerManagedPolicyReferenceFromPermissionSetResponse detachCustomerManagedPolicyReferenceFromPermissionSet(
            Consumer<DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.Builder> detachCustomerManagedPolicyReferenceFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        return detachCustomerManagedPolicyReferenceFromPermissionSet(DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
                .builder().applyMutation(detachCustomerManagedPolicyReferenceFromPermissionSetRequest).build());
    }

    /**
     * <p>
     * Detaches the attached AWS managed policy ARN from the specified permission set.
     * </p>
     *
     * @param detachManagedPolicyFromPermissionSetRequest
     * @return Result of the DetachManagedPolicyFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DetachManagedPolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachManagedPolicyFromPermissionSetResponse detachManagedPolicyFromPermissionSet(
            DetachManagedPolicyFromPermissionSetRequest detachManagedPolicyFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches the attached AWS managed policy ARN from the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DetachManagedPolicyFromPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link DetachManagedPolicyFromPermissionSetRequest#builder()}
     * </p>
     *
     * @param detachManagedPolicyFromPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link DetachManagedPolicyFromPermissionSetRequest.Builder}
     *        to create a request.
     * @return Result of the DetachManagedPolicyFromPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.DetachManagedPolicyFromPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachManagedPolicyFromPermissionSetResponse detachManagedPolicyFromPermissionSet(
            Consumer<DetachManagedPolicyFromPermissionSetRequest.Builder> detachManagedPolicyFromPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        return detachManagedPolicyFromPermissionSet(DetachManagedPolicyFromPermissionSetRequest.builder()
                .applyMutation(detachManagedPolicyFromPermissionSetRequest).build());
    }

    /**
     * <p>
     * Obtains the inline policy assigned to the permission set.
     * </p>
     *
     * @param getInlinePolicyForPermissionSetRequest
     * @return Result of the GetInlinePolicyForPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.GetInlinePolicyForPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInlinePolicyForPermissionSetResponse getInlinePolicyForPermissionSet(
            GetInlinePolicyForPermissionSetRequest getInlinePolicyForPermissionSetRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains the inline policy assigned to the permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInlinePolicyForPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link GetInlinePolicyForPermissionSetRequest#builder()}
     * </p>
     *
     * @param getInlinePolicyForPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link GetInlinePolicyForPermissionSetRequest.Builder} to
     *        create a request.
     * @return Result of the GetInlinePolicyForPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.GetInlinePolicyForPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInlinePolicyForPermissionSetResponse getInlinePolicyForPermissionSet(
            Consumer<GetInlinePolicyForPermissionSetRequest.Builder> getInlinePolicyForPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return getInlinePolicyForPermissionSet(GetInlinePolicyForPermissionSetRequest.builder()
                .applyMutation(getInlinePolicyForPermissionSetRequest).build());
    }

    /**
     * <p>
     * Obtains the permissions boundary for a specified <a>PermissionSet</a>.
     * </p>
     *
     * @param getPermissionsBoundaryForPermissionSetRequest
     * @return Result of the GetPermissionsBoundaryForPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.GetPermissionsBoundaryForPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetPermissionsBoundaryForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPermissionsBoundaryForPermissionSetResponse getPermissionsBoundaryForPermissionSet(
            GetPermissionsBoundaryForPermissionSetRequest getPermissionsBoundaryForPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains the permissions boundary for a specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetPermissionsBoundaryForPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link GetPermissionsBoundaryForPermissionSetRequest#builder()}
     * </p>
     *
     * @param getPermissionsBoundaryForPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link GetPermissionsBoundaryForPermissionSetRequest.Builder}
     *        to create a request.
     * @return Result of the GetPermissionsBoundaryForPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.GetPermissionsBoundaryForPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetPermissionsBoundaryForPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPermissionsBoundaryForPermissionSetResponse getPermissionsBoundaryForPermissionSet(
            Consumer<GetPermissionsBoundaryForPermissionSetRequest.Builder> getPermissionsBoundaryForPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return getPermissionsBoundaryForPermissionSet(GetPermissionsBoundaryForPermissionSetRequest.builder()
                .applyMutation(getPermissionsBoundaryForPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment creation requests for a specified IAM Identity Center instance.
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     * @return Result of the ListAccountAssignmentCreationStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentCreationStatusResponse listAccountAssignmentCreationStatus(
            ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment creation requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentCreationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentCreationStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentCreationStatusRequest.Builder} to
     *        create a request.
     * @return Result of the ListAccountAssignmentCreationStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentCreationStatusResponse listAccountAssignmentCreationStatus(
            Consumer<ListAccountAssignmentCreationStatusRequest.Builder> listAccountAssignmentCreationStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusRequest.builder()
                .applyMutation(listAccountAssignmentCreationStatusRequest).build());
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment creation requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusIterable responses = client.listAccountAssignmentCreationStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusIterable responses = client
     *             .listAccountAssignmentCreationStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusIterable responses = client.listAccountAssignmentCreationStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentCreationStatusIterable listAccountAssignmentCreationStatusPaginator(
            ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment creation requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusIterable responses = client.listAccountAssignmentCreationStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusIterable responses = client
     *             .listAccountAssignmentCreationStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentCreationStatusIterable responses = client.listAccountAssignmentCreationStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentCreationStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentCreationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentCreationStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentCreationStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentCreationStatusRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentCreationStatusIterable listAccountAssignmentCreationStatusPaginator(
            Consumer<ListAccountAssignmentCreationStatusRequest.Builder> listAccountAssignmentCreationStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listAccountAssignmentCreationStatusPaginator(ListAccountAssignmentCreationStatusRequest.builder()
                .applyMutation(listAccountAssignmentCreationStatusRequest).build());
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment deletion requests for a specified IAM Identity Center instance.
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     * @return Result of the ListAccountAssignmentDeletionStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentDeletionStatusResponse listAccountAssignmentDeletionStatus(
            ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment deletion requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentDeletionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentDeletionStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentDeletionStatusRequest.Builder} to
     *        create a request.
     * @return Result of the ListAccountAssignmentDeletionStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentDeletionStatusResponse listAccountAssignmentDeletionStatus(
            Consumer<ListAccountAssignmentDeletionStatusRequest.Builder> listAccountAssignmentDeletionStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listAccountAssignmentDeletionStatus(ListAccountAssignmentDeletionStatusRequest.builder()
                .applyMutation(listAccountAssignmentDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment deletion requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusIterable responses = client.listAccountAssignmentDeletionStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusIterable responses = client
     *             .listAccountAssignmentDeletionStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusIterable responses = client.listAccountAssignmentDeletionStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentDeletionStatusIterable listAccountAssignmentDeletionStatusPaginator(
            ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the AWS account assignment deletion requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusIterable responses = client.listAccountAssignmentDeletionStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusIterable responses = client
     *             .listAccountAssignmentDeletionStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentDeletionStatusIterable responses = client.listAccountAssignmentDeletionStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignmentDeletionStatus(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentDeletionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListAccountAssignmentDeletionStatusRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentDeletionStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentDeletionStatusRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignmentDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentDeletionStatusIterable listAccountAssignmentDeletionStatusPaginator(
            Consumer<ListAccountAssignmentDeletionStatusRequest.Builder> listAccountAssignmentDeletionStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listAccountAssignmentDeletionStatusPaginator(ListAccountAssignmentDeletionStatusRequest.builder()
                .applyMutation(listAccountAssignmentDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Lists the assignee of the specified AWS account with the specified permission set.
     * </p>
     *
     * @param listAccountAssignmentsRequest
     * @return Result of the ListAccountAssignments operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentsResponse listAccountAssignments(ListAccountAssignmentsRequest listAccountAssignmentsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assignee of the specified AWS account with the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountAssignmentsRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAccountAssignments operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentsResponse listAccountAssignments(
            Consumer<ListAccountAssignmentsRequest.Builder> listAccountAssignmentsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SsoAdminException {
        return listAccountAssignments(ListAccountAssignmentsRequest.builder().applyMutation(listAccountAssignmentsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the assignee of the specified AWS account with the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsIterable responses = client.listAccountAssignmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsIterable responses = client
     *             .listAccountAssignmentsPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsIterable responses = client.listAccountAssignmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssignmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentsIterable listAccountAssignmentsPaginator(
            ListAccountAssignmentsRequest listAccountAssignmentsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assignee of the specified AWS account with the specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsIterable responses = client.listAccountAssignmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsIterable responses = client
     *             .listAccountAssignmentsPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountAssignmentsIterable responses = client.listAccountAssignmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssignments(software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssignmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccountAssignmentsRequest#builder()}
     * </p>
     *
     * @param listAccountAssignmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountAssignmentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssignmentsIterable listAccountAssignmentsPaginator(
            Consumer<ListAccountAssignmentsRequest.Builder> listAccountAssignmentsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SsoAdminException {
        return listAccountAssignmentsPaginator(ListAccountAssignmentsRequest.builder()
                .applyMutation(listAccountAssignmentsRequest).build());
    }

    /**
     * <p>
     * Lists all the AWS accounts where the specified permission set is provisioned.
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     * @return Result of the ListAccountsForProvisionedPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountsForProvisionedPermissionSetResponse listAccountsForProvisionedPermissionSet(
            ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the AWS accounts where the specified permission set is provisioned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAccountsForProvisionedPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link ListAccountsForProvisionedPermissionSetRequest#builder()}
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListAccountsForProvisionedPermissionSetRequest.Builder} to create a request.
     * @return Result of the ListAccountsForProvisionedPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountsForProvisionedPermissionSetResponse listAccountsForProvisionedPermissionSet(
            Consumer<ListAccountsForProvisionedPermissionSetRequest.Builder> listAccountsForProvisionedPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetRequest.builder()
                .applyMutation(listAccountsForProvisionedPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists all the AWS accounts where the specified permission set is provisioned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetIterable responses = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetIterable responses = client
     *             .listAccountsForProvisionedPermissionSetPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetIterable responses = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountsForProvisionedPermissionSetIterable listAccountsForProvisionedPermissionSetPaginator(
            ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the AWS accounts where the specified permission set is provisioned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetIterable responses = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetIterable responses = client
     *             .listAccountsForProvisionedPermissionSetPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListAccountsForProvisionedPermissionSetIterable responses = client.listAccountsForProvisionedPermissionSetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountsForProvisionedPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAccountsForProvisionedPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link ListAccountsForProvisionedPermissionSetRequest#builder()}
     * </p>
     *
     * @param listAccountsForProvisionedPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListAccountsForProvisionedPermissionSetRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListAccountsForProvisionedPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountsForProvisionedPermissionSetIterable listAccountsForProvisionedPermissionSetPaginator(
            Consumer<ListAccountsForProvisionedPermissionSetRequest.Builder> listAccountsForProvisionedPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listAccountsForProvisionedPermissionSetPaginator(ListAccountsForProvisionedPermissionSetRequest.builder()
                .applyMutation(listAccountsForProvisionedPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists all customer managed policies attached to a specified <a>PermissionSet</a>.
     * </p>
     *
     * @param listCustomerManagedPolicyReferencesInPermissionSetRequest
     * @return Result of the ListCustomerManagedPolicyReferencesInPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListCustomerManagedPolicyReferencesInPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomerManagedPolicyReferencesInPermissionSetResponse listCustomerManagedPolicyReferencesInPermissionSet(
            ListCustomerManagedPolicyReferencesInPermissionSetRequest listCustomerManagedPolicyReferencesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all customer managed policies attached to a specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder} avoiding the need to create one
     * manually via {@link ListCustomerManagedPolicyReferencesInPermissionSetRequest#builder()}
     * </p>
     *
     * @param listCustomerManagedPolicyReferencesInPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder} to create a request.
     * @return Result of the ListCustomerManagedPolicyReferencesInPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListCustomerManagedPolicyReferencesInPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomerManagedPolicyReferencesInPermissionSetResponse listCustomerManagedPolicyReferencesInPermissionSet(
            Consumer<ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder> listCustomerManagedPolicyReferencesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listCustomerManagedPolicyReferencesInPermissionSet(ListCustomerManagedPolicyReferencesInPermissionSetRequest
                .builder().applyMutation(listCustomerManagedPolicyReferencesInPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists all customer managed policies attached to a specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomerManagedPolicyReferencesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetIterable responses = client.listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetIterable responses = client
     *             .listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetIterable responses = client.listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomerManagedPolicyReferencesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomerManagedPolicyReferencesInPermissionSetRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListCustomerManagedPolicyReferencesInPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomerManagedPolicyReferencesInPermissionSetIterable listCustomerManagedPolicyReferencesInPermissionSetPaginator(
            ListCustomerManagedPolicyReferencesInPermissionSetRequest listCustomerManagedPolicyReferencesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all customer managed policies attached to a specified <a>PermissionSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomerManagedPolicyReferencesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetIterable responses = client.listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetIterable responses = client
     *             .listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListCustomerManagedPolicyReferencesInPermissionSetIterable responses = client.listCustomerManagedPolicyReferencesInPermissionSetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomerManagedPolicyReferencesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder} avoiding the need to create one
     * manually via {@link ListCustomerManagedPolicyReferencesInPermissionSetRequest#builder()}
     * </p>
     *
     * @param listCustomerManagedPolicyReferencesInPermissionSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListCustomerManagedPolicyReferencesInPermissionSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomerManagedPolicyReferencesInPermissionSetIterable listCustomerManagedPolicyReferencesInPermissionSetPaginator(
            Consumer<ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder> listCustomerManagedPolicyReferencesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listCustomerManagedPolicyReferencesInPermissionSetPaginator(ListCustomerManagedPolicyReferencesInPermissionSetRequest
                .builder().applyMutation(listCustomerManagedPolicyReferencesInPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the IAM Identity Center instances that the caller has access to.
     * </p>
     *
     * @param listInstancesRequest
     * @return Result of the ListInstances operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM Identity Center instances that the caller has access to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstancesRequest.Builder} to create a request.
     * @return Result of the ListInstances operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesResponse listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, SsoAdminException {
        return listInstances(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Lists the IAM Identity Center instances that the caller has access to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)} operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(ListInstancesRequest listInstancesRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM Identity Center instances that the caller has access to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstancesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, SsoAdminException {
        return listInstancesPaginator(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Lists the AWS managed policy that is attached to a specified permission set.
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     * @return Result of the ListManagedPoliciesInPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedPoliciesInPermissionSetResponse listManagedPoliciesInPermissionSet(
            ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AWS managed policy that is attached to a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedPoliciesInPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedPoliciesInPermissionSetRequest#builder()}
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedPoliciesInPermissionSetRequest.Builder} to
     *        create a request.
     * @return Result of the ListManagedPoliciesInPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedPoliciesInPermissionSetResponse listManagedPoliciesInPermissionSet(
            Consumer<ListManagedPoliciesInPermissionSetRequest.Builder> listManagedPoliciesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetRequest.builder()
                .applyMutation(listManagedPoliciesInPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the AWS managed policy that is attached to a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetIterable responses = client.listManagedPoliciesInPermissionSetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetIterable responses = client
     *             .listManagedPoliciesInPermissionSetPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetIterable responses = client.listManagedPoliciesInPermissionSetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedPoliciesInPermissionSetIterable listManagedPoliciesInPermissionSetPaginator(
            ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AWS managed policy that is attached to a specified permission set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetIterable responses = client.listManagedPoliciesInPermissionSetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetIterable responses = client
     *             .listManagedPoliciesInPermissionSetPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListManagedPoliciesInPermissionSetIterable responses = client.listManagedPoliciesInPermissionSetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedPoliciesInPermissionSet(software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedPoliciesInPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedPoliciesInPermissionSetRequest#builder()}
     * </p>
     *
     * @param listManagedPoliciesInPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedPoliciesInPermissionSetRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListManagedPoliciesInPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedPoliciesInPermissionSetIterable listManagedPoliciesInPermissionSetPaginator(
            Consumer<ListManagedPoliciesInPermissionSetRequest.Builder> listManagedPoliciesInPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listManagedPoliciesInPermissionSetPaginator(ListManagedPoliciesInPermissionSetRequest.builder()
                .applyMutation(listManagedPoliciesInPermissionSetRequest).build());
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     * @return Result of the ListPermissionSetProvisioningStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetProvisioningStatusResponse listPermissionSetProvisioningStatus(
            ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetProvisioningStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListPermissionSetProvisioningStatusRequest#builder()}
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetProvisioningStatusRequest.Builder} to
     *        create a request.
     * @return Result of the ListPermissionSetProvisioningStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetProvisioningStatusResponse listPermissionSetProvisioningStatus(
            Consumer<ListPermissionSetProvisioningStatusRequest.Builder> listPermissionSetProvisioningStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusRequest.builder()
                .applyMutation(listPermissionSetProvisioningStatusRequest).build());
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusIterable responses = client.listPermissionSetProvisioningStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusIterable responses = client
     *             .listPermissionSetProvisioningStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusIterable responses = client.listPermissionSetProvisioningStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetProvisioningStatusIterable listPermissionSetProvisioningStatusPaginator(
            ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusIterable responses = client.listPermissionSetProvisioningStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusIterable responses = client
     *             .listPermissionSetProvisioningStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetProvisioningStatusIterable responses = client.listPermissionSetProvisioningStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetProvisioningStatus(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetProvisioningStatusRequest.Builder}
     * avoiding the need to create one manually via {@link ListPermissionSetProvisioningStatusRequest#builder()}
     * </p>
     *
     * @param listPermissionSetProvisioningStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetProvisioningStatusRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetProvisioningStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetProvisioningStatusIterable listPermissionSetProvisioningStatusPaginator(
            Consumer<ListPermissionSetProvisioningStatusRequest.Builder> listPermissionSetProvisioningStatusRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listPermissionSetProvisioningStatusPaginator(ListPermissionSetProvisioningStatusRequest.builder()
                .applyMutation(listPermissionSetProvisioningStatusRequest).build());
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an IAM Identity Center instance.
     * </p>
     *
     * @param listPermissionSetsRequest
     * @return Result of the ListPermissionSets operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionSetsResponse listPermissionSets(ListPermissionSetsRequest listPermissionSetsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPermissionSetsRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPermissionSets operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionSetsResponse listPermissionSets(Consumer<ListPermissionSetsRequest.Builder> listPermissionSetsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listPermissionSets(ListPermissionSetsRequest.builder().applyMutation(listPermissionSetsRequest).build());
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsIterable responses = client.listPermissionSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsIterable responses = client
     *             .listPermissionSetsPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsIterable responses = client.listPermissionSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionSetsIterable listPermissionSetsPaginator(ListPermissionSetsRequest listPermissionSetsRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the <a>PermissionSet</a>s in an IAM Identity Center instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsIterable responses = client.listPermissionSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsIterable responses = client
     *             .listPermissionSetsPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsIterable responses = client.listPermissionSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSets(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPermissionSetsRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionSetsIterable listPermissionSetsPaginator(
            Consumer<ListPermissionSetsRequest.Builder> listPermissionSetsRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SsoAdminException {
        return listPermissionSetsPaginator(ListPermissionSetsRequest.builder().applyMutation(listPermissionSetsRequest).build());
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified AWS account.
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     * @return Result of the ListPermissionSetsProvisionedToAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetsProvisionedToAccountResponse listPermissionSetsProvisionedToAccount(
            ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPermissionSetsProvisionedToAccountRequest.Builder} avoiding the need to create one manually via
     * {@link ListPermissionSetsProvisionedToAccountRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetsProvisionedToAccountRequest.Builder}
     *        to create a request.
     * @return Result of the ListPermissionSetsProvisionedToAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetsProvisionedToAccountResponse listPermissionSetsProvisionedToAccount(
            Consumer<ListPermissionSetsProvisionedToAccountRequest.Builder> listPermissionSetsProvisionedToAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listPermissionSetsProvisionedToAccount(ListPermissionSetsProvisionedToAccountRequest.builder()
                .applyMutation(listPermissionSetsProvisionedToAccountRequest).build());
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountIterable responses = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountIterable responses = client
     *             .listPermissionSetsProvisionedToAccountPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountIterable responses = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetsProvisionedToAccountIterable listPermissionSetsProvisionedToAccountPaginator(
            ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the permission sets that are provisioned to a specified AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountIterable responses = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountIterable responses = client
     *             .listPermissionSetsProvisionedToAccountPaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListPermissionSetsProvisionedToAccountIterable responses = client.listPermissionSetsProvisionedToAccountPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissionSetsProvisionedToAccount(software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPermissionSetsProvisionedToAccountRequest.Builder} avoiding the need to create one manually via
     * {@link ListPermissionSetsProvisionedToAccountRequest#builder()}
     * </p>
     *
     * @param listPermissionSetsProvisionedToAccountRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionSetsProvisionedToAccountRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListPermissionSetsProvisionedToAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPermissionSetsProvisionedToAccountIterable listPermissionSetsProvisionedToAccountPaginator(
            Consumer<ListPermissionSetsProvisionedToAccountRequest.Builder> listPermissionSetsProvisionedToAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        return listPermissionSetsProvisionedToAccountPaginator(ListPermissionSetsProvisionedToAccountRequest.builder()
                .applyMutation(listPermissionSetsProvisionedToAccountRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SsoAdminException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssoadmin.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SsoAdminException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * The process by which a specified permission set is provisioned to the specified target.
     * </p>
     *
     * @param provisionPermissionSetRequest
     * @return Result of the ProvisionPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ProvisionPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ProvisionPermissionSetResponse provisionPermissionSet(ProvisionPermissionSetRequest provisionPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The process by which a specified permission set is provisioned to the specified target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ProvisionPermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link ProvisionPermissionSetRequest#builder()}
     * </p>
     *
     * @param provisionPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link ProvisionPermissionSetRequest.Builder} to create a
     *        request.
     * @return Result of the ProvisionPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.ProvisionPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ProvisionPermissionSetResponse provisionPermissionSet(
            Consumer<ProvisionPermissionSetRequest.Builder> provisionPermissionSetRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, SsoAdminException {
        return provisionPermissionSet(ProvisionPermissionSetRequest.builder().applyMutation(provisionPermissionSetRequest)
                .build());
    }

    /**
     * <p>
     * Attaches an inline policy to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to
     * all assigned accounts.
     * </p>
     * </note>
     *
     * @param putInlinePolicyToPermissionSetRequest
     * @return Result of the PutInlinePolicyToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.PutInlinePolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default PutInlinePolicyToPermissionSetResponse putInlinePolicyToPermissionSet(
            PutInlinePolicyToPermissionSetRequest putInlinePolicyToPermissionSetRequest) throws ResourceNotFoundException,
            InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an inline policy to a permission set.
     * </p>
     * <note>
     * <p>
     * If the permission set is already referenced by one or more account assignments, you will need to call
     * <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to
     * all assigned accounts.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInlinePolicyToPermissionSetRequest.Builder}
     * avoiding the need to create one manually via {@link PutInlinePolicyToPermissionSetRequest#builder()}
     * </p>
     *
     * @param putInlinePolicyToPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link PutInlinePolicyToPermissionSetRequest.Builder} to
     *        create a request.
     * @return Result of the PutInlinePolicyToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.PutInlinePolicyToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default PutInlinePolicyToPermissionSetResponse putInlinePolicyToPermissionSet(
            Consumer<PutInlinePolicyToPermissionSetRequest.Builder> putInlinePolicyToPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        return putInlinePolicyToPermissionSet(PutInlinePolicyToPermissionSetRequest.builder()
                .applyMutation(putInlinePolicyToPermissionSetRequest).build());
    }

    /**
     * <p>
     * Attaches an AWS managed or customer managed policy to the specified <a>PermissionSet</a> as a permissions
     * boundary.
     * </p>
     *
     * @param putPermissionsBoundaryToPermissionSetRequest
     * @return Result of the PutPermissionsBoundaryToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.PutPermissionsBoundaryToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutPermissionsBoundaryToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default PutPermissionsBoundaryToPermissionSetResponse putPermissionsBoundaryToPermissionSet(
            PutPermissionsBoundaryToPermissionSetRequest putPermissionsBoundaryToPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an AWS managed or customer managed policy to the specified <a>PermissionSet</a> as a permissions
     * boundary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutPermissionsBoundaryToPermissionSetRequest.Builder} avoiding the need to create one manually via
     * {@link PutPermissionsBoundaryToPermissionSetRequest#builder()}
     * </p>
     *
     * @param putPermissionsBoundaryToPermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link PutPermissionsBoundaryToPermissionSetRequest.Builder}
     *        to create a request.
     * @return Result of the PutPermissionsBoundaryToPermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.PutPermissionsBoundaryToPermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutPermissionsBoundaryToPermissionSet"
     *      target="_top">AWS API Documentation</a>
     */
    default PutPermissionsBoundaryToPermissionSetResponse putPermissionsBoundaryToPermissionSet(
            Consumer<PutPermissionsBoundaryToPermissionSetRequest.Builder> putPermissionsBoundaryToPermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        return putPermissionsBoundaryToPermissionSet(PutPermissionsBoundaryToPermissionSetRequest.builder()
                .applyMutation(putPermissionsBoundaryToPermissionSetRequest).build());
    }

    /**
     * <p>
     * Associates a set of tags with a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of tags with a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         Indicates that the principal has crossed the permitted number of resources that can be created.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            SsoAdminException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates a set of tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a set of tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the IAM Identity Center identity store attributes that you can use with the IAM Identity Center instance
     * for attributes-based access control (ABAC). When using an external identity provider as an identity source, you
     * can pass attributes through the SAML assertion as an alternative to configuring attributes from the IAM Identity
     * Center identity store. If a SAML assertion passes any of these attributes, IAM Identity Center replaces the
     * attribute value with the value from the IAM Identity Center identity store. For more information about ABAC, see
     * <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity
     * Center User Guide</i>.
     * </p>
     *
     * @param updateInstanceAccessControlAttributeConfigurationRequest
     * @return Result of the UpdateInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.UpdateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInstanceAccessControlAttributeConfigurationResponse updateInstanceAccessControlAttributeConfiguration(
            UpdateInstanceAccessControlAttributeConfigurationRequest updateInstanceAccessControlAttributeConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the IAM Identity Center identity store attributes that you can use with the IAM Identity Center instance
     * for attributes-based access control (ABAC). When using an external identity provider as an identity source, you
     * can pass attributes through the SAML assertion as an alternative to configuring attributes from the IAM Identity
     * Center identity store. If a SAML assertion passes any of these attributes, IAM Identity Center replaces the
     * attribute value with the value from the IAM Identity Center identity store. For more information about ABAC, see
     * <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity
     * Center User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateInstanceAccessControlAttributeConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link UpdateInstanceAccessControlAttributeConfigurationRequest#builder()}
     * </p>
     *
     * @param updateInstanceAccessControlAttributeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateInstanceAccessControlAttributeConfigurationRequest.Builder} to create a request.
     * @return Result of the UpdateInstanceAccessControlAttributeConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.UpdateInstanceAccessControlAttributeConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInstanceAccessControlAttributeConfigurationResponse updateInstanceAccessControlAttributeConfiguration(
            Consumer<UpdateInstanceAccessControlAttributeConfigurationRequest.Builder> updateInstanceAccessControlAttributeConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        return updateInstanceAccessControlAttributeConfiguration(UpdateInstanceAccessControlAttributeConfigurationRequest
                .builder().applyMutation(updateInstanceAccessControlAttributeConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing permission set.
     * </p>
     *
     * @param updatePermissionSetRequest
     * @return Result of the UpdatePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.UpdatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdatePermissionSetResponse updatePermissionSet(UpdatePermissionSetRequest updatePermissionSetRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing permission set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePermissionSetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePermissionSetRequest#builder()}
     * </p>
     *
     * @param updatePermissionSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePermissionSetRequest.Builder} to create a
     *        request.
     * @return Result of the UpdatePermissionSet operation returned by the service.
     * @throws ResourceNotFoundException
     *         Indicates that a requested resource is not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         Indicates that the principal has crossed the throttling limits of the API operations.
     * @throws ValidationException
     *         The request failed because it contains a syntax error.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsoAdminException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsoAdminClient.UpdatePermissionSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdatePermissionSetResponse updatePermissionSet(
            Consumer<UpdatePermissionSetRequest.Builder> updatePermissionSetRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, SsoAdminException {
        return updatePermissionSet(UpdatePermissionSetRequest.builder().applyMutation(updatePermissionSetRequest).build());
    }

    /**
     * Create a {@link SsoAdminClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsoAdminClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsoAdminClient}.
     */
    static SsoAdminClientBuilder builder() {
        return new DefaultSsoAdminClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
