/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachCustomerManagedPolicyReferenceToPermissionSetRequest extends SsoAdminRequest
        implements
        ToCopyableBuilder<AttachCustomerManagedPolicyReferenceToPermissionSetRequest.Builder, AttachCustomerManagedPolicyReferenceToPermissionSetRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(AttachCustomerManagedPolicyReferenceToPermissionSetRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionSetArn")
            .getter(getter(AttachCustomerManagedPolicyReferenceToPermissionSetRequest::permissionSetArn))
            .setter(setter(Builder::permissionSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()).build();

    private static final SdkField<CustomerManagedPolicyReference> CUSTOMER_MANAGED_POLICY_REFERENCE_FIELD = SdkField
            .<CustomerManagedPolicyReference> builder(MarshallingType.SDK_POJO)
            .memberName("CustomerManagedPolicyReference")
            .getter(getter(AttachCustomerManagedPolicyReferenceToPermissionSetRequest::customerManagedPolicyReference))
            .setter(setter(Builder::customerManagedPolicyReference))
            .constructor(CustomerManagedPolicyReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerManagedPolicyReference")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            PERMISSION_SET_ARN_FIELD, CUSTOMER_MANAGED_POLICY_REFERENCE_FIELD));

    private final String instanceArn;

    private final String permissionSetArn;

    private final CustomerManagedPolicyReference customerManagedPolicyReference;

    private AttachCustomerManagedPolicyReferenceToPermissionSetRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.permissionSetArn = builder.permissionSetArn;
        this.customerManagedPolicyReference = builder.customerManagedPolicyReference;
    }

    /**
     * <p>
     * The ARN of the IAM Identity Center instance under which the operation will be executed.
     * </p>
     * 
     * @return The ARN of the IAM Identity Center instance under which the operation will be executed.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The ARN of the <code>PermissionSet</code>.
     * </p>
     * 
     * @return The ARN of the <code>PermissionSet</code>.
     */
    public final String permissionSetArn() {
        return permissionSetArn;
    }

    /**
     * <p>
     * Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and
     * path in each AWS account where you want to deploy your permission set.
     * </p>
     * 
     * @return Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the
     *         name and path in each AWS account where you want to deploy your permission set.
     */
    public final CustomerManagedPolicyReference customerManagedPolicyReference() {
        return customerManagedPolicyReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedPolicyReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachCustomerManagedPolicyReferenceToPermissionSetRequest)) {
            return false;
        }
        AttachCustomerManagedPolicyReferenceToPermissionSetRequest other = (AttachCustomerManagedPolicyReferenceToPermissionSetRequest) obj;
        return Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(permissionSetArn(), other.permissionSetArn())
                && Objects.equals(customerManagedPolicyReference(), other.customerManagedPolicyReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachCustomerManagedPolicyReferenceToPermissionSetRequest").add("InstanceArn", instanceArn())
                .add("PermissionSetArn", permissionSetArn())
                .add("CustomerManagedPolicyReference", customerManagedPolicyReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "PermissionSetArn":
            return Optional.ofNullable(clazz.cast(permissionSetArn()));
        case "CustomerManagedPolicyReference":
            return Optional.ofNullable(clazz.cast(customerManagedPolicyReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachCustomerManagedPolicyReferenceToPermissionSetRequest, T> g) {
        return obj -> g.apply((AttachCustomerManagedPolicyReferenceToPermissionSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AttachCustomerManagedPolicyReferenceToPermissionSetRequest> {
        /**
         * <p>
         * The ARN of the IAM Identity Center instance under which the operation will be executed.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the IAM Identity Center instance under which the operation will be executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The ARN of the <code>PermissionSet</code>.
         * </p>
         * 
         * @param permissionSetArn
         *        The ARN of the <code>PermissionSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionSetArn(String permissionSetArn);

        /**
         * <p>
         * Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name
         * and path in each AWS account where you want to deploy your permission set.
         * </p>
         * 
         * @param customerManagedPolicyReference
         *        Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the
         *        name and path in each AWS account where you want to deploy your permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedPolicyReference(CustomerManagedPolicyReference customerManagedPolicyReference);

        /**
         * <p>
         * Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name
         * and path in each AWS account where you want to deploy your permission set.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerManagedPolicyReference.Builder}
         * avoiding the need to create one manually via {@link CustomerManagedPolicyReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerManagedPolicyReference.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customerManagedPolicyReference(CustomerManagedPolicyReference)}.
         * 
         * @param customerManagedPolicyReference
         *        a consumer that will call methods on {@link CustomerManagedPolicyReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerManagedPolicyReference(CustomerManagedPolicyReference)
         */
        default Builder customerManagedPolicyReference(
                Consumer<CustomerManagedPolicyReference.Builder> customerManagedPolicyReference) {
            return customerManagedPolicyReference(CustomerManagedPolicyReference.builder()
                    .applyMutation(customerManagedPolicyReference).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String instanceArn;

        private String permissionSetArn;

        private CustomerManagedPolicyReference customerManagedPolicyReference;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachCustomerManagedPolicyReferenceToPermissionSetRequest model) {
            super(model);
            instanceArn(model.instanceArn);
            permissionSetArn(model.permissionSetArn);
            customerManagedPolicyReference(model.customerManagedPolicyReference);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getPermissionSetArn() {
            return permissionSetArn;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final CustomerManagedPolicyReference.Builder getCustomerManagedPolicyReference() {
            return customerManagedPolicyReference != null ? customerManagedPolicyReference.toBuilder() : null;
        }

        public final void setCustomerManagedPolicyReference(
                CustomerManagedPolicyReference.BuilderImpl customerManagedPolicyReference) {
            this.customerManagedPolicyReference = customerManagedPolicyReference != null ? customerManagedPolicyReference.build()
                    : null;
        }

        @Override
        public final Builder customerManagedPolicyReference(CustomerManagedPolicyReference customerManagedPolicyReference) {
            this.customerManagedPolicyReference = customerManagedPolicyReference;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachCustomerManagedPolicyReferenceToPermissionSetRequest build() {
            return new AttachCustomerManagedPolicyReferenceToPermissionSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
