/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Web Services Single Sign On (SSO) is a cloud SSO service that makes it easy to centrally manage SSO access to
 * multiple Amazon Web Services accounts and business applications. This guide provides information on SSO operations
 * which could be used for access management of Amazon Web Services accounts. For information about Amazon Web Services
 * SSO features, see the <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html">Amazon Web
 * Services Single Sign-On User Guide</a>.
 * </p>
 * <p>
 * Many operations in the SSO APIs rely on identifiers for users and groups, known as principals. For more information
 * about how to work with principals and principal IDs in Amazon Web Services SSO, see the <a
 * href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO
 * Identity Store API Reference</a>.
 * </p>
 */
package software.amazon.awssdk.services.ssoadmin;