/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.AccessControlAttributeValueSourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessControlAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessControlAttributeValue> {
    private static final SdkField<List<String>> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Source").getter(AccessControlAttributeValue.getter(AccessControlAttributeValue::source)).setter(AccessControlAttributeValue.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> source;

    private AccessControlAttributeValue(BuilderImpl builder) {
        this.source = builder.source;
    }

    public final boolean hasSource() {
        return this.source != null && !(this.source instanceof SdkAutoConstructList);
    }

    public final List<String> source() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSource() ? this.source() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControlAttributeValue)) {
            return false;
        }
        AccessControlAttributeValue other = (AccessControlAttributeValue)obj;
        return this.hasSource() == other.hasSource() && Objects.equals(this.source(), other.source());
    }

    public final String toString() {
        return ToString.builder((String)"AccessControlAttributeValue").add("Source", this.hasSource() ? this.source() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessControlAttributeValue, T> g) {
        return obj -> g.apply((AccessControlAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> source = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControlAttributeValue model) {
            this.source(model.source);
        }

        public final Collection<String> getSource() {
            if (this.source instanceof SdkAutoConstructList) {
                return null;
            }
            return this.source;
        }

        public final void setSource(Collection<String> source) {
            this.source = AccessControlAttributeValueSourceListCopier.copy(source);
        }

        @Override
        @Transient
        public final Builder source(Collection<String> source) {
            this.source = AccessControlAttributeValueSourceListCopier.copy(source);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder source(String ... source) {
            this.source(Arrays.asList(source));
            return this;
        }

        public AccessControlAttributeValue build() {
            return new AccessControlAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessControlAttributeValue> {
        public Builder source(Collection<String> var1);

        public Builder source(String ... var1);
    }
}

